/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.permission;

import android.support.annotation.VisibleForTesting;

@VisibleForTesting
public abstract class ShellCommand {
    private static final String SAFE_PUNCTUATION = "@%-_+:,./";

    static String shellEscape(String word) {
        int len = word.length();
        if (len == 0) {
            return "''";
        }
        for (int ii = 0; ii < len; ++ii) {
            char c = word.charAt(ii);
            if (Character.isLetterOrDigit(c) || SAFE_PUNCTUATION.indexOf(c) != -1) continue;
            String string = word.replace("'", "'\\''");
            return new StringBuilder(2 + String.valueOf(string).length()).append("'").append(string).append("'").toString();
        }
        return word;
    }

    abstract void execute() throws Exception;
}

