/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.permission;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.test.runner.permission.RequestPermissionCallable;
import android.support.test.runner.permission.ShellCommand;
import android.util.Log;

class GrantPermissionCallable
extends RequestPermissionCallable {
    private static final String TAG = "GrantPermissionCallable";

    GrantPermissionCallable(@NonNull ShellCommand shellCommand, @NonNull Context context, String permission) {
        super(shellCommand, context, permission);
    }

    @Override
    public RequestPermissionCallable.Result call() throws Exception {
        if (this.isPermissionGranted()) {
            String string = this.getPermission();
            Log.i((String)TAG, (String)new StringBuilder(32 + String.valueOf(string).length()).append("Permission: ").append(string).append(" is already granted!").toString());
            return RequestPermissionCallable.Result.SUCCESS;
        }
        ShellCommand cmdForPermission = this.getShellCommand();
        try {
            cmdForPermission.execute();
        }
        finally {
            if (!this.isPermissionGranted()) {
                Thread.sleep(1000L);
                if (!this.isPermissionGranted()) {
                    String string = this.getPermission();
                    Log.e((String)TAG, (String)new StringBuilder(31 + String.valueOf(string).length()).append("Permission: ").append(string).append(" cannot be granted!").toString());
                    return RequestPermissionCallable.Result.FAILURE;
                }
            }
        }
        return RequestPermissionCallable.Result.SUCCESS;
    }
}

