/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.support.test.internal.runner.AndroidRunnerBuilder;
import android.support.test.internal.runner.NonExecutingRunner;
import android.support.test.internal.runner.junit3.JUnit38ClassRunner;
import android.support.test.internal.runner.junit3.NonExecutingTestSuite;
import android.support.test.internal.util.AndroidRunnerBuilderUtil;
import android.support.test.internal.util.AndroidRunnerParams;
import android.support.test.internal.util.Checks;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

class AndroidLogOnlyBuilder
extends RunnerBuilder {
    private final AndroidRunnerBuilder mBuilder;
    private final AndroidRunnerParams mRunnerParams;
    private final boolean mScanningPath;
    private int mRunnerCount = 0;

    AndroidLogOnlyBuilder(AndroidRunnerParams runnerParams, boolean scanningPath, List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        this.mRunnerParams = (AndroidRunnerParams)Checks.checkNotNull((Object)runnerParams, (Object)"runnerParams cannot be null!");
        this.mScanningPath = scanningPath;
        this.mBuilder = new AndroidRunnerBuilder(this, runnerParams, scanningPath, customRunnerBuilderClasses);
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        ++this.mRunnerCount;
        if (AndroidRunnerBuilderUtil.isJUnit3Test(testClass)) {
            if (this.mScanningPath && !AndroidRunnerBuilderUtil.hasJUnit3TestMethod(testClass)) {
                return null;
            }
            return new JUnit38ClassRunner((Test)new NonExecutingTestSuite(testClass));
        }
        if (AndroidRunnerBuilderUtil.hasSuiteMethod(testClass)) {
            if (this.mRunnerParams.isIgnoreSuiteMethods()) {
                return null;
            }
            Test test = SuiteMethod.testFromSuiteMethod(testClass);
            if (!(test instanceof TestSuite)) {
                throw new IllegalArgumentException(String.valueOf(testClass.getName()).concat("#suite() did not return a TestSuite"));
            }
            return new JUnit38ClassRunner((Test)new NonExecutingTestSuite((TestSuite)test));
        }
        int oldRunnerCount = this.mRunnerCount;
        Runner runner = this.mBuilder.runnerForClass(testClass);
        if (null == runner) {
            return null;
        }
        if (runner instanceof ErrorReportingRunner) {
            return runner;
        }
        if (this.mRunnerCount > oldRunnerCount) {
            return runner;
        }
        return new NonExecutingRunner(runner);
    }
}

