/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.orchestrator.listeners;

import android.os.Environment;
import android.support.test.orchestrator.junit.ParcelableDescription;
import android.support.test.orchestrator.junit.ParcelableFailure;
import android.support.test.orchestrator.junit.ParcelableResult;
import android.support.test.orchestrator.listeners.OrchestrationRunListener;
import android.support.test.orchestrator.listeners.result.TestIdentifier;
import android.support.test.orchestrator.listeners.result.TestResult;
import android.support.test.orchestrator.listeners.result.TestRunResult;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.kxml2.io.KXmlSerializer;

public class OrchestrationXmlTestRunListener
extends OrchestrationRunListener {
    private static final String LOG_TAG = "OrchestrationXmlTestRunListener";
    private static final String TEST_RESULT_FILE_SUFFIX = ".xml";
    private static final String TEST_RESULT_FILE_PREFIX = "test_result_";
    private static final String UTF_8 = "UTF-8";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String SKIPPED_TAG = "skipped";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_START_TIME = "start-time";
    private static final String ATTR_END_TIME = "end-time";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_SKIPPED = "skipped";
    private static final String ATTR_ASSERTIOMS = "assertions";
    private static final String ATTR_TESTS = "tests";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOSTNAME = "hostname";
    private static final String ns = null;
    private String mHostName = "localhost";
    public static final String REPORT_DIRECTORY_NAME = "odo";
    private File mReportDir = new File(Environment.getExternalStorageDirectory(), "odo");
    private String mReportPath = "";
    private TestRunResult mRunResult = new TestRunResult();
    private int mNumTests = 0;
    private long startTime;
    private long finishTime;

    public void setReportDir(File file) {
        this.mReportDir = file;
    }

    public void setHostName(String hostName) {
        this.mHostName = hostName;
    }

    public TestRunResult getRunResult() {
        return this.mRunResult;
    }

    @Override
    public void orchestrationRunStarted(int testCount) {
        this.startTime = System.currentTimeMillis();
        this.mRunResult = new TestRunResult();
        this.mNumTests = testCount;
        this.mRunResult.testRunStarted("", this.mNumTests);
    }

    @Override
    public void testRunStarted(ParcelableDescription description) {
    }

    @Override
    public void testStarted(ParcelableDescription description) {
        this.mRunResult.testStarted(OrchestrationXmlTestRunListener.toTestIdentifier(description));
    }

    @Override
    public void testFinished(ParcelableDescription description) {
        this.mRunResult.testEnded(OrchestrationXmlTestRunListener.toTestIdentifier(description), new HashMap<String, String>());
    }

    @Override
    public void testFailure(ParcelableFailure failure) {
        this.mRunResult.testFailed(OrchestrationXmlTestRunListener.toTestIdentifier(failure.getDescription()), failure.getTrace());
    }

    @Override
    public void testAssumptionFailure(ParcelableFailure failure) {
        this.mRunResult.testAssumptionFailure(OrchestrationXmlTestRunListener.toTestIdentifier(failure.getDescription()), failure.getTrace());
    }

    @Override
    public void testIgnored(ParcelableDescription description) {
        this.mRunResult.testIgnored(OrchestrationXmlTestRunListener.toTestIdentifier(description));
    }

    @Override
    public void testRunFinished(ParcelableResult result) {
    }

    @Override
    public void testProcessFinished(String message) {
    }

    public void orchestrationRunFinished() {
        this.finishTime = System.currentTimeMillis();
        long elapsedTime = this.finishTime - this.startTime;
        this.mRunResult.testRunEnded(elapsedTime, new HashMap<String, String>());
        this.generateDocument(this.mReportDir, elapsedTime);
    }

    private static TestIdentifier toTestIdentifier(ParcelableDescription description) {
        return new TestIdentifier(description.getClassName(), description.getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDocument(File reportDir, long elapsedTime) {
        String timestamp = this.getTimestamp();
        OutputStream stream = null;
        try {
            stream = this.createOutputResultStream(reportDir);
            KXmlSerializer serializer = new KXmlSerializer();
            serializer.setOutput(stream, UTF_8);
            serializer.startDocument(UTF_8, null);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            this.printTestResults(serializer, timestamp, elapsedTime);
            serializer.endDocument();
            String msg = String.format("XML test result file generated at %s. %s", this.getAbsoluteReportPath(), this.mRunResult.getTextSummary());
            Log.i((String)LOG_TAG, (String)msg);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Failed to generate report data", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getAbsoluteReportPath() {
        return this.mReportPath;
    }

    String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
        TimeZone gmt = TimeZone.getTimeZone("UTC");
        dateFormat.setTimeZone(gmt);
        dateFormat.setLenient(true);
        String timestamp = dateFormat.format(new Date());
        return timestamp;
    }

    protected File getResultFile(File reportDir) throws IOException {
        File reportFile = File.createTempFile(TEST_RESULT_FILE_PREFIX, TEST_RESULT_FILE_SUFFIX, reportDir);
        Log.i((String)LOG_TAG, (String)String.format("Created xml report file at %s", reportFile.getAbsolutePath()));
        return reportFile;
    }

    OutputStream createOutputResultStream(File reportDir) throws IOException {
        if (!reportDir.exists() && !reportDir.mkdirs()) {
            throw new IOException("Failed to prepare report directory.");
        }
        File reportFile = this.getResultFile(reportDir);
        this.mReportPath = reportFile.getAbsolutePath();
        return new BufferedOutputStream(new FileOutputStream(reportFile));
    }

    protected String getTestSuiteName() {
        return this.mRunResult.getName();
    }

    void printTestResults(KXmlSerializer serializer, String timestamp, long elapsedTime) throws IOException {
        serializer.startTag(ns, TESTSUITE);
        String name = this.getTestSuiteName();
        if (name != null) {
            serializer.attribute(ns, ATTR_NAME, name);
        }
        serializer.attribute(ns, ATTR_TESTS, Integer.toString(this.mRunResult.getNumTests()));
        serializer.attribute(ns, ATTR_FAILURES, Integer.toString(this.mRunResult.getNumAllFailedTests()));
        serializer.attribute(ns, ATTR_ERRORS, "0");
        serializer.attribute(ns, "skipped", Integer.toString(this.mRunResult.getNumTestsInState(TestResult.TestStatus.IGNORED)));
        serializer.attribute(ns, ATTR_TIME, Double.toString((double)elapsedTime / 1000.0));
        serializer.attribute(ns, TIMESTAMP, timestamp);
        serializer.attribute(ns, HOSTNAME, this.mHostName);
        serializer.startTag(ns, PROPERTIES);
        serializer.endTag(ns, PROPERTIES);
        Map<TestIdentifier, TestResult> testResults = this.mRunResult.getTestResults();
        for (Map.Entry<TestIdentifier, TestResult> testEntry : testResults.entrySet()) {
            this.print(serializer, testEntry.getKey(), testEntry.getValue());
        }
        serializer.endTag(ns, TESTSUITE);
    }

    protected String getTestName(TestIdentifier testId) {
        return testId.getTestName();
    }

    void print(KXmlSerializer serializer, TestIdentifier testId, TestResult testResult) throws IOException {
        serializer.startTag(ns, TESTCASE);
        serializer.attribute(ns, ATTR_NAME, this.getTestName(testId));
        serializer.attribute(ns, ATTR_CLASSNAME, testId.getClassName());
        serializer.attribute(ns, ATTR_START_TIME, String.format("%.3f", (double)testResult.getStartTime() / 1000.0));
        serializer.attribute(ns, ATTR_END_TIME, String.format("%.3f", (double)testResult.getEndTime() / 1000.0));
        long elapsedTimeMs = testResult.getEndTime() - testResult.getStartTime();
        serializer.attribute(ns, ATTR_TIME, Double.toString((double)elapsedTimeMs / 1000.0));
        switch (testResult.getStatus()) {
            case FAILURE: {
                this.printFailedTest(serializer, FAILURE, testResult.getStackTrace());
                break;
            }
            case ASSUMPTION_FAILURE: {
                this.printFailedTest(serializer, "skipped", testResult.getStackTrace());
                break;
            }
            case IGNORED: {
                serializer.startTag(ns, "skipped");
                serializer.endTag(ns, "skipped");
                break;
            }
        }
        serializer.endTag(ns, TESTCASE);
    }

    private void printFailedTest(KXmlSerializer serializer, String tag, String stack) throws IOException {
        serializer.startTag(ns, tag);
        serializer.text(this.sanitize(stack));
        serializer.endTag(ns, tag);
    }

    private String sanitize(String text) {
        return text.replace("\u0000", "<\\0>");
    }
}

