/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.orchestrator.listeners;

import android.support.test.orchestrator.junit.ParcelableDescription;
import android.support.test.orchestrator.junit.ParcelableFailure;
import android.support.test.orchestrator.listeners.OrchestrationRunListener;
import java.util.ArrayList;
import java.util.List;

public final class OrchestrationResult {
    private final long runCount;
    private final long expectedCount;
    private final long startTime;
    private final long finishTime;
    private final List<ParcelableFailure> failures;

    OrchestrationResult(long runCount, long expectedCount, long startTime, long finishTime, List<ParcelableFailure> failures) {
        this.failures = failures;
        this.runCount = runCount;
        this.expectedCount = expectedCount;
        this.startTime = startTime;
        this.finishTime = finishTime;
    }

    public long getRunTime() {
        return this.finishTime - this.startTime;
    }

    public boolean wasSuccessful() {
        return this.getFailureCount() == 0 && this.getRunCount() == this.getExpectedCount();
    }

    public long getRunCount() {
        return this.runCount;
    }

    public long getExpectedCount() {
        return this.expectedCount;
    }

    public int getFailureCount() {
        return this.failures.size();
    }

    public List<ParcelableFailure> getFailures() {
        return this.failures;
    }

    public static final class Builder
    extends OrchestrationRunListener {
        private long runCount = 0L;
        private long expectedCount;
        private long ignoredCount = 0L;
        private long startTime;
        private long finishTime;
        private final List<ParcelableFailure> failures = new ArrayList<ParcelableFailure>();

        @Override
        public void orchestrationRunStarted(int testCount) {
            this.expectedCount = testCount;
            this.startTime = System.currentTimeMillis();
        }

        public void orchestrationRunFinished() {
            this.finishTime = System.currentTimeMillis();
        }

        @Override
        public void testStarted(ParcelableDescription description) {
            ++this.runCount;
        }

        @Override
        public void testFailure(ParcelableFailure failure) {
            this.failures.add(failure);
        }

        @Override
        public void testIgnored(ParcelableDescription description) {
            ++this.ignoredCount;
        }

        public OrchestrationResult build() {
            return new OrchestrationResult(this.runCount, this.expectedCount - this.ignoredCount, this.startTime, this.finishTime, this.failures);
        }
    }
}

