/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.orchestrator.junit;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.test.orchestrator.junit.ParcelableDescription;
import android.util.Log;
import org.junit.runner.notification.Failure;

public final class ParcelableFailure
implements Parcelable {
    private static final String TAG = "ParcelableFailure";
    private static final int MAX_STREAM_LENGTH = 16384;
    private final ParcelableDescription mDescription;
    private final String mTrace;
    public static final Parcelable.Creator<ParcelableFailure> CREATOR = new Parcelable.Creator<ParcelableFailure>(){

        public ParcelableFailure createFromParcel(Parcel in) {
            return new ParcelableFailure(in);
        }

        public ParcelableFailure[] newArray(int size) {
            return new ParcelableFailure[size];
        }
    };

    public ParcelableFailure(Failure failure) {
        this.mDescription = new ParcelableDescription(failure.getDescription());
        this.mTrace = failure.getTrace();
    }

    private ParcelableFailure(Parcel in) {
        this.mDescription = (ParcelableDescription)in.readParcelable(ParcelableDescription.class.getClassLoader());
        this.mTrace = in.readString();
    }

    public ParcelableFailure(ParcelableDescription description, Throwable t) {
        this.mDescription = description;
        this.mTrace = ParcelableFailure.trimToLength(t.getMessage());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.mDescription, 0);
        out.writeString(this.mTrace);
    }

    private static String trimToLength(String trace) {
        if (trace.length() > 16384) {
            Log.i((String)TAG, (String)String.format("Stack trace too long, trimmed to first %s characters.", 16384));
            return String.valueOf(trace.substring(0, 16384)).concat("\n");
        }
        return String.valueOf(trace).concat("\n");
    }

    public String getTrace() {
        return this.mTrace;
    }

    public ParcelableDescription getDescription() {
        return this.mDescription;
    }
}

