/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public final class ProcessUtil {
    private static final String TAG = "ProcessUtil";

    public static String getCurrentProcessName(Context context) {
        String processName = ProcessUtil.getCurrentProcessNameUsingActivityManager(context);
        if (processName.isEmpty()) {
            Log.w((String)TAG, (String)"Could not figure out process name using ActivityManager, falling back to use /proc. Note that processName fetched from /proc may be truncated!");
            processName = ProcessUtil.getCurrentProcessNameUsingProc();
            if (processName.isEmpty()) {
                Log.w((String)TAG, (String)"Could not figure out process name /proc either");
            }
        }
        return processName;
    }

    @VisibleForTesting
    static String getCurrentProcessNameUsingActivityManager(Context context) {
        int pid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : activityManager.getRunningAppProcesses()) {
                if (processInfo.pid != pid) continue;
                return processInfo.processName;
            }
            Log.w((String)TAG, (String)"ActivityManager is null when not expected to be!");
        } else {
            Log.w((String)TAG, (String)new StringBuilder(89).append("ActivityManager#getRunningAppProcesses did not return an entry matching pid = ").append(pid).toString());
        }
        return "";
    }

    @VisibleForTesting
    static String getCurrentProcessNameUsingProc() {
        BufferedReader br = null;
        String processName = "";
        try {
            br = new BufferedReader(new FileReader("/proc/self/cmdline"));
            processName = br.readLine().trim();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return processName;
    }
}

