/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content.res;

import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.res.ConfigurationHelperDonut;
import android.support.v4.content.res.ConfigurationHelperHoneycombMr2;
import android.support.v4.content.res.ConfigurationHelperJellybeanMr1;

public final class ConfigurationHelper {
    private static final ConfigurationHelperImpl IMPL;

    private ConfigurationHelper() {
    }

    public static int getScreenHeightDp(@NonNull Resources resources) {
        return IMPL.getScreenHeightDp(resources);
    }

    public static int getScreenWidthDp(@NonNull Resources resources) {
        return IMPL.getScreenWidthDp(resources);
    }

    public static int getSmallestScreenWidthDp(@NonNull Resources resources) {
        return IMPL.getSmallestScreenWidthDp(resources);
    }

    public static int getDensityDpi(@NonNull Resources resources) {
        return IMPL.getDensityDpi(resources);
    }

    static {
        int sdk = Build.VERSION.SDK_INT;
        IMPL = sdk >= 17 ? new JellybeanMr1Impl() : (sdk >= 13 ? new HoneycombMr2Impl() : new DonutImpl());
    }

    private static class JellybeanMr1Impl
    extends HoneycombMr2Impl {
        private JellybeanMr1Impl() {
        }

        @Override
        public int getDensityDpi(@NonNull Resources resources) {
            return ConfigurationHelperJellybeanMr1.getDensityDpi((Resources)resources);
        }
    }

    private static class HoneycombMr2Impl
    extends DonutImpl {
        private HoneycombMr2Impl() {
        }

        @Override
        public int getScreenHeightDp(@NonNull Resources resources) {
            return ConfigurationHelperHoneycombMr2.getScreenHeightDp((Resources)resources);
        }

        @Override
        public int getScreenWidthDp(@NonNull Resources resources) {
            return ConfigurationHelperHoneycombMr2.getScreenWidthDp((Resources)resources);
        }

        @Override
        public int getSmallestScreenWidthDp(@NonNull Resources resources) {
            return ConfigurationHelperHoneycombMr2.getSmallestScreenWidthDp((Resources)resources);
        }
    }

    private static class DonutImpl
    implements ConfigurationHelperImpl {
        private DonutImpl() {
        }

        @Override
        public int getScreenHeightDp(@NonNull Resources resources) {
            return ConfigurationHelperDonut.getScreenHeightDp((Resources)resources);
        }

        @Override
        public int getScreenWidthDp(@NonNull Resources resources) {
            return ConfigurationHelperDonut.getScreenWidthDp((Resources)resources);
        }

        @Override
        public int getSmallestScreenWidthDp(@NonNull Resources resources) {
            return ConfigurationHelperDonut.getSmallestScreenWidthDp((Resources)resources);
        }

        @Override
        public int getDensityDpi(@NonNull Resources resources) {
            return ConfigurationHelperDonut.getDensityDpi((Resources)resources);
        }
    }

    private static interface ConfigurationHelperImpl {
        public int getScreenHeightDp(@NonNull Resources var1);

        public int getScreenWidthDp(@NonNull Resources var1);

        public int getSmallestScreenWidthDp(@NonNull Resources var1);

        public int getDensityDpi(@NonNull Resources var1);
    }
}

