/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.v13.view.DragAndDropPermissionsCompatApi24;
import android.support.v4.os.BuildCompat;
import android.view.DragEvent;

@RequiresApi(value=13)
@TargetApi(value=13)
public final class DragAndDropPermissionsCompat {
    private static DragAndDropPermissionsCompatImpl IMPL = BuildCompat.isAtLeastN() ? new Api24DragAndDropPermissionsCompatImpl() : new BaseDragAndDropPermissionsCompatImpl();
    private Object mDragAndDropPermissions;

    private DragAndDropPermissionsCompat(Object dragAndDropPermissions) {
        this.mDragAndDropPermissions = dragAndDropPermissions;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DragAndDropPermissionsCompat request(Activity activity, DragEvent dragEvent) {
        Object dragAndDropPermissions = IMPL.request(activity, dragEvent);
        if (dragAndDropPermissions != null) {
            return new DragAndDropPermissionsCompat(dragAndDropPermissions);
        }
        return null;
    }

    public void release() {
        IMPL.release(this.mDragAndDropPermissions);
    }

    static class Api24DragAndDropPermissionsCompatImpl
    extends BaseDragAndDropPermissionsCompatImpl {
        Api24DragAndDropPermissionsCompatImpl() {
        }

        @Override
        public Object request(Activity activity, DragEvent dragEvent) {
            return DragAndDropPermissionsCompatApi24.request(activity, dragEvent);
        }

        @Override
        public void release(Object dragAndDropPermissions) {
            DragAndDropPermissionsCompatApi24.release(dragAndDropPermissions);
        }
    }

    static class BaseDragAndDropPermissionsCompatImpl
    implements DragAndDropPermissionsCompatImpl {
        BaseDragAndDropPermissionsCompatImpl() {
        }

        @Override
        public Object request(Activity activity, DragEvent dragEvent) {
            return null;
        }

        @Override
        public void release(Object dragAndDropPermissions) {
        }
    }

    static interface DragAndDropPermissionsCompatImpl {
        public Object request(Activity var1, DragEvent var2);

        public void release(Object var1);
    }
}

