/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Typeface;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.v4.graphics.TypefaceCompatBaseImpl;
import android.support.v4.provider.FontsContractCompat;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
class TypefaceCompatApi21Impl
extends TypefaceCompatBaseImpl {
    private static final String TAG = "TypefaceCompatApi21Impl";

    TypefaceCompatApi21Impl() {
    }

    private File getFile(ParcelFileDescriptor fd) {
        try {
            String path = Os.readlink((String)("/proc/self/fd/" + fd.getFd()));
            if (OsConstants.S_ISREG((int)Os.stat((String)path).st_mode)) {
                return new File(path);
            }
            return null;
        }
        catch (ErrnoException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Typeface createFromFontInfo(Context context, CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, int style) {
        if (fonts.length < 1) {
            return null;
        }
        FontsContractCompat.FontInfo bestFont = this.findBestInfo(fonts, style);
        ContentResolver resolver = context.getContentResolver();
        try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(bestFont.getUri(), "r", cancellationSignal);){
            File file = this.getFile(pfd);
            if (file == null || !file.canRead()) {
                try (FileInputStream fis = new FileInputStream(pfd.getFileDescriptor());){
                    Typeface typeface = super.createFromInputStream(context, fis);
                    return typeface;
                }
            }
            Typeface typeface = Typeface.createFromFile((File)file);
            return typeface;
        }
        catch (IOException e) {
            return null;
        }
    }
}

