/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.drawable;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;

public class IconCompat {
    private static final float ADAPTIVE_ICON_INSET_FACTOR = 0.25f;
    private static final float DEFAULT_VIEW_PORT_SCALE = 0.6666667f;
    private static final float ICON_DIAMETER_FACTOR = 0.9166667f;
    private static final float BLUR_FACTOR = 0.010416667f;
    private static final float KEY_SHADOW_OFFSET_FACTOR = 0.020833334f;
    private static final int KEY_SHADOW_ALPHA = 61;
    private static final int AMBIENT_SHADOW_ALPHA = 30;
    private static final int TYPE_BITMAP = 1;
    private static final int TYPE_RESOURCE = 2;
    private static final int TYPE_DATA = 3;
    private static final int TYPE_URI = 4;
    private static final int TYPE_ADAPTIVE_BITMAP = 5;
    private final int mType;
    private Object mObj1;
    private int mInt1;
    private int mInt2;

    public static IconCompat createWithResource(Context context, @DrawableRes int resId) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        IconCompat rep = new IconCompat(2);
        rep.mInt1 = resId;
        rep.mObj1 = context;
        return rep;
    }

    public static IconCompat createWithBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        IconCompat rep = new IconCompat(1);
        rep.mObj1 = bits;
        return rep;
    }

    public static IconCompat createWithAdaptiveBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        IconCompat rep = new IconCompat(5);
        rep.mObj1 = bits;
        return rep;
    }

    public static IconCompat createWithData(byte[] data, int offset, int length) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        IconCompat rep = new IconCompat(3);
        rep.mObj1 = data;
        rep.mInt1 = offset;
        rep.mInt2 = length;
        return rep;
    }

    public static IconCompat createWithContentUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        IconCompat rep = new IconCompat(4);
        rep.mObj1 = uri;
        return rep;
    }

    public static IconCompat createWithContentUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        return IconCompat.createWithContentUri(uri.toString());
    }

    private IconCompat(int mType) {
        this.mType = mType;
    }

    @RequiresApi(value=23)
    public Icon toIcon() {
        switch (this.mType) {
            case 1: {
                return Icon.createWithBitmap((Bitmap)((Bitmap)this.mObj1));
            }
            case 5: {
                if (Build.VERSION.SDK_INT >= 26) {
                    return Icon.createWithAdaptiveBitmap((Bitmap)((Bitmap)this.mObj1));
                }
                return Icon.createWithBitmap((Bitmap)IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1, false));
            }
            case 2: {
                return Icon.createWithResource((Context)((Context)this.mObj1), (int)this.mInt1);
            }
            case 3: {
                return Icon.createWithData((byte[])((byte[])this.mObj1), (int)this.mInt1, (int)this.mInt2);
            }
            case 4: {
                return Icon.createWithContentUri((String)((String)this.mObj1));
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void addToShortcutIntent(@NonNull Intent outIntent) {
        this.addToShortcutIntent(outIntent, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void addToShortcutIntent(@NonNull Intent outIntent, @Nullable Drawable badge) {
        Bitmap icon;
        switch (this.mType) {
            case 1: {
                icon = (Bitmap)this.mObj1;
                if (badge == null) break;
                icon = icon.copy(icon.getConfig(), true);
                break;
            }
            case 5: {
                icon = IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1, true);
                break;
            }
            case 2: {
                if (badge == null) {
                    outIntent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)((Context)this.mObj1), (int)this.mInt1));
                    return;
                }
                Context context = (Context)this.mObj1;
                Drawable dr = ContextCompat.getDrawable(context, this.mInt1);
                if (dr.getIntrinsicWidth() <= 0 || dr.getIntrinsicHeight() <= 0) {
                    int size = ((ActivityManager)context.getSystemService("activity")).getLauncherLargeIconSize();
                    icon = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                } else {
                    icon = Bitmap.createBitmap((int)dr.getIntrinsicWidth(), (int)dr.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                dr.setBounds(0, 0, icon.getWidth(), icon.getHeight());
                dr.draw(new Canvas(icon));
                break;
            }
            default: {
                throw new IllegalArgumentException("Icon type not supported for intent shortcuts");
            }
        }
        if (badge != null) {
            int w = icon.getWidth();
            int h = icon.getHeight();
            badge.setBounds(w / 2, h / 2, w, h);
            badge.draw(new Canvas(icon));
        }
        outIntent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)icon);
    }

    @VisibleForTesting
    static Bitmap createLegacyIconFromAdaptiveIcon(Bitmap adaptiveIconBitmap, boolean addShadow) {
        int size = (int)(0.6666667f * (float)Math.min(adaptiveIconBitmap.getWidth(), adaptiveIconBitmap.getHeight()));
        Bitmap icon = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(icon);
        Paint paint = new Paint(3);
        float center = (float)size * 0.5f;
        float radius = center * 0.9166667f;
        if (addShadow) {
            float blur = 0.010416667f * (float)size;
            paint.setColor(0);
            paint.setShadowLayer(blur, 0.0f, 0.020833334f * (float)size, 0x3D000000);
            canvas.drawCircle(center, center, radius, paint);
            paint.setShadowLayer(blur, 0.0f, 0.0f, 0x1E000000);
            canvas.drawCircle(center, center, radius, paint);
            paint.clearShadowLayer();
        }
        paint.setColor(-16777216);
        BitmapShader shader = new BitmapShader(adaptiveIconBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Matrix shift = new Matrix();
        shift.setTranslate((float)(-(adaptiveIconBitmap.getWidth() - size) / 2), (float)(-(adaptiveIconBitmap.getHeight() - size) / 2));
        shader.setLocalMatrix(shift);
        paint.setShader((Shader)shader);
        canvas.drawCircle(center, center, radius, paint);
        canvas.setBitmap(null);
        return icon;
    }
}

