/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.os.Build;
import android.support.v4.widget.ImageViewCompatBase;
import android.support.v4.widget.ImageViewCompatLollipop;
import android.widget.ImageView;

public class ImageViewCompat {
    static final ImageViewCompatImpl IMPL = Build.VERSION.SDK_INT >= 21 ? new LollipopViewCompatImpl() : new BaseViewCompatImpl();

    public static ColorStateList getImageTintList(ImageView view) {
        return IMPL.getImageTintList(view);
    }

    public static void setImageTintList(ImageView view, ColorStateList tintList) {
        IMPL.setImageTintList(view, tintList);
    }

    public static PorterDuff.Mode getImageTintMode(ImageView view) {
        return IMPL.getImageTintMode(view);
    }

    public static void setImageTintMode(ImageView view, PorterDuff.Mode mode) {
        IMPL.setImageTintMode(view, mode);
    }

    private ImageViewCompat() {
    }

    static class LollipopViewCompatImpl
    extends BaseViewCompatImpl {
        LollipopViewCompatImpl() {
        }

        @Override
        public ColorStateList getImageTintList(ImageView view) {
            return ImageViewCompatLollipop.getImageTintList(view);
        }

        @Override
        public void setImageTintList(ImageView view, ColorStateList tintList) {
            ImageViewCompatLollipop.setImageTintList(view, tintList);
        }

        @Override
        public void setImageTintMode(ImageView view, PorterDuff.Mode mode) {
            ImageViewCompatLollipop.setImageTintMode(view, mode);
        }

        @Override
        public PorterDuff.Mode getImageTintMode(ImageView view) {
            return ImageViewCompatLollipop.getImageTintMode(view);
        }
    }

    static class BaseViewCompatImpl
    implements ImageViewCompatImpl {
        BaseViewCompatImpl() {
        }

        @Override
        public ColorStateList getImageTintList(ImageView view) {
            return ImageViewCompatBase.getImageTintList(view);
        }

        @Override
        public void setImageTintList(ImageView view, ColorStateList tintList) {
            ImageViewCompatBase.setImageTintList(view, tintList);
        }

        @Override
        public void setImageTintMode(ImageView view, PorterDuff.Mode mode) {
            ImageViewCompatBase.setImageTintMode(view, mode);
        }

        @Override
        public PorterDuff.Mode getImageTintMode(ImageView view) {
            return ImageViewCompatBase.getImageTintMode(view);
        }
    }

    static interface ImageViewCompatImpl {
        public ColorStateList getImageTintList(ImageView var1);

        public void setImageTintList(ImageView var1, ColorStateList var2);

        public PorterDuff.Mode getImageTintMode(ImageView var1);

        public void setImageTintMode(ImageView var1, PorterDuff.Mode var2);
    }
}

