/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.ComponentName;
import android.content.Intent;
import android.os.Build;
import android.support.v4.content.IntentCompatHoneycomb;
import android.support.v4.content.IntentCompatIcsMr1;

public final class IntentCompat {
    private static final IntentCompatImpl IMPL;
    public static final String ACTION_EXTERNAL_APPLICATIONS_AVAILABLE = "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE";
    public static final String ACTION_EXTERNAL_APPLICATIONS_UNAVAILABLE = "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
    public static final String EXTRA_CHANGED_PACKAGE_LIST = "android.intent.extra.changed_package_list";
    public static final String EXTRA_CHANGED_UID_LIST = "android.intent.extra.changed_uid_list";
    public static final String EXTRA_HTML_TEXT = "android.intent.extra.HTML_TEXT";
    public static final String EXTRA_START_PLAYBACK = "android.intent.extra.START_PLAYBACK";
    public static final String CATEGORY_LEANBACK_LAUNCHER = "android.intent.category.LEANBACK_LAUNCHER";
    public static final int FLAG_ACTIVITY_TASK_ON_HOME = 16384;
    public static final int FLAG_ACTIVITY_CLEAR_TASK = 32768;

    private IntentCompat() {
    }

    public static Intent makeMainActivity(ComponentName mainActivity) {
        return IMPL.makeMainActivity(mainActivity);
    }

    public static Intent makeMainSelectorActivity(String selectorAction, String selectorCategory) {
        return IMPL.makeMainSelectorActivity(selectorAction, selectorCategory);
    }

    public static Intent makeRestartActivityTask(ComponentName mainActivity) {
        return IMPL.makeRestartActivityTask(mainActivity);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 15 ? new IntentCompatImplIcsMr1() : (version >= 11 ? new IntentCompatImplHC() : new IntentCompatImplBase());
    }

    static class IntentCompatImplIcsMr1
    extends IntentCompatImplHC {
        IntentCompatImplIcsMr1() {
        }

        @Override
        public Intent makeMainSelectorActivity(String selectorAction, String selectorCategory) {
            return IntentCompatIcsMr1.makeMainSelectorActivity(selectorAction, selectorCategory);
        }
    }

    static class IntentCompatImplHC
    extends IntentCompatImplBase {
        IntentCompatImplHC() {
        }

        @Override
        public Intent makeMainActivity(ComponentName componentName) {
            return IntentCompatHoneycomb.makeMainActivity(componentName);
        }

        @Override
        public Intent makeRestartActivityTask(ComponentName componentName) {
            return IntentCompatHoneycomb.makeRestartActivityTask(componentName);
        }
    }

    static class IntentCompatImplBase
    implements IntentCompatImpl {
        IntentCompatImplBase() {
        }

        @Override
        public Intent makeMainActivity(ComponentName componentName) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setComponent(componentName);
            intent.addCategory("android.intent.category.LAUNCHER");
            return intent;
        }

        @Override
        public Intent makeMainSelectorActivity(String selectorAction, String selectorCategory) {
            Intent intent = new Intent(selectorAction);
            intent.addCategory(selectorCategory);
            return intent;
        }

        @Override
        public Intent makeRestartActivityTask(ComponentName mainActivity) {
            Intent intent = this.makeMainActivity(mainActivity);
            intent.addFlags(0x10008000);
            return intent;
        }
    }

    static interface IntentCompatImpl {
        public Intent makeMainActivity(ComponentName var1);

        public Intent makeMainSelectorActivity(String var1, String var2);

        public Intent makeRestartActivityTask(ComponentName var1);
    }
}

