/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompatApi23;
import android.support.v4.graphics.drawable.DrawableCompatBase;
import android.support.v4.graphics.drawable.DrawableCompatHoneycomb;
import android.support.v4.graphics.drawable.DrawableCompatJellybeanMr1;
import android.support.v4.graphics.drawable.DrawableCompatKitKat;
import android.support.v4.graphics.drawable.DrawableCompatLollipop;
import android.support.v4.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class DrawableCompat {
    static final DrawableImpl IMPL;

    public static void jumpToCurrentState(@NonNull Drawable drawable) {
        IMPL.jumpToCurrentState(drawable);
    }

    public static void setAutoMirrored(@NonNull Drawable drawable, boolean mirrored) {
        IMPL.setAutoMirrored(drawable, mirrored);
    }

    public static boolean isAutoMirrored(@NonNull Drawable drawable) {
        return IMPL.isAutoMirrored(drawable);
    }

    public static void setHotspot(@NonNull Drawable drawable, float x, float y) {
        IMPL.setHotspot(drawable, x, y);
    }

    public static void setHotspotBounds(@NonNull Drawable drawable, int left, int top, int right, int bottom) {
        IMPL.setHotspotBounds(drawable, left, top, right, bottom);
    }

    public static void setTint(@NonNull Drawable drawable, @ColorInt int tint) {
        IMPL.setTint(drawable, tint);
    }

    public static void setTintList(@NonNull Drawable drawable, @Nullable ColorStateList tint) {
        IMPL.setTintList(drawable, tint);
    }

    public static void setTintMode(@NonNull Drawable drawable, @Nullable PorterDuff.Mode tintMode) {
        IMPL.setTintMode(drawable, tintMode);
    }

    public static int getAlpha(@NonNull Drawable drawable) {
        return IMPL.getAlpha(drawable);
    }

    public static void applyTheme(@NonNull Drawable drawable, @NonNull Resources.Theme t) {
        IMPL.applyTheme(drawable, t);
    }

    public static boolean canApplyTheme(@NonNull Drawable drawable) {
        return IMPL.canApplyTheme(drawable);
    }

    public static ColorFilter getColorFilter(@NonNull Drawable drawable) {
        return IMPL.getColorFilter(drawable);
    }

    public static void clearColorFilter(@NonNull Drawable drawable) {
        IMPL.clearColorFilter(drawable);
    }

    public static void inflate(@NonNull Drawable drawable, @NonNull Resources res, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        IMPL.inflate(drawable, res, parser, attrs, theme);
    }

    public static Drawable wrap(@NonNull Drawable drawable) {
        return IMPL.wrap(drawable);
    }

    public static <T extends Drawable> T unwrap(@NonNull Drawable drawable) {
        if (drawable instanceof DrawableWrapper) {
            return (T)((DrawableWrapper)drawable).getWrappedDrawable();
        }
        return (T)drawable;
    }

    public static boolean setLayoutDirection(@NonNull Drawable drawable, int layoutDirection) {
        return IMPL.setLayoutDirection(drawable, layoutDirection);
    }

    public static int getLayoutDirection(@NonNull Drawable drawable) {
        return IMPL.getLayoutDirection(drawable);
    }

    private DrawableCompat() {
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 23 ? new MDrawableImpl() : (version >= 21 ? new LollipopDrawableImpl() : (version >= 19 ? new KitKatDrawableImpl() : (version >= 17 ? new JellybeanMr1DrawableImpl() : (version >= 11 ? new HoneycombDrawableImpl() : new BaseDrawableImpl()))));
    }

    static class MDrawableImpl
    extends LollipopDrawableImpl {
        MDrawableImpl() {
        }

        @Override
        public boolean setLayoutDirection(Drawable drawable, int layoutDirection) {
            return DrawableCompatApi23.setLayoutDirection((Drawable)drawable, (int)layoutDirection);
        }

        @Override
        public int getLayoutDirection(Drawable drawable) {
            return DrawableCompatApi23.getLayoutDirection((Drawable)drawable);
        }

        @Override
        public Drawable wrap(Drawable drawable) {
            return drawable;
        }

        @Override
        public void clearColorFilter(Drawable drawable) {
            drawable.clearColorFilter();
        }
    }

    static class LollipopDrawableImpl
    extends KitKatDrawableImpl {
        LollipopDrawableImpl() {
        }

        @Override
        public void setHotspot(Drawable drawable, float x, float y) {
            DrawableCompatLollipop.setHotspot((Drawable)drawable, (float)x, (float)y);
        }

        @Override
        public void setHotspotBounds(Drawable drawable, int left, int top, int right, int bottom) {
            DrawableCompatLollipop.setHotspotBounds((Drawable)drawable, (int)left, (int)top, (int)right, (int)bottom);
        }

        @Override
        public void setTint(Drawable drawable, int tint) {
            DrawableCompatLollipop.setTint((Drawable)drawable, (int)tint);
        }

        @Override
        public void setTintList(Drawable drawable, ColorStateList tint) {
            DrawableCompatLollipop.setTintList((Drawable)drawable, (ColorStateList)tint);
        }

        @Override
        public void setTintMode(Drawable drawable, PorterDuff.Mode tintMode) {
            DrawableCompatLollipop.setTintMode((Drawable)drawable, (PorterDuff.Mode)tintMode);
        }

        @Override
        public Drawable wrap(Drawable drawable) {
            return DrawableCompatLollipop.wrapForTinting((Drawable)drawable);
        }

        @Override
        public void applyTheme(Drawable drawable, Resources.Theme t) {
            DrawableCompatLollipop.applyTheme((Drawable)drawable, (Resources.Theme)t);
        }

        @Override
        public boolean canApplyTheme(Drawable drawable) {
            return DrawableCompatLollipop.canApplyTheme((Drawable)drawable);
        }

        @Override
        public ColorFilter getColorFilter(Drawable drawable) {
            return DrawableCompatLollipop.getColorFilter((Drawable)drawable);
        }

        @Override
        public void clearColorFilter(Drawable drawable) {
            DrawableCompatLollipop.clearColorFilter((Drawable)drawable);
        }

        @Override
        public void inflate(Drawable drawable, Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme t) throws IOException, XmlPullParserException {
            DrawableCompatLollipop.inflate((Drawable)drawable, (Resources)res, (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)t);
        }
    }

    static class KitKatDrawableImpl
    extends JellybeanMr1DrawableImpl {
        KitKatDrawableImpl() {
        }

        @Override
        public void setAutoMirrored(Drawable drawable, boolean mirrored) {
            DrawableCompatKitKat.setAutoMirrored((Drawable)drawable, (boolean)mirrored);
        }

        @Override
        public boolean isAutoMirrored(Drawable drawable) {
            return DrawableCompatKitKat.isAutoMirrored((Drawable)drawable);
        }

        @Override
        public Drawable wrap(Drawable drawable) {
            return DrawableCompatKitKat.wrapForTinting((Drawable)drawable);
        }

        @Override
        public int getAlpha(Drawable drawable) {
            return DrawableCompatKitKat.getAlpha((Drawable)drawable);
        }
    }

    static class JellybeanMr1DrawableImpl
    extends HoneycombDrawableImpl {
        JellybeanMr1DrawableImpl() {
        }

        @Override
        public boolean setLayoutDirection(Drawable drawable, int layoutDirection) {
            return DrawableCompatJellybeanMr1.setLayoutDirection((Drawable)drawable, (int)layoutDirection);
        }

        @Override
        public int getLayoutDirection(Drawable drawable) {
            int dir = DrawableCompatJellybeanMr1.getLayoutDirection((Drawable)drawable);
            return dir >= 0 ? dir : 0;
        }
    }

    static class HoneycombDrawableImpl
    extends BaseDrawableImpl {
        HoneycombDrawableImpl() {
        }

        @Override
        public void jumpToCurrentState(Drawable drawable) {
            DrawableCompatHoneycomb.jumpToCurrentState((Drawable)drawable);
        }

        @Override
        public Drawable wrap(Drawable drawable) {
            return DrawableCompatHoneycomb.wrapForTinting((Drawable)drawable);
        }
    }

    static class BaseDrawableImpl
    implements DrawableImpl {
        BaseDrawableImpl() {
        }

        @Override
        public void jumpToCurrentState(Drawable drawable) {
        }

        @Override
        public void setAutoMirrored(Drawable drawable, boolean mirrored) {
        }

        @Override
        public boolean isAutoMirrored(Drawable drawable) {
            return false;
        }

        @Override
        public void setHotspot(Drawable drawable, float x, float y) {
        }

        @Override
        public void setHotspotBounds(Drawable drawable, int left, int top, int right, int bottom) {
        }

        @Override
        public void setTint(Drawable drawable, int tint) {
            DrawableCompatBase.setTint((Drawable)drawable, (int)tint);
        }

        @Override
        public void setTintList(Drawable drawable, ColorStateList tint) {
            DrawableCompatBase.setTintList((Drawable)drawable, (ColorStateList)tint);
        }

        @Override
        public void setTintMode(Drawable drawable, PorterDuff.Mode tintMode) {
            DrawableCompatBase.setTintMode((Drawable)drawable, (PorterDuff.Mode)tintMode);
        }

        @Override
        public Drawable wrap(Drawable drawable) {
            return DrawableCompatBase.wrapForTinting((Drawable)drawable);
        }

        @Override
        public boolean setLayoutDirection(Drawable drawable, int layoutDirection) {
            return false;
        }

        @Override
        public int getLayoutDirection(Drawable drawable) {
            return 0;
        }

        @Override
        public int getAlpha(Drawable drawable) {
            return 0;
        }

        @Override
        public void applyTheme(Drawable drawable, Resources.Theme t) {
        }

        @Override
        public boolean canApplyTheme(Drawable drawable) {
            return false;
        }

        @Override
        public ColorFilter getColorFilter(Drawable drawable) {
            return null;
        }

        @Override
        public void clearColorFilter(Drawable drawable) {
            drawable.clearColorFilter();
        }

        @Override
        public void inflate(Drawable drawable, Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme t) throws IOException, XmlPullParserException {
            DrawableCompatBase.inflate((Drawable)drawable, (Resources)res, (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)t);
        }
    }

    static interface DrawableImpl {
        public void jumpToCurrentState(Drawable var1);

        public void setAutoMirrored(Drawable var1, boolean var2);

        public boolean isAutoMirrored(Drawable var1);

        public void setHotspot(Drawable var1, float var2, float var3);

        public void setHotspotBounds(Drawable var1, int var2, int var3, int var4, int var5);

        public void setTint(Drawable var1, int var2);

        public void setTintList(Drawable var1, ColorStateList var2);

        public void setTintMode(Drawable var1, PorterDuff.Mode var2);

        public Drawable wrap(Drawable var1);

        public boolean setLayoutDirection(Drawable var1, int var2);

        public int getLayoutDirection(Drawable var1);

        public int getAlpha(Drawable var1);

        public void applyTheme(Drawable var1, Resources.Theme var2);

        public boolean canApplyTheme(Drawable var1);

        public ColorFilter getColorFilter(Drawable var1);

        public void clearColorFilter(Drawable var1);

        public void inflate(Drawable var1, Resources var2, XmlPullParser var3, AttributeSet var4, Resources.Theme var5) throws IOException, XmlPullParserException;
    }
}

