/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion.utils;

import android.support.constraint.motion.utils.CurveFit;

public class MonotonicCurveFit
extends CurveFit {
    private static final String TAG = "MonotonicCurveFit";
    private double[] mT;
    private double[][] mY;
    private double[][] mTangent;

    public MonotonicCurveFit(double[] time, double[][] y) {
        int N = time.length;
        int dim = y[0].length;
        double[][] slope = new double[N - 1][dim];
        double[][] tangent = new double[N][dim];
        for (int j = 0; j < dim; ++j) {
            for (int i = 0; i < N - 1; ++i) {
                double dt = time[i + 1] - time[i];
                slope[i][j] = (y[i + 1][j] - y[i][j]) / dt;
                tangent[i][j] = i == 0 ? slope[i][j] : (slope[i - 1][j] + slope[i][j]) * 0.5;
            }
            tangent[N - 1][j] = slope[N - 2][j];
        }
        for (int i = 0; i < N - 1; ++i) {
            for (int j = 0; j < dim; ++j) {
                if (slope[i][j] == 0.0) {
                    tangent[i][j] = 0.0;
                    tangent[i + 1][j] = 0.0;
                    continue;
                }
                double a = tangent[i][j] / slope[i][j];
                double b = tangent[i + 1][j] / slope[i][j];
                double h = Math.hypot(a, b);
                if (!(h > 9.0)) continue;
                double t = 3.0 / h;
                tangent[i][j] = t * a * slope[i][j];
                tangent[i + 1][j] = t * b * slope[i][j];
            }
        }
        this.mT = time;
        this.mY = y;
        this.mTangent = tangent;
    }

    @Override
    public void getPos(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = this.mY[0][j];
            }
            return;
        }
        if (t >= this.mT[n - 1]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = this.mY[n - 1][j];
            }
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = MonotonicCurveFit.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    @Override
    public void getPos(double t, float[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = (float)this.mY[0][j];
            }
            return;
        }
        if (t >= this.mT[n - 1]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = (float)this.mY[n - 1][j];
            }
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = (float)MonotonicCurveFit.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        int n = this.mT.length;
        if (t <= this.mT[0]) {
            return this.mY[0][j];
        }
        if (t >= this.mT[n - 1]) {
            return this.mY[n - 1][j];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                return this.mY[i][j];
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            double t1 = this.mTangent[i][j];
            double t2 = this.mTangent[i + 1][j];
            return MonotonicCurveFit.interpolate(h, x, y1, y2, t1, t2);
        }
        return 0.0;
    }

    @Override
    public void getSlope(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(t <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                double t1 = this.mTangent[i][j];
                double t2 = this.mTangent[i + 1][j];
                v[j] = MonotonicCurveFit.diff(h, x, y1, y2, t1, t2) / h;
            }
            break;
        }
    }

    @Override
    public double getSlope(double t, int j) {
        int n = this.mT.length;
        if (t < this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(t <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            double t1 = this.mTangent[i][j];
            double t2 = this.mTangent[i + 1][j];
            return MonotonicCurveFit.diff(h, x, y1, y2, t1, t2) / h;
        }
        return 0.0;
    }

    @Override
    public double[] getTimePoints() {
        return this.mT;
    }

    private static double interpolate(double h, double x, double y1, double y2, double t1, double t2) {
        double x2 = x * x;
        double x3 = x2 * x;
        return -2.0 * x3 * y2 + 3.0 * x2 * y2 + 2.0 * x3 * y1 - 3.0 * x2 * y1 + y1 + h * t2 * x3 + h * t1 * x3 - h * t2 * x2 - 2.0 * h * t1 * x2 + h * t1 * x;
    }

    private static double diff(double h, double x, double y1, double y2, double t1, double t2) {
        double x2 = x * x;
        return -6.0 * x2 * y2 + 6.0 * x * y2 + 6.0 * x2 * y1 - 6.0 * x * y1 + 3.0 * h * t2 * x2 + 3.0 * h * t1 * x2 - 2.0 * h * t2 * x - 4.0 * h * t1 * x + h * t1;
    }
}

