/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.support.annotation.RestrictTo;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.TooltipPopup;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityManager;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class TooltipCompatHandler
implements View.OnLongClickListener,
View.OnHoverListener,
View.OnAttachStateChangeListener {
    private static final String TAG = "TooltipCompatHandler";
    private static final long LONG_CLICK_HIDE_TIMEOUT_MS = 2500L;
    private static final long HOVER_HIDE_TIMEOUT_MS = 15000L;
    private static final long HOVER_HIDE_TIMEOUT_SHORT_MS = 3000L;
    private final View mAnchor;
    private final CharSequence mTooltipText;
    private final Runnable mShowRunnable = new Runnable(){

        @Override
        public void run() {
            TooltipCompatHandler.this.show(false);
        }
    };
    private final Runnable mHideRunnable = new Runnable(){

        @Override
        public void run() {
            TooltipCompatHandler.this.hide();
        }
    };
    private int mAnchorX;
    private int mAnchorY;
    private TooltipPopup mPopup;
    private boolean mFromTouch;
    private static TooltipCompatHandler sActiveHandler;

    public static void setTooltipText(View view, CharSequence tooltipText) {
        if (TextUtils.isEmpty((CharSequence)tooltipText)) {
            if (sActiveHandler != null && TooltipCompatHandler.sActiveHandler.mAnchor == view) {
                sActiveHandler.hide();
            }
            view.setOnLongClickListener(null);
            view.setLongClickable(false);
            view.setOnHoverListener(null);
        } else {
            new TooltipCompatHandler(view, tooltipText);
        }
    }

    private TooltipCompatHandler(View anchor, CharSequence tooltipText) {
        this.mAnchor = anchor;
        this.mTooltipText = tooltipText;
        this.mAnchor.setOnLongClickListener((View.OnLongClickListener)this);
        this.mAnchor.setOnHoverListener((View.OnHoverListener)this);
    }

    public boolean onLongClick(View v) {
        this.mAnchorX = v.getWidth() / 2;
        this.mAnchorY = v.getHeight() / 2;
        this.show(true);
        return true;
    }

    public boolean onHover(View v, MotionEvent event) {
        if (this.mPopup != null && this.mFromTouch) {
            return false;
        }
        AccessibilityManager manager = (AccessibilityManager)this.mAnchor.getContext().getSystemService("accessibility");
        if (manager.isEnabled() && manager.isTouchExplorationEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 7: {
                if (!this.mAnchor.isEnabled() || this.mPopup != null) break;
                this.mAnchorX = (int)event.getX();
                this.mAnchorY = (int)event.getY();
                this.mAnchor.removeCallbacks(this.mShowRunnable);
                this.mAnchor.postDelayed(this.mShowRunnable, (long)ViewConfiguration.getLongPressTimeout());
                break;
            }
            case 10: {
                this.hide();
            }
        }
        return false;
    }

    public void onViewAttachedToWindow(View v) {
    }

    public void onViewDetachedFromWindow(View v) {
        this.hide();
    }

    private void show(boolean fromTouch) {
        if (!ViewCompat.isAttachedToWindow((View)this.mAnchor)) {
            return;
        }
        if (sActiveHandler != null) {
            sActiveHandler.hide();
        }
        sActiveHandler = this;
        this.mFromTouch = fromTouch;
        this.mPopup = new TooltipPopup(this.mAnchor.getContext());
        this.mPopup.show(this.mAnchor, this.mAnchorX, this.mAnchorY, this.mFromTouch, this.mTooltipText);
        this.mAnchor.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        long timeout = this.mFromTouch ? 2500L : ((ViewCompat.getWindowSystemUiVisibility((View)this.mAnchor) & 1) == 1 ? 3000L - (long)ViewConfiguration.getLongPressTimeout() : 15000L - (long)ViewConfiguration.getLongPressTimeout());
        this.mAnchor.removeCallbacks(this.mHideRunnable);
        this.mAnchor.postDelayed(this.mHideRunnable, timeout);
    }

    private void hide() {
        if (sActiveHandler == this) {
            sActiveHandler = null;
            if (this.mPopup != null) {
                this.mPopup.hide();
                this.mPopup = null;
                this.mAnchor.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            } else {
                Log.e((String)TAG, (String)"sActiveHandler.mPopup == null");
            }
        }
        this.mAnchor.removeCallbacks(this.mShowRunnable);
        this.mAnchor.removeCallbacks(this.mHideRunnable);
    }
}

