/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.content.res.ConfigurationHelper;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

public class ButtonBarLayout
extends LinearLayout {
    private static final int ALLOW_STACKING_MIN_HEIGHT_DP = 320;
    private boolean mAllowStacking;
    private int mLastWidthSize = -1;

    public ButtonBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        boolean allowStackingDefault = ConfigurationHelper.getScreenHeightDp((Resources)this.getResources()) >= 320;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ButtonBarLayout);
        this.mAllowStacking = ta.getBoolean(R.styleable.ButtonBarLayout_allowStacking, allowStackingDefault);
        ta.recycle();
    }

    public void setAllowStacking(boolean allowStacking) {
        if (this.mAllowStacking != allowStacking) {
            this.mAllowStacking = allowStacking;
            if (!this.mAllowStacking && this.getOrientation() == 1) {
                this.setStacked(false);
            }
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int initialWidthMeasureSpec;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.mAllowStacking) {
            if (widthSize > this.mLastWidthSize && this.isStacked()) {
                this.setStacked(false);
            }
            this.mLastWidthSize = widthSize;
        }
        boolean needsRemeasure = false;
        if (!this.isStacked() && View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000) {
            initialWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)Integer.MIN_VALUE);
            needsRemeasure = true;
        } else {
            initialWidthMeasureSpec = widthMeasureSpec;
        }
        super.onMeasure(initialWidthMeasureSpec, heightMeasureSpec);
        if (this.mAllowStacking && !this.isStacked()) {
            boolean stack;
            if (Build.VERSION.SDK_INT >= 11) {
                int measuredWidth = ViewCompat.getMeasuredWidthAndState((View)this);
                int measuredWidthState = measuredWidth & 0xFF000000;
                stack = measuredWidthState == 0x1000000;
            } else {
                int childWidthTotal = 0;
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    childWidthTotal += this.getChildAt(i).getMeasuredWidth();
                }
                boolean bl = stack = childWidthTotal + this.getPaddingLeft() + this.getPaddingRight() > widthSize;
            }
            if (stack) {
                this.setStacked(true);
                needsRemeasure = true;
            }
        }
        if (needsRemeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void setStacked(boolean stacked) {
        this.setOrientation(stacked ? 1 : 0);
        this.setGravity(stacked ? 5 : 80);
        View spacer = this.findViewById(R.id.spacer);
        if (spacer != null) {
            spacer.setVisibility(stacked ? 8 : 4);
        }
        int childCount = this.getChildCount();
        for (int i = childCount - 2; i >= 0; --i) {
            this.bringChildToFront(this.getChildAt(i));
        }
    }

    private boolean isStacked() {
        return this.getOrientation() == 1;
    }
}

