/*
 * Decompiled with CFR 0.152.
 */
package com.permission.kit;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.SparseArray;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import com.permission.kit.OnPermissionListener;
import com.permission.kit.R;
import com.permission.kit.onCustomGuide;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@TargetApi(value=23)
public class PermissionKit {
    private SparseArray<OnPermissionListener> listenerSparseArray = new SparseArray();

    private PermissionKit() {
    }

    public static PermissionKit getInstance() {
        return PermissionHolder.PERMISSION_KIT;
    }

    public boolean isM() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public boolean hasPermission(Context context, String ... permissions) {
        if (this.isM()) {
            for (String permission : permissions) {
                if (ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public void requestPermission(Activity activity, int requestCode, OnPermissionListener callback, String ... permissions) {
        if (!this.hasPermission((Context)activity, permissions)) {
            String[] ps = this.registerCallback(activity, requestCode, callback, permissions);
            if (ps == null || ps.length == 0) {
                callback.onSuccess(requestCode, permissions);
            } else {
                activity.requestPermissions(ps, requestCode);
            }
        } else {
            callback.onSuccess(requestCode, permissions);
        }
    }

    public void requestPermissionsResult(int requestCode, String[] permissions, List<String> unAgreeList) {
        int hashCode = Arrays.hashCode(permissions);
        OnPermissionListener listener = (OnPermissionListener)this.listenerSparseArray.get(hashCode);
        if (listener != null) {
            if (unAgreeList.size() > 0) {
                listener.onFail(requestCode, this.list2Array(unAgreeList));
            } else {
                listener.onSuccess(requestCode, permissions);
            }
        }
        this.listenerSparseArray.remove(hashCode);
    }

    public void requestAlertWindow(Activity activity, OnPermissionListener callback) {
        if (this.isM() && activity != null) {
            this.registerCallback(callback, Arrays.hashCode(new String[]{"android.settings.action.MANAGE_OVERLAY_PERMISSION"}));
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            intent.setData(this.getUri(activity));
            activity.startActivityForResult(intent, 2769);
        }
    }

    public void requestWriteSetting(Activity activity, OnPermissionListener callback) {
        if (this.isM()) {
            this.registerCallback(callback, Arrays.hashCode(new String[]{"android.settings.action.MANAGE_WRITE_SETTINGS"}));
            if (activity != null) {
                Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
                intent.setData(this.getUri(activity));
                activity.startActivityForResult(intent, 2770);
            }
        }
    }

    public void guideSetting(Activity activity, boolean defaultGuide, int requestCode, onCustomGuide customGuide, String ... permissions) {
        for (String str : permissions) {
            if (activity.shouldShowRequestPermissionRationale(str)) {
                if (defaultGuide) {
                    this.showTipDialog(activity, requestCode, 1, permissions);
                    break;
                }
                if (customGuide != null) {
                    customGuide.againRequest();
                    break;
                }
                throw new NullPointerException(activity.getResources().getString(R.string.tip_custom_not_null));
            }
            if (defaultGuide) {
                this.showTipDialog(activity, requestCode, 2, permissions);
                continue;
            }
            if (customGuide != null) {
                customGuide.goSetting();
                continue;
            }
            throw new NullPointerException(activity.getResources().getString(R.string.tip_custom_not_null));
        }
    }

    private void showTipDialog(final Activity activity, final int requestCode, final int type, final String[] permissions) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle((CharSequence)activity.getResources().getString(R.string.tip_permission_title));
        builder.setMessage((CharSequence)activity.getResources().getString(type == 1 ? R.string.tip_permission_msg_ask : R.string.tip_permission_msg_setting));
        builder.setPositiveButton((CharSequence)activity.getResources().getString(type == 1 ? R.string.tip_permission_btn_ok : R.string.tip_permission_btn_ok_setting), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (type == 1) {
                    activity.requestPermissions(permissions, requestCode);
                } else {
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    intent.setData(PermissionKit.this.getUri(activity));
                    activity.startActivityForResult(intent, 2771);
                }
            }
        });
        builder.setNegativeButton((CharSequence)activity.getResources().getString(R.string.tip_permission_btn_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    private Uri getUri(Activity activity) {
        return Uri.parse((String)("package:" + activity.getPackageName()));
    }

    private void registerCallback(OnPermissionListener callback, int hashCode) {
        OnPermissionListener mBack = (OnPermissionListener)this.listenerSparseArray.get(hashCode);
        if (mBack == null) {
            this.listenerSparseArray.append(hashCode, (Object)callback);
        }
    }

    private String[] registerCallback(Activity activity, int requestCode, OnPermissionListener callback, String ... permission) {
        if (permission == null || permission.length == 0) {
            callback.onSuccess(requestCode, permission);
            return null;
        }
        List<String> list = this.checkPermission(activity, permission);
        if (list.size() == 0) {
            callback.onSuccess(requestCode, permission);
            return null;
        }
        Object[] denyPermission = this.list2Array(list);
        int hashCode = Arrays.hashCode(denyPermission);
        OnPermissionListener listener = (OnPermissionListener)this.listenerSparseArray.get(hashCode);
        if (listener == null) {
            this.listenerSparseArray.append(hashCode, (Object)callback);
        }
        return denyPermission;
    }

    private String[] list2Array(List<String> denyPermission) {
        String[] array = new String[denyPermission.size()];
        int count = denyPermission.size();
        for (int i = 0; i < count; ++i) {
            array[i] = denyPermission.get(i);
        }
        return array;
    }

    private List<String> checkPermission(Activity activity, String ... permission) {
        ArrayList<String> denyPermissions = new ArrayList<String>();
        for (String p : permission) {
            if (activity.checkSelfPermission(p) == 0) continue;
            denyPermissions.add(p);
        }
        return denyPermissions;
    }

    private static class PermissionHolder {
        private static final PermissionKit PERMISSION_KIT = new PermissionKit();

        private PermissionHolder() {
        }
    }
}

