/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SMModel;
import org.mozilla.universalchardet.prober.statemachine.UTF8SMModel;

public final class UTF8Prober
extends CharsetProber {
    private CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private CharsetProber.ProbingState state;
    private int numOfMBChar = 0;
    private static final SMModel smModel = new UTF8SMModel();

    public UTF8Prober() {
        this.reset();
    }

    public final String getCharSetName() {
        return Constants.CHARSET_UTF_8;
    }

    /*
     * WARNING - void declaration
     */
    public final CharsetProber.ProbingState handleData(byte[] buf, int offset, int length) {
        int maxPos = offset + length;
        for (int i = offset; i < maxPos; ++i) {
            void var2_2;
            int codingState = this.codingSM.nextState(buf[i]);
            if (codingState == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (codingState == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (var2_2 != false || this.codingSM.getCurrentCharLen() < 2) continue;
            ++this.numOfMBChar;
        }
        if (this.state == CharsetProber.ProbingState.DETECTING && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    public final CharsetProber.ProbingState getState() {
        return this.state;
    }

    public final void reset() {
        this.codingSM.reset();
        this.numOfMBChar = 0;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    /*
     * WARNING - void declaration
     */
    public final float getConfidence() {
        float unlike = 0.99f;
        if (this.numOfMBChar < 6) {
            void var1_1;
            for (int i = 0; i < this.numOfMBChar; ++i) {
                unlike *= 0.5f;
            }
            return 1.0f - var1_1;
        }
        return 0.99f;
    }
}

