/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.parser.BindingExpressionLexer;
import android.databinding.parser.BindingExpressionParser;
import android.databinding.parser.XMLLexer;
import android.databinding.parser.XMLParser;
import android.databinding.tool.util.L;
import com.google.repacked.antlr.v4.runtime.ANTLRInputStream;
import com.google.repacked.antlr.v4.runtime.CharStream;
import com.google.repacked.antlr.v4.runtime.CommonTokenStream;
import com.google.repacked.antlr.v4.runtime.RuleContext;
import com.google.repacked.antlr.v4.runtime.Token;
import com.google.repacked.antlr.v4.runtime.TokenSource;
import com.google.repacked.antlr.v4.runtime.TokenStream;
import com.google.repacked.apache.commons.io.FileUtils;
import com.google.repacked.apache.commons.lang3.StringEscapeUtils;
import com.google.repacked.apache.commons.lang3.StringUtils;
import com.google.repacked.apache.commons.lang3.tuple.ImmutablePair;
import com.google.repacked.apache.commons.lang3.tuple.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class XmlEditor {
    /*
     * WARNING - void declaration
     */
    public static String strip(File f, String newTag, String encoding) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(f);
        InputStreamReader reader = new InputStreamReader((InputStream)fileInputStream, encoding);
        ANTLRInputStream inputStream = new ANTLRInputStream(reader);
        XMLLexer lexer = new XMLLexer(inputStream);
        Object tokenStream = new CommonTokenStream(lexer);
        tokenStream = new XMLParser((TokenStream)tokenStream);
        XMLParser.ElementContext root = ((XMLParser.DocumentContext)(tokenStream = ((XMLParser)tokenStream).document())).element();
        if (root == null || !"layout".equals(XmlEditor.nodeName(root))) {
            return null;
        }
        List<? extends XMLParser.ElementContext> list = XmlEditor.elements(root);
        List<? extends XMLParser.ElementContext> dataNodes = XmlEditor.filterNodesByName("data", list);
        if (dataNodes.size() > 1) {
            L.e("Multiple binding data tags in %s. Expecting a maximum of one.", f.getAbsolutePath());
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(FileUtils.readLines(f, "utf-8"));
        for (XMLParser.ElementContext elementContext : dataNodes) {
            XmlEditor.replace(lines, XmlEditor.toPosition(elementContext.getStart()), XmlEditor.toEndPosition(elementContext.getStop()), "");
        }
        List<? extends XMLParser.ElementContext> layoutNodes = XmlEditor.excludeNodesByName("data", list);
        if (layoutNodes.size() != 1) {
            L.e("Only one layout element and one data element are allowed. %s has %d", f.getAbsolutePath(), layoutNodes.size());
        }
        XMLParser.ElementContext elementContext = layoutNodes.get(0);
        ArrayList noTag = new ArrayList();
        XmlEditor.recurseReplace(elementContext, lines, noTag, newTag, 0);
        Position rootStartTag = XmlEditor.toPosition(root.getStart());
        Position position = XmlEditor.toPosition(root.content().getStart());
        XmlEditor.replace(lines, rootStartTag, position, "");
        ImmutablePair<Position, Position> endLayoutPositions = XmlEditor.findTerminalPositions(root, lines);
        XmlEditor.replace(lines, (Position)endLayoutPositions.left, (Position)endLayoutPositions.right, "");
        StringBuilder rootAttributes = new StringBuilder();
        for (XMLParser.AttributeContext attributeContext : XmlEditor.attributes(root)) {
            rootAttributes.append(' ').append(attributeContext.getText());
        }
        Pair noTagRoot = null;
        Iterator iterator = noTag.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.getRight() != elementContext) continue;
            noTagRoot = pair;
            break;
        }
        if (noTagRoot != null) {
            ImmutablePair<String, XMLParser.ElementContext> immutablePair = new ImmutablePair<String, XMLParser.ElementContext>((String)noTagRoot.getLeft() + rootAttributes.toString(), elementContext);
            int index = noTag.indexOf(noTagRoot);
            noTag.set(index, immutablePair);
        } else {
            ImmutablePair<String, XMLParser.ElementContext> immutablePair = new ImmutablePair<String, XMLParser.ElementContext>(rootAttributes.toString(), elementContext);
            noTag.add(immutablePair);
        }
        Collections.sort(noTag, new Comparator<Pair<String, XMLParser.ElementContext>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final int compare(Pair<String, XMLParser.ElementContext> o1, Pair<String, XMLParser.ElementContext> o2) {
                void var1_1;
                void var2_2;
                Position start1 = XmlEditor.toPosition(o1.getRight().getStart());
                Position start2 = XmlEditor.toPosition(o2.getRight().getStart());
                int lineCmp = Integer.compare(start2.line, start1.line);
                if (lineCmp != 0) {
                    void var3_3;
                    return (int)var3_3;
                }
                return Integer.compare(var2_2.charIndex, var1_1.charIndex);
            }
        });
        Iterator iterator2 = noTag.iterator();
        while (iterator2.hasNext()) {
            void var1_1;
            ArrayList position2;
            void var2_2;
            Pair it = (Pair)iterator2.next();
            ArrayList element = (XMLParser.ElementContext)it.getRight();
            String tag = (String)it.getLeft();
            ArrayList endTagPosition = XmlEditor.endTagPosition((XMLParser.ElementContext)((Object)element));
            XmlEditor.fixPosition(lines, (Position)((Object)endTagPosition));
            String line = lines.get(((Position)((Object)endTagPosition)).line);
            String newLine = line.substring(0, ((Position)((Object)endTagPosition)).charIndex) + " " + tag + var2_2.substring(((Position)((Object)endTagPosition)).charIndex);
            lines.set(((Position)((Object)position2)).line, (String)var1_1);
        }
        return StringUtils.join(lines, System.getProperty("line.separator"));
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends XMLParser.ElementContext> List<T> filterNodesByName(String name, Iterable<T> items) {
        void var2_2;
        ArrayList<void> result = new ArrayList<void>();
        for (XMLParser.ElementContext item : items) {
            void var3_3;
            if (!name.equals(XmlEditor.nodeName(item))) continue;
            result.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends XMLParser.ElementContext> List<T> excludeNodesByName(String name, Iterable<T> items) {
        void var2_2;
        ArrayList<void> result = new ArrayList<void>();
        for (XMLParser.ElementContext item : items) {
            void var3_3;
            if (name.equals(XmlEditor.nodeName(item))) continue;
            result.add(var3_3);
        }
        return var2_2;
    }

    private static Position toPosition(Token token) {
        Token token2;
        return new Position(token.getLine() - 1, token2.getCharPositionInLine());
    }

    private static Position toEndPosition(Token token) {
        Token token2;
        return new Position(token.getLine() - 1, token.getCharPositionInLine() + token2.getText().length());
    }

    public static String nodeName(XMLParser.ElementContext elementContext) {
        return elementContext.elmName.getText();
    }

    public static List<? extends XMLParser.AttributeContext> attributes(XMLParser.ElementContext elementContext) {
        XMLParser.ElementContext elementContext2;
        if (elementContext.attribute() == null) {
            return new ArrayList();
        }
        return elementContext2.attribute();
    }

    /*
     * WARNING - void declaration
     */
    public static List<? extends XMLParser.AttributeContext> expressionAttributes(XMLParser.ElementContext elementContext) {
        void var1_1;
        ArrayList<XMLParser.AttributeContext> result = new ArrayList<XMLParser.AttributeContext>();
        for (XMLParser.AttributeContext attributeContext : XmlEditor.attributes(elementContext)) {
            void var3_3;
            String attrName = attributeContext.attrName.getText();
            String value = attributeContext.attrValue.getText();
            if (!var3_3.equals("android:tag") && (!value.startsWith("\"@{") || !value.endsWith("}\"")) && (!value.startsWith("'@{") || !value.endsWith("}'"))) continue;
            result.add(attributeContext);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Position endTagPosition(XMLParser.ElementContext context) {
        void var1_2;
        if (context.content() == null) {
            Position endTag = XmlEditor.toPosition(context.getStop());
            if (endTag.charIndex <= 0) {
                L.e("invalid input in %s", context);
            }
            return endTag;
        }
        Position position = XmlEditor.toPosition(context.content().getStart());
        if (position.charIndex <= 0) {
            XMLParser.ElementContext elementContext;
            L.e("invalid input in %s", elementContext);
        }
        --position.charIndex;
        return var1_2;
    }

    public static List<? extends XMLParser.ElementContext> elements(XMLParser.ElementContext context) {
        if (context.content() != null && context.content().element() != null) {
            XMLParser.ElementContext elementContext;
            return elementContext.content().element();
        }
        return new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean replace(ArrayList<String> lines, Position start, Position end, String text) {
        void var1_1;
        ArrayList<String> arrayList;
        void var2_2;
        String string;
        XmlEditor.fixPosition(lines, start);
        XmlEditor.fixPosition(lines, end);
        if (start.line != end.line) {
            String startLine = lines.get(start.line);
            String newStartLine = startLine.substring(0, start.charIndex) + text;
            lines.set(start.line, newStartLine);
            for (int i = start.line + 1; i < end.line; ++i) {
                String line = lines.get(i);
                lines.set(i, XmlEditor.replaceWithSpaces(line, 0, line.length() - 1));
            }
            String string2 = lines.get(end.line);
            String newEndLine = XmlEditor.replaceWithSpaces(string2, 0, end.charIndex - 1);
            lines.set(end.line, newEndLine);
            return true;
        }
        if (end.charIndex - start.charIndex >= string.length()) {
            String line = lines.get(start.line);
            int endTextIndex = start.charIndex + string.length();
            string = XmlEditor.replaceRange(line, start.charIndex, endTextIndex, string);
            String spacedText = XmlEditor.replaceWithSpaces(string, endTextIndex, end.charIndex - 1);
            lines.set(start.line, spacedText);
            return true;
        }
        String string3 = lines.get(start.line);
        String newLine = XmlEditor.replaceWithSpaces(string3, start.charIndex, var2_2.charIndex - 1);
        arrayList.set(var1_1.line, newLine);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static String replaceRange(String line, int start, int end, String newText) {
        void var2_2;
        String string;
        void var3_3;
        void var1_1;
        return line.substring(0, (int)var1_1) + (String)var3_3 + string.substring((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasExpressionAttributes(XMLParser.ElementContext context) {
        String string;
        void var1_1;
        String expressions = XmlEditor.expressionAttributes(context);
        int size = expressions.size();
        if (size == 0) {
            return false;
        }
        if (var1_1 > true) {
            return true;
        }
        String value = ((XMLParser.AttributeContext)expressions.get((int)0)).attrValue.getText();
        return value.startsWith("\"@{") || string.startsWith("'@{");
    }

    /*
     * WARNING - void declaration
     */
    private static int recurseReplace(XMLParser.ElementContext node, ArrayList<String> lines, ArrayList<Pair<String, XMLParser.ElementContext>> noTag, String newTag, int bindingIndex) {
        XMLParser.ElementContext elementContext;
        void var3_3;
        boolean containsInclude;
        int nextBindingIndex = bindingIndex;
        boolean isMerge = "merge".equals(XmlEditor.nodeName(node));
        boolean bl = containsInclude = XmlEditor.filterNodesByName("include", XmlEditor.elements(node)).size() > 0;
        if (!isMerge && (XmlEditor.hasExpressionAttributes(node) || newTag != null || containsInclude)) {
            String tag = "";
            if (newTag != null) {
                tag = "android:tag=\"" + newTag + "_" + bindingIndex + "\"";
                ++nextBindingIndex;
            } else if (!"include".equals(XmlEditor.nodeName(node))) {
                tag = "android:tag=\"binding_" + bindingIndex + "\"";
                ++nextBindingIndex;
            }
            for (XMLParser.AttributeContext elementContext2 : XmlEditor.expressionAttributes(node)) {
                Position start = XmlEditor.toPosition(elementContext2.getStart());
                Position end = XmlEditor.toEndPosition(elementContext2.getStop());
                String defaultVal = XmlEditor.defaultReplacement(elementContext2);
                if (defaultVal != null) {
                    XmlEditor.replace(lines, start, end, elementContext2.attrName.getText() + "=\"" + defaultVal + "\"");
                    continue;
                }
                if (!XmlEditor.replace(lines, start, end, tag)) continue;
                tag = "";
            }
            if (tag.length() != 0) {
                noTag.add(new ImmutablePair<String, XMLParser.ElementContext>(tag, node));
            }
        }
        Object nextTag = bindingIndex == 0 && isMerge ? var3_3 : null;
        for (XMLParser.ElementContext elementContext2 : XmlEditor.elements(elementContext)) {
            nextBindingIndex = XmlEditor.recurseReplace(elementContext2, lines, noTag, nextTag, nextBindingIndex);
        }
        return nextBindingIndex;
    }

    /*
     * WARNING - void declaration
     */
    private static String defaultReplacement(XMLParser.AttributeContext attr) {
        String textWithQuotes = attr.attrValue.getText();
        String escapedText = textWithQuotes.substring(1, textWithQuotes.length() - 1);
        if (!escapedText.startsWith("@{") || !escapedText.endsWith("}")) {
            return null;
        }
        String text = StringEscapeUtils.unescapeXml(escapedText.substring(2, escapedText.length() - 1));
        String inputStream = new ANTLRInputStream(text);
        String lexer = new BindingExpressionLexer((CharStream)((Object)inputStream));
        String tokenStream = new CommonTokenStream((TokenSource)((Object)lexer));
        tokenStream = new BindingExpressionParser((TokenStream)((Object)tokenStream));
        String defaults = ((BindingExpressionParser.BindingSyntaxContext)((Object)(tokenStream = ((BindingExpressionParser)((Object)tokenStream)).bindingSyntax()))).defaults();
        if (defaults != null) {
            String string;
            BindingExpressionParser.StringLiteralContext stringLiteral;
            String constantValue = ((BindingExpressionParser.DefaultsContext)((Object)defaults)).constantValue();
            BindingExpressionParser.LiteralContext literal = ((BindingExpressionParser.ConstantValueContext)((Object)constantValue)).literal();
            if (literal != null && (stringLiteral = literal.stringLiteral()) != null) {
                void var1_1;
                String quotedStr;
                String doubleQuote = stringLiteral.DoubleQuoteString();
                if (doubleQuote != null) {
                    quotedStr = doubleQuote.getText();
                    quotedStr = quotedStr.substring(1, quotedStr.length() - 1);
                    return StringEscapeUtils.escapeXml10(quotedStr);
                }
                quotedStr = var1_1.SingleQuoteString().getText();
                string = quotedStr.substring(1, string.length() - 1);
                string = string.replace("\"", "\\\"").replace("\\`", "`");
                return StringEscapeUtils.escapeXml10(string);
            }
            return ((RuleContext)((Object)string)).getText();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutablePair<Position, Position> findTerminalPositions(XMLParser.ElementContext node, ArrayList<String> lines) {
        void var2_2;
        Position position;
        void var3_3;
        int index;
        Position endPosition = XmlEditor.toEndPosition(node.getStop());
        Position startPosition = XmlEditor.toPosition(node.getStop());
        do {
            index = lines.get(startPosition.line).lastIndexOf("</");
            --startPosition.line;
        } while (index < 0);
        ++startPosition.line;
        startPosition.charIndex = var3_3;
        return new ImmutablePair<Object, void>(position, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static String replaceWithSpaces(String line, int start, int end) {
        CharSequence charSequence;
        void i;
        CharSequence lineBuilder = new StringBuilder(line);
        while (i <= end) {
            ((StringBuilder)lineBuilder).setCharAt((int)i, ' ');
            ++i;
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static void fixPosition(ArrayList<String> lines, Position pos) {
        String line = lines.get(pos.line);
        while (pos.charIndex > line.length()) {
            --pos.charIndex;
        }
    }

    static class Position {
        int line;
        int charIndex;

        /*
         * WARNING - void declaration
         */
        public Position(int line, int charIndex) {
            void var2_2;
            void var1_1;
            this.line = var1_1;
            this.charIndex = var2_2;
        }
    }
}

