/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.processing.scopes.FileScopeProvider;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import android.databinding.tool.util.ParserHelper;
import android.databinding.tool.util.Preconditions;
import com.google.repacked.apache.commons.lang3.ArrayUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

public class ResourceBundle
implements Serializable {
    private static final String[] ANDROID_VIEW_PACKAGE_VIEWS = new String[]{"View", "ViewGroup", "ViewStub", "TextureView", "SurfaceView"};
    private String mAppPackage;
    private HashMap<String, List<LayoutFileBundle>> mLayoutBundles = new HashMap();

    /*
     * WARNING - void declaration
     */
    public ResourceBundle(String appPackage) {
        void var1_1;
        this.mAppPackage = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addLayoutBundle(LayoutFileBundle bundle) {
        void var1_1;
        void var2_2;
        if (bundle.mFileName == null) {
            L.e("File bundle must have a name. %s does not have one.", bundle);
            return;
        }
        if (!this.mLayoutBundles.containsKey(bundle.mFileName)) {
            this.mLayoutBundles.put(bundle.mFileName, new ArrayList());
        }
        List<LayoutFileBundle> bundles = this.mLayoutBundles.get(bundle.mFileName);
        for (LayoutFileBundle layoutFileBundle : bundles) {
            if (!layoutFileBundle.equals(bundle)) continue;
            L.d("skipping layout bundle %s because it already exists.", bundle);
            return;
        }
        L.d("adding bundle %s", bundle);
        var2_2.add(var1_1);
    }

    public HashMap<String, List<LayoutFileBundle>> getLayoutBundles() {
        return this.mLayoutBundles;
    }

    public String getAppPackage() {
        return this.mAppPackage;
    }

    public void validateMultiResLayouts() {
        for (List<LayoutFileBundle> object : this.mLayoutBundles.values()) {
            for (LayoutFileBundle layoutFileBundle : object) {
                ArrayList<BindingTargetBundle> unboundIncludes = new ArrayList<BindingTargetBundle>();
                for (BindingTargetBundle target : layoutFileBundle.getBindingTargetBundles()) {
                    if (!target.isBinder()) continue;
                    List<LayoutFileBundle> boundTo = this.mLayoutBundles.get(target.getIncludedLayout());
                    if (boundTo == null || boundTo.isEmpty()) {
                        L.d("There is no binding for %s, reverting to plain layout", target.getIncludedLayout());
                        if (target.getId() == null) {
                            unboundIncludes.add(target);
                            continue;
                        }
                        target.setIncludedLayout(null);
                        target.setInterfaceType("android.view.View");
                        target.mViewName = "android.view.View";
                        continue;
                    }
                    String binding = boundTo.get(0).getFullBindingClass();
                    target.setInterfaceType(binding);
                }
                layoutFileBundle.getBindingTargetBundles().removeAll(unboundIncludes);
            }
        }
        for (Map.Entry entry : this.mLayoutBundles.entrySet()) {
            if (((List)entry.getValue()).size() < 2) continue;
            for (LayoutFileBundle layoutFileBundle : (List)entry.getValue()) {
                i$.next().mHasVariations = true;
            }
            this.validateAndGetSharedClassName((List)entry.getValue());
            Map<String, NameTypeLocation> variableTypes = this.validateAndMergeNameTypeLocations((List)entry.getValue(), "Variable declaration (%s - %s) does not match the type defined for layout(%s) in other configurations", new ValidateAndFilterCallback(){

                @Override
                public List<? extends NameTypeLocation> get(LayoutFileBundle bundle) {
                    return bundle.mVariables;
                }
            });
            Map<String, NameTypeLocation> importTypes = this.validateAndMergeNameTypeLocations((List)entry.getValue(), "Import declaration (%s - %s) does not match the import defined for layout(%s) in other configurations", new ValidateAndFilterCallback(){

                public List<NameTypeLocation> get(LayoutFileBundle bundle) {
                    return bundle.mImports;
                }
            });
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                L.d("checking for missing variables in %s / %s", bundle.mFileName, bundle.mConfigName);
                for (Map.Entry<String, NameTypeLocation> variable : variableTypes.entrySet()) {
                    if (NameTypeLocation.contains(bundle.mVariables, variable.getKey())) continue;
                    NameTypeLocation orig = variable.getValue();
                    bundle.addVariable(orig.name, orig.type, orig.location, false);
                    L.d("adding missing variable %s to %s / %s", variable.getKey(), bundle.mFileName, bundle.mConfigName);
                }
                for (Map.Entry<String, NameTypeLocation> userImport : importTypes.entrySet()) {
                    if (NameTypeLocation.contains(bundle.mImports, userImport.getKey())) continue;
                    bundle.mImports.add(userImport.getValue());
                    L.d("adding missing import %s to %s / %s", userImport.getKey(), bundle.mFileName, bundle.mConfigName);
                }
            }
            HashSet<String> includeBindingIds = new HashSet<String>();
            HashSet<String> viewBindingIds = new HashSet<String>();
            HashMap<String, String> viewTypes = new HashMap<String, String>();
            HashMap<String, String> includes = new HashMap<String, String>();
            L.d("validating ids for %s", entry.getKey());
            HashSet<String> conflictingIds = new HashSet<String>();
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                try {
                    Scope.enter(bundle);
                    for (BindingTargetBundle bindingTargetBundle : bundle.mBindingTargetBundles) {
                        Object existingType;
                        try {
                            Scope.enter(bindingTargetBundle);
                            L.d("checking %s %s %s", bindingTargetBundle.getId(), bindingTargetBundle.getFullClassName(), bindingTargetBundle.isBinder());
                            if (bindingTargetBundle.mId == null) continue;
                            if (bindingTargetBundle.isBinder()) {
                                if (viewBindingIds.contains(bindingTargetBundle.mId)) {
                                    L.d("%s is conflicting", bindingTargetBundle.mId);
                                    conflictingIds.add(bindingTargetBundle.mId);
                                    continue;
                                }
                                includeBindingIds.add(bindingTargetBundle.mId);
                            } else {
                                if (includeBindingIds.contains(bindingTargetBundle.mId)) {
                                    L.d("%s is conflicting", bindingTargetBundle.mId);
                                    conflictingIds.add(bindingTargetBundle.mId);
                                    continue;
                                }
                                viewBindingIds.add(bindingTargetBundle.mId);
                            }
                            existingType = (String)viewTypes.get(bindingTargetBundle.mId);
                            if (existingType == null) {
                                L.d("assigning %s as %s", bindingTargetBundle.getId(), bindingTargetBundle.getFullClassName());
                                viewTypes.put(bindingTargetBundle.mId, bindingTargetBundle.getFullClassName());
                                if (!bindingTargetBundle.isBinder()) continue;
                                includes.put(bindingTargetBundle.mId, bindingTargetBundle.getIncludedLayout());
                                continue;
                            }
                            if (((String)existingType).equals(bindingTargetBundle.getFullClassName())) continue;
                            if (bindingTargetBundle.isBinder()) {
                                L.d("overriding %s as base binder", bindingTargetBundle.getId());
                                viewTypes.put(bindingTargetBundle.mId, "android.databinding.ViewDataBinding");
                                includes.put(bindingTargetBundle.mId, bindingTargetBundle.getIncludedLayout());
                                continue;
                            }
                            L.d("overriding %s as base view", bindingTargetBundle.getId());
                            viewTypes.put(bindingTargetBundle.mId, "android.view.View");
                        }
                        catch (ScopedException scopedException) {
                            existingType = scopedException;
                            Scope.defer(scopedException);
                        }
                        finally {
                            Scope.exit();
                        }
                    }
                }
                finally {
                    Scope.exit();
                }
            }
            if (!conflictingIds.isEmpty()) {
                for (LayoutFileBundle bundle : (List)entry.getValue()) {
                    for (BindingTargetBundle bindingTargetBundle : bundle.mBindingTargetBundles) {
                        if (!conflictingIds.contains(bindingTargetBundle.mId)) continue;
                        Scope.registerError(String.format("Cannot use the same id (%s) for a View and an include tag.", bindingTargetBundle.mId), bundle, bindingTargetBundle);
                    }
                }
            }
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                try {
                    Scope.enter(bundle);
                    for (Map.Entry entry2 : viewTypes.entrySet()) {
                        BindingTargetBundle target = bundle.getBindingTargetById((String)entry2.getKey());
                        if (target == null) {
                            String string = (String)includes.get(entry2.getKey());
                            if (string == null) {
                                bundle.createBindingTarget((String)entry2.getKey(), (String)entry2.getValue(), false, null, null, null);
                                continue;
                            }
                            BindingTargetBundle bindingTargetBundle = bundle.createBindingTarget((String)entry2.getKey(), null, false, null, null, null);
                            bindingTargetBundle.setIncludedLayout((String)includes.get(entry2.getKey()));
                            bindingTargetBundle.setInterfaceType((String)entry2.getValue());
                            continue;
                        }
                        L.d("setting interface type on %s (%s) as %s", target.mId, target.getFullClassName(), entry2.getValue());
                        target.setInterfaceType((String)entry2.getValue());
                    }
                }
                catch (ScopedException scopedException) {
                    ScopedException scopedException2 = scopedException;
                    Scope.defer(scopedException);
                }
                finally {
                    Scope.exit();
                }
            }
        }
        for (Map.Entry entry : this.mLayoutBundles.entrySet()) {
            for (LayoutFileBundle bundle : (List)entry.getValue()) {
                String configName;
                if (bundle.hasVariations()) {
                    String parentFileName = bundle.mDirectory;
                    L.d("parent file for %s is %s", bundle.getFileName(), parentFileName);
                    configName = "layout".equals(parentFileName) ? "" : ParserHelper.toClassName(parentFileName.substring(7));
                } else {
                    configName = "";
                }
                LayoutFileBundle.access$102(bundle, configName);
            }
        }
    }

    private Map<String, NameTypeLocation> validateAndMergeNameTypeLocations(List<LayoutFileBundle> bundles, String errorMessage, ValidateAndFilterCallback callback) {
        HashMap<String, NameTypeLocation> result = new HashMap<String, NameTypeLocation>();
        HashSet<String> mismatched = new HashSet<String>();
        for (LayoutFileBundle bundle : bundles) {
            for (NameTypeLocation nameTypeLocation : callback.get(bundle)) {
                NameTypeLocation existing = (NameTypeLocation)result.get(nameTypeLocation.name);
                if (existing != null && !existing.type.equals(nameTypeLocation.type)) {
                    mismatched.add(nameTypeLocation.name);
                    continue;
                }
                result.put(nameTypeLocation.name, nameTypeLocation);
            }
        }
        if (mismatched.isEmpty()) {
            return result;
        }
        for (String mismatch : mismatched) {
            for (LayoutFileBundle layoutFileBundle : bundles) {
                NameTypeLocation found = null;
                for (NameTypeLocation nameTypeLocation : callback.get(layoutFileBundle)) {
                    if (!mismatch.equals(nameTypeLocation.name)) continue;
                    found = nameTypeLocation;
                    break;
                }
                if (found == null) continue;
                Scope.registerError(String.format(errorMessage, found.name, found.type, layoutFileBundle.mDirectory + "/" + layoutFileBundle.getFileName()), layoutFileBundle, found.location.createScope());
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private String validateAndGetSharedClassName(List<LayoutFileBundle> bundles) {
        void var2_2;
        void var1_1;
        void var3_3;
        String sharedClassName = null;
        boolean hasMismatch = false;
        for (LayoutFileBundle bundle : bundles) {
            i$.next().mHasVariations = true;
            String fullBindingClass = bundle.getFullBindingClass();
            if (sharedClassName == null) {
                sharedClassName = fullBindingClass;
                continue;
            }
            if (sharedClassName.equals(fullBindingClass)) continue;
            hasMismatch = true;
            break;
        }
        if (var3_3 == false) {
            return sharedClassName;
        }
        for (LayoutFileBundle bundle : var1_1) {
            Scope.registerError(String.format("Classname (%s) does not match the class name defined for layout(%s) in other configurations", bundle.getFullBindingClass(), bundle.mDirectory + "/" + bundle.getFileName()), bundle, bundle.getClassNameLocationProvider());
        }
        return var2_2;
    }

    static interface ValidateAndFilterCallback {
        public List<? extends NameTypeLocation> get(LayoutFileBundle var1);
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class BindingTargetBundle
    implements LocationScopeProvider,
    Serializable {
        @XmlAttribute(name="id")
        public String mId;
        @XmlAttribute(name="tag", required=true)
        public String mTag;
        @XmlAttribute(name="originalTag")
        public String mOriginalTag;
        @XmlAttribute(name="view", required=false)
        public String mViewName;
        private String mFullClassName;
        public boolean mUsed = true;
        @XmlElementWrapper(name="Expressions")
        @XmlElement(name="Expression")
        public List<BindingBundle> mBindingBundleList = new ArrayList<BindingBundle>();
        @XmlAttribute(name="include")
        public String mIncludedLayout;
        @XmlElement(name="location")
        public Location mLocation;
        private String mInterfaceType;

        public BindingTargetBundle() {
        }

        /*
         * WARNING - void declaration
         */
        public BindingTargetBundle(String id, String viewName, boolean used, String tag, String originalTag, Location location) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mId = var1_1;
            this.mViewName = var2_2;
            this.mUsed = var3_3;
            this.mTag = tag;
            this.mOriginalTag = originalTag;
            this.mLocation = location;
        }

        /*
         * WARNING - void declaration
         */
        public void addBinding(String name, String expr, Location location, Location valueLocation) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mBindingBundleList.add(new BindingBundle((String)var1_1, (String)var2_2, (Location)var3_3, valueLocation));
        }

        /*
         * WARNING - void declaration
         */
        public void setIncludedLayout(String includedLayout) {
            void var1_1;
            this.mIncludedLayout = var1_1;
        }

        public String getIncludedLayout() {
            return this.mIncludedLayout;
        }

        public boolean isBinder() {
            return this.mIncludedLayout != null;
        }

        /*
         * WARNING - void declaration
         */
        public void setInterfaceType(String interfaceType) {
            void var1_1;
            this.mInterfaceType = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setLocation(Location location) {
            void var1_1;
            this.mLocation = var1_1;
        }

        public Location getLocation() {
            return this.mLocation;
        }

        public String getId() {
            return this.mId;
        }

        public String getTag() {
            return this.mTag;
        }

        public String getOriginalTag() {
            return this.mOriginalTag;
        }

        public String getFullClassName() {
            if (this.mFullClassName == null) {
                this.mFullClassName = this.isBinder() ? this.mInterfaceType : (this.mViewName.indexOf(46) == -1 ? (ArrayUtils.contains(ANDROID_VIEW_PACKAGE_VIEWS, this.mViewName) ? "android.view." + this.mViewName : ("WebView".equals(this.mViewName) ? "android.webkit." + this.mViewName : "android.widget." + this.mViewName)) : this.mViewName);
            }
            if (this.mFullClassName == null) {
                L.e("Unexpected full class name = null. view = %s, interface = %s, layout = %s", this.mViewName, this.mInterfaceType, this.mIncludedLayout);
            }
            return this.mFullClassName;
        }

        public boolean isUsed() {
            return this.mUsed;
        }

        public List<BindingBundle> getBindingBundleList() {
            return this.mBindingBundleList;
        }

        public String getInterfaceType() {
            return this.mInterfaceType;
        }

        @Override
        public List<Location> provideScopeLocation() {
            if (this.mLocation == null) {
                return null;
            }
            return Arrays.asList(this.mLocation);
        }

        @XmlAccessorType(value=XmlAccessType.NONE)
        public static class BindingBundle
        implements Serializable {
            private String mName;
            private String mExpr;
            private Location mLocation;
            private Location mValueLocation;

            public BindingBundle() {
            }

            /*
             * WARNING - void declaration
             */
            public BindingBundle(String name, String expr, Location location, Location valueLocation) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.mName = var1_1;
                this.mExpr = var2_2;
                this.mLocation = var3_3;
                this.mValueLocation = valueLocation;
            }

            @XmlAttribute(name="attribute", required=true)
            public String getName() {
                return this.mName;
            }

            @XmlAttribute(name="text", required=true)
            public String getExpr() {
                return this.mExpr;
            }

            /*
             * WARNING - void declaration
             */
            public void setName(String name) {
                void var1_1;
                this.mName = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public void setExpr(String expr) {
                void var1_1;
                this.mExpr = var1_1;
            }

            @XmlElement(name="Location")
            public Location getLocation() {
                return this.mLocation;
            }

            /*
             * WARNING - void declaration
             */
            public void setLocation(Location location) {
                void var1_1;
                this.mLocation = var1_1;
            }

            @XmlElement(name="ValueLocation")
            public Location getValueLocation() {
                return this.mValueLocation;
            }

            /*
             * WARNING - void declaration
             */
            public void setValueLocation(Location valueLocation) {
                void var1_1;
                this.mValueLocation = var1_1;
            }
        }
    }

    public static class MarshalledMapType {
        public List<NameTypeLocation> entries;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class VariableDeclaration
    extends NameTypeLocation {
        @XmlAttribute(name="declared", required=false)
        public boolean declared;

        public VariableDeclaration() {
        }

        /*
         * WARNING - void declaration
         */
        public VariableDeclaration(String name, String type, Location location, boolean declared) {
            super((String)var1_1, (String)var2_2, (Location)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.declared = declared;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class NameTypeLocation {
        @XmlAttribute(name="type", required=true)
        public String type;
        @XmlAttribute(name="name", required=true)
        public String name;
        @XmlElement(name="location", required=false)
        public Location location;

        public NameTypeLocation() {
        }

        /*
         * WARNING - void declaration
         */
        public NameTypeLocation(String name, String type, Location location) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.type = var2_2;
            this.name = var1_1;
            this.location = var3_3;
        }

        public String toString() {
            return "{type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", location=" + this.location + '}';
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameTypeLocation that = (NameTypeLocation)o;
            if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.type.equals(var1_1.type);
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = this.type.hashCode();
            result = result * 31 + this.name.hashCode();
            var1_1 = var1_1 * 31 + (this.location != null ? this.location.hashCode() : 0);
            return (int)var1_1;
        }

        public static boolean contains(List<? extends NameTypeLocation> list, String name) {
            for (NameTypeLocation nameTypeLocation : list) {
                if (!name.equals(nameTypeLocation.name)) continue;
                return true;
            }
            return false;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlRootElement(name="Layout")
    public static class LayoutFileBundle
    implements FileScopeProvider,
    Serializable {
        @XmlAttribute(name="layout", required=true)
        public String mFileName;
        @XmlAttribute(name="modulePackage", required=true)
        public String mModulePackage;
        @XmlAttribute(name="absoluteFilePath", required=true)
        public String mAbsoluteFilePath;
        private String mConfigName;
        @XmlAttribute(name="bindingClass", required=false)
        public String mBindingClass;
        @XmlElement(name="ClassNameLocation", required=false)
        private Location mClassNameLocation;
        private String mFullBindingClass;
        private String mBindingClassName;
        private String mBindingPackage;
        @XmlAttribute(name="directory", required=true)
        public String mDirectory;
        public boolean mHasVariations;
        @XmlElement(name="Variables")
        public List<VariableDeclaration> mVariables = new ArrayList<VariableDeclaration>();
        @XmlElement(name="Imports")
        public List<NameTypeLocation> mImports = new ArrayList<NameTypeLocation>();
        @XmlElementWrapper(name="Targets")
        @XmlElement(name="Target")
        public List<BindingTargetBundle> mBindingTargetBundles = new ArrayList<BindingTargetBundle>();
        @XmlAttribute(name="isMerge", required=true)
        private boolean mIsMerge;
        private LocationScopeProvider mClassNameLocationProvider;

        public LayoutFileBundle() {
        }

        /*
         * WARNING - void declaration
         */
        public LayoutFileBundle(File file, String fileName, String directory, String modulePackage, boolean isMerge) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.mFileName = var2_2;
            this.mDirectory = var3_3;
            this.mModulePackage = modulePackage;
            this.mIsMerge = isMerge;
            this.mAbsoluteFilePath = var1_1.getAbsolutePath();
        }

        public LocationScopeProvider getClassNameLocationProvider() {
            if (this.mClassNameLocationProvider == null && this.mClassNameLocation != null && this.mClassNameLocation.isValid()) {
                this.mClassNameLocationProvider = this.mClassNameLocation.createScope();
            }
            return this.mClassNameLocationProvider;
        }

        /*
         * WARNING - void declaration
         */
        public void addVariable(String name, String type, Location location, boolean declared) {
            void var3_3;
            void var2_2;
            void var1_1;
            Preconditions.check(!NameTypeLocation.contains(this.mVariables, name), "Cannot use same variable name twice. %s in %s", name, location);
            this.mVariables.add(new VariableDeclaration((String)var1_1, (String)var2_2, (Location)var3_3, declared));
        }

        /*
         * WARNING - void declaration
         */
        public void addImport(String alias, String type, Location location) {
            void var3_3;
            void var2_2;
            void var1_1;
            Preconditions.check(!NameTypeLocation.contains(this.mImports, alias), "Cannot import same alias twice. %s in %s", alias, location);
            this.mImports.add(new NameTypeLocation((String)var1_1, (String)var2_2, (Location)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        public BindingTargetBundle createBindingTarget(String id, String viewName, boolean used, String tag, String originalTag, Location location) {
            void var1_1;
            void var3_3;
            void var2_2;
            BindingTargetBundle target = new BindingTargetBundle(id, (String)var2_2, (boolean)var3_3, tag, originalTag, location);
            this.mBindingTargetBundles.add(target);
            return var1_1;
        }

        public boolean isEmpty() {
            return this.mVariables.isEmpty() && this.mImports.isEmpty() && this.mBindingTargetBundles.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public BindingTargetBundle getBindingTargetById(String key) {
            for (BindingTargetBundle target : this.mBindingTargetBundles) {
                void var3_3;
                if (!key.equals(target.mId)) continue;
                return var3_3;
            }
            return null;
        }

        public String getFileName() {
            return this.mFileName;
        }

        public String getConfigName() {
            return this.mConfigName;
        }

        public String getDirectory() {
            return this.mDirectory;
        }

        public boolean hasVariations() {
            return this.mHasVariations;
        }

        public List<VariableDeclaration> getVariables() {
            return this.mVariables;
        }

        public List<NameTypeLocation> getImports() {
            return this.mImports;
        }

        public boolean isMerge() {
            return this.mIsMerge;
        }

        /*
         * WARNING - void declaration
         */
        public String getBindingClassName() {
            if (this.mBindingClassName == null) {
                void var2_2;
                void var1_1;
                String fullClass = this.getFullBindingClass();
                int dotIndex = fullClass.lastIndexOf(46);
                this.mBindingClassName = var1_1.substring((int)(var2_2 + true));
            }
            return this.mBindingClassName;
        }

        /*
         * WARNING - void declaration
         */
        public void setBindingClass(String bindingClass, Location location) {
            void var2_2;
            void var1_1;
            this.mBindingClass = var1_1;
            this.mClassNameLocation = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public String getBindingClassPackage() {
            if (this.mBindingPackage == null) {
                void var2_2;
                void var1_1;
                String fullClass = this.getFullBindingClass();
                int dotIndex = fullClass.lastIndexOf(46);
                this.mBindingPackage = var1_1.substring(0, (int)var2_2);
            }
            return this.mBindingPackage;
        }

        private String getFullBindingClass() {
            if (this.mFullBindingClass == null) {
                this.mFullBindingClass = this.mBindingClass == null ? this.getModulePackage() + ".databinding." + ParserHelper.toClassName(this.getFileName()) + "Binding" : (this.mBindingClass.startsWith(".") ? this.getModulePackage() + this.mBindingClass : (this.mBindingClass.indexOf(46) < 0 ? this.getModulePackage() + ".databinding." + this.mBindingClass : this.mBindingClass));
            }
            return this.mFullBindingClass;
        }

        public List<BindingTargetBundle> getBindingTargetBundles() {
            return this.mBindingTargetBundles;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayoutFileBundle bundle = (LayoutFileBundle)o;
            if (this.mConfigName != null ? !this.mConfigName.equals(bundle.mConfigName) : bundle.mConfigName != null) {
                return false;
            }
            if (this.mDirectory != null ? !this.mDirectory.equals(bundle.mDirectory) : bundle.mDirectory != null) {
                return false;
            }
            return !(this.mFileName != null ? !this.mFileName.equals(bundle.mFileName) : var1_1.mFileName != null);
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = this.mFileName != null ? this.mFileName.hashCode() : 0;
            result = result * 31 + (this.mConfigName != null ? this.mConfigName.hashCode() : 0);
            var1_1 = var1_1 * 31 + (this.mDirectory != null ? this.mDirectory.hashCode() : 0);
            return (int)var1_1;
        }

        public String toString() {
            return "LayoutFileBundle{mHasVariations=" + this.mHasVariations + ", mDirectory='" + this.mDirectory + '\'' + ", mConfigName='" + this.mConfigName + '\'' + ", mModulePackage='" + this.mModulePackage + '\'' + ", mFileName='" + this.mFileName + '\'' + '}';
        }

        public String getModulePackage() {
            return this.mModulePackage;
        }

        public String getAbsoluteFilePath() {
            return this.mAbsoluteFilePath;
        }

        @Override
        public String provideScopeFilePath() {
            return this.mAbsoluteFilePath;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$102(LayoutFileBundle x0, String x1) {
            void var1_1;
            x0.mConfigName = var1_1;
            return x0.mConfigName;
        }
    }
}

