/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.BindingBuildInfo;
import android.databinding.tool.store.LayoutFileParser;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.writer.JavaFileWriter;
import com.google.repacked.apache.commons.lang3.StringEscapeUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class LayoutXmlProcessor {
    public static final String RESOURCE_BUNDLE_PACKAGE = "android.databinding.layouts";
    public static final String CLASS_NAME = "DataBindingInfo";
    private final JavaFileWriter mFileWriter;
    private final ResourceBundle mResourceBundle;
    private final int mMinSdk;
    private boolean mProcessingComplete;
    private boolean mWritten;
    private final boolean mIsLibrary;
    private final String mBuildId = UUID.randomUUID().toString();
    private final List<File> mResources;
    private OriginalFileLookup mOriginalFileLookup;
    private static final FilenameFilter layoutFolderFilter = new FilenameFilter(){

        @Override
        public final boolean accept(File dir, String name) {
            return name.startsWith("layout");
        }
    };
    private static final FilenameFilter xmlFileFilter = new FilenameFilter(){

        @Override
        public final boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".xml");
        }
    };

    /*
     * WARNING - void declaration
     */
    public LayoutXmlProcessor(String applicationPackage, List<File> resources, JavaFileWriter fileWriter, int minSdk, boolean isLibrary) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.mFileWriter = var3_3;
        this.mResourceBundle = new ResourceBundle((String)var1_1);
        this.mResources = var2_2;
        this.mMinSdk = minSdk;
        this.mIsLibrary = isLibrary;
    }

    /*
     * WARNING - void declaration
     */
    public void setOriginalFileLookup(OriginalFileLookup originalFileLookup) {
        void var1_1;
        this.mOriginalFileLookup = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<File> getLayoutFiles(List<File> resources) {
        void var1_1;
        ArrayList<Object> result = new ArrayList<Object>();
        for (File resource : resources) {
            void var2_2;
            if (!resource.exists() || !resource.canRead()) continue;
            if (resource.isDirectory()) {
                for (File file : resource.listFiles(layoutFolderFilter)) {
                    for (File xmlFile : file.listFiles(xmlFileFilter)) {
                        result.add(xmlFile);
                    }
                }
                continue;
            }
            if (!xmlFileFilter.accept(var2_2.getParentFile(), var2_2.getName())) continue;
            result.add(var2_2);
        }
        return var1_1;
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    /*
     * WARNING - void declaration
     */
    public boolean processResources(int minSdk) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (this.mProcessingComplete) {
            return false;
        }
        LayoutFileParser layoutFileParser = new LayoutFileParser();
        for (File xmlFile : LayoutXmlProcessor.getLayoutFiles(this.mResources)) {
            void var3_4;
            ResourceBundle.LayoutFileBundle bindingLayout = layoutFileParser.parseXml(xmlFile, this.mResourceBundle.getAppPackage(), this.mOriginalFileLookup);
            if (bindingLayout == null || bindingLayout.isEmpty()) continue;
            this.mResourceBundle.addLayoutBundle((ResourceBundle.LayoutFileBundle)var3_4);
        }
        this.mProcessingComplete = true;
        return true;
    }

    public void writeLayoutInfoFiles(File xmlOutDir) throws JAXBException {
        if (this.mWritten) {
            return;
        }
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ResourceBundle.LayoutFileBundle.class});
        Marshaller marshaller = jAXBContext.createMarshaller();
        for (List<ResourceBundle.LayoutFileBundle> list : this.mResourceBundle.getLayoutBundles().values()) {
            for (ResourceBundle.LayoutFileBundle layout : list) {
                this.writeXmlFile(xmlOutDir, layout, marshaller);
            }
        }
        this.mWritten = true;
    }

    /*
     * WARNING - void declaration
     */
    private void writeXmlFile(File xmlOutDir, ResourceBundle.LayoutFileBundle layout, Marshaller marshaller) throws JAXBException {
        void var2_2;
        void var1_1;
        void var3_3;
        String filename = this.generateExportFileName(layout) + ".xml";
        String xml = this.toXML(layout, (Marshaller)var3_3);
        this.mFileWriter.writeToFile(new File((File)var1_1, filename), (String)var2_2);
    }

    public String getInfoClassFullName() {
        return "android.databinding.layouts.DataBindingInfo";
    }

    /*
     * WARNING - void declaration
     */
    private String toXML(ResourceBundle.LayoutFileBundle layout, Marshaller marshaller) throws JAXBException {
        void var3_3;
        void var1_1;
        void var2_2;
        StringWriter writer = new StringWriter();
        var2_2.marshal((Object)var1_1, (Writer)writer);
        return var3_3.getBuffer().toString();
    }

    /*
     * WARNING - void declaration
     */
    public String generateExportFileName(ResourceBundle.LayoutFileBundle layout) {
        void var2_3;
        StringBuilder name = new StringBuilder(layout.getFileName());
        name.append('-').append(layout.getDirectory());
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (c != '-') continue;
            name.deleteCharAt(i);
            char c2 = Character.toUpperCase(name.charAt(i));
            name.setCharAt(i, c);
        }
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void writeInfoClass(File sdkDir, File xmlOutDir, File exportClassListTo) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeInfoClass((File)var1_1, (File)var2_2, (File)var3_3, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public void writeInfoClass(File sdkDir, File xmlOutDir, File exportClassListTo, boolean enableDebugLogs, boolean printEncodedErrorLogs) {
        void var1_1;
        void var3_3;
        void var2_2;
        String sdkPath = sdkDir == null ? null : StringEscapeUtils.escapeJava(sdkDir.getAbsolutePath());
        Class<BindingBuildInfo> annotation = BindingBuildInfo.class;
        String layoutInfoPath = StringEscapeUtils.escapeJava(xmlOutDir.getAbsolutePath());
        String exportClassListToPath = exportClassListTo == null ? "" : StringEscapeUtils.escapeJava(exportClassListTo.getAbsolutePath());
        String classString = "package android.databinding.layouts;\n\nimport " + annotation.getCanonicalName() + ";\n\n@" + annotation.getSimpleName() + "(buildId=\"" + this.mBuildId + "\", modulePackage=\"" + this.mResourceBundle.getAppPackage() + "\", sdkRoot=" + "\"" + (sdkPath == null ? "" : sdkPath) + "\",layoutInfoDir=\"" + (String)var2_2 + "\",exportClassListTo=\"" + (String)var3_3 + "\",isLibrary=" + this.mIsLibrary + ",minSdk=" + this.mMinSdk + ",enableDebugLogs=" + enableDebugLogs + ",printEncodedError=" + printEncodedErrorLogs + ")\npublic class " + "DataBindingInfo {}\n";
        this.mFileWriter.writeToFile("android.databinding.layouts.DataBindingInfo", (String)var1_1);
    }

    public static interface OriginalFileLookup {
        public File getOriginalFileFor(File var1);
    }
}

