/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.apache.commons.io;

import com.google.repacked.apache.commons.io.Charsets;
import com.google.repacked.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.List;

public final class FileUtils {
    private static BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    private static BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    private static BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    private static BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    private static BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    private static BigInteger ONE_ZB;

    /*
     * WARNING - void declaration
     */
    private static List<String> readLines(File file, Charset encoding) throws IOException {
        List<String> list;
        FileInputStream in = null;
        try {
            void var1_2;
            if (((File)((Object)list)).exists()) {
                if (((File)((Object)list)).isDirectory()) {
                    throw new IOException("File '" + list + "' exists but is a directory");
                }
                if (!((File)((Object)list)).canRead()) {
                    throw new IOException("File '" + list + "' cannot be read");
                }
            } else {
                throw new FileNotFoundException("File '" + list + "' does not exist");
            }
            in = new FileInputStream((File)((Object)list));
            list = IOUtils.readLines(in, Charsets.toCharset((Charset)var1_2));
        }
        catch (Throwable throwable) {
            void var2_3;
            IOUtils.closeQuietly((InputStream)var2_3);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(File file, String encoding) throws IOException {
        void var1_1;
        return FileUtils.readLines(file, Charsets.toCharset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStringToFile(File file, String data) throws IOException {
        boolean bl = false;
        Charset charset = Charset.defaultCharset();
        File file2 = file;
        FileOutputStream fileOutputStream = null;
        try {
            void var1_4;
            boolean bl2 = false;
            if (file2.exists()) {
                if (file2.isDirectory()) {
                    throw new IOException("File '" + file2 + "' exists but is a directory");
                }
                if (!file2.canWrite()) {
                    throw new IOException("File '" + file2 + "' cannot be written to");
                }
            } else {
                File file3 = file2.getParentFile();
                if (file3 != null && !file3.mkdirs() && !file3.isDirectory()) {
                    throw new IOException("Directory '" + file3 + "' could not be created");
                }
            }
            fileOutputStream = new FileOutputStream(file2, bl2);
            IOUtils.write((String)var1_4, fileOutputStream, charset);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    static {
        ONE_KB_BI.multiply(ONE_PB_BI);
        ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
        ONE_KB_BI.multiply(ONE_ZB);
        Charset.forName("UTF-8");
    }
}

