/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;

public class StringUtils {
    public static final String LINE_SEPARATOR = StandardSystemProperty.LINE_SEPARATOR.value();
    private static final String AMP_ENTITY = "&amp;";
    private static final String QUOT_ENTITY = "&quot;";
    private static final String APOS_ENTITY = "&apos;";
    private static final String LT_ENTITY = "&lt;";
    private static final String GT_ENTITY = "&gt;";
    private static final String TAB_ENTITY = "&#x9;";
    private static final String CR_ENTITY = "&#xD;";
    private static final String LFEED_ENTITY = "&#xA;";

    public static boolean isNotBlank(CharSequence string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String capitalize(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        char ch = string.charAt(0);
        if (Character.isTitleCase(ch)) {
            return string;
        }
        return Character.toTitleCase(ch) + string.substring(1);
    }

    public static String unescapeXml(String escaped) {
        return escaped.replace(QUOT_ENTITY, "\"").replace(LT_ENTITY, "<").replace(GT_ENTITY, ">").replace(APOS_ENTITY, "'").replace(AMP_ENTITY, "&").replace(TAB_ENTITY, "\t").replace(CR_ENTITY, "\r").replace(LFEED_ENTITY, "\n");
    }

    private StringUtils() {
    }
}

