/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.parser.BindingExpressionLexer;
import android.databinding.parser.BindingExpressionParser;
import android.databinding.parser.XMLLexer;
import android.databinding.parser.XMLParser;
import android.databinding.tool.util.L;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class XmlEditor {
    public static String strip(File f, String newTag, String encoding) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        InputStreamReader reader = new InputStreamReader((InputStream)fin, encoding);
        ANTLRInputStream inputStream = new ANTLRInputStream((Reader)reader);
        XMLLexer lexer = new XMLLexer((CharStream)inputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        XMLParser parser = new XMLParser((TokenStream)tokenStream);
        XMLParser.DocumentContext expr = parser.document();
        XMLParser.ElementContext root = expr.element();
        if (root == null || !"layout".equals(XmlEditor.nodeName(root))) {
            return null;
        }
        List<? extends XMLParser.ElementContext> childrenOfRoot = XmlEditor.elements(root);
        List<? extends XMLParser.ElementContext> dataNodes = XmlEditor.filterNodesByName("data", childrenOfRoot);
        if (dataNodes.size() > 1) {
            L.e("Multiple binding data tags in %s. Expecting a maximum of one.", f.getAbsolutePath());
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(FileUtils.readLines((File)f, (String)"utf-8"));
        for (XMLParser.ElementContext elementContext : dataNodes) {
            XmlEditor.replace(lines, XmlEditor.toPosition(elementContext.getStart()), XmlEditor.toEndPosition(elementContext.getStop()), "");
        }
        List<? extends XMLParser.ElementContext> layoutNodes = XmlEditor.excludeNodesByName("data", childrenOfRoot);
        if (layoutNodes.size() != 1) {
            L.e("Only one layout element and one data element are allowed. %s has %d", f.getAbsolutePath(), layoutNodes.size());
        }
        XMLParser.ElementContext elementContext = layoutNodes.get(0);
        ArrayList<Pair<String, XMLParser.ElementContext>> noTag = new ArrayList<Pair<String, XMLParser.ElementContext>>();
        XmlEditor.recurseReplace(elementContext, lines, noTag, newTag, 0);
        Position rootStartTag = XmlEditor.toPosition(root.getStart());
        Position rootEndTag = XmlEditor.toPosition(root.content().getStart());
        XmlEditor.replace(lines, rootStartTag, rootEndTag, "");
        ImmutablePair<Position, Position> endLayoutPositions = XmlEditor.findTerminalPositions(root, lines);
        XmlEditor.replace(lines, (Position)endLayoutPositions.left, (Position)endLayoutPositions.right, "");
        StringBuilder rootAttributes = new StringBuilder();
        for (XMLParser.AttributeContext attributeContext : XmlEditor.attributes(root)) {
            rootAttributes.append(' ').append(attributeContext.getText());
        }
        Pair<String, XMLParser.ElementContext> noTagRoot = null;
        for (Pair<String, XMLParser.ElementContext> pair : noTag) {
            if (pair.getRight() != elementContext) continue;
            noTagRoot = pair;
            break;
        }
        if (noTagRoot != null) {
            ImmutablePair immutablePair = new ImmutablePair((Object)((String)noTagRoot.getLeft() + rootAttributes.toString()), (Object)elementContext);
            int index = noTag.indexOf(noTagRoot);
            noTag.set(index, (Pair<String, XMLParser.ElementContext>)immutablePair);
        } else {
            ImmutablePair immutablePair = new ImmutablePair((Object)rootAttributes.toString(), (Object)elementContext);
            noTag.add((Pair<String, XMLParser.ElementContext>)immutablePair);
        }
        Collections.sort(noTag, new Comparator<Pair<String, XMLParser.ElementContext>>(){

            @Override
            public int compare(Pair<String, XMLParser.ElementContext> o1, Pair<String, XMLParser.ElementContext> o2) {
                Position start1 = XmlEditor.toPosition(((XMLParser.ElementContext)((Object)o1.getRight())).getStart());
                Position start2 = XmlEditor.toPosition(((XMLParser.ElementContext)((Object)o2.getRight())).getStart());
                int lineCmp = start2.line - start1.line;
                if (lineCmp != 0) {
                    return lineCmp;
                }
                return start2.charIndex - start1.charIndex;
            }
        });
        for (Pair<String, XMLParser.ElementContext> it : noTag) {
            XMLParser.ElementContext element = (XMLParser.ElementContext)((Object)it.getRight());
            String tag = (String)it.getLeft();
            Position endTagPosition = XmlEditor.endTagPosition(element);
            XmlEditor.fixPosition(lines, endTagPosition);
            String line = lines.get(endTagPosition.line);
            String newLine = line.substring(0, endTagPosition.charIndex) + " " + tag + line.substring(endTagPosition.charIndex);
            lines.set(endTagPosition.line, newLine);
        }
        return StringUtils.join(lines, (String)SystemUtils.LINE_SEPARATOR);
    }

    private static <T extends XMLParser.ElementContext> List<T> filterNodesByName(String name, Iterable<T> items) {
        ArrayList<XMLParser.ElementContext> result = new ArrayList<XMLParser.ElementContext>();
        for (XMLParser.ElementContext item : items) {
            if (!name.equals(XmlEditor.nodeName(item))) continue;
            result.add(item);
        }
        return result;
    }

    private static <T extends XMLParser.ElementContext> List<T> excludeNodesByName(String name, Iterable<T> items) {
        ArrayList<XMLParser.ElementContext> result = new ArrayList<XMLParser.ElementContext>();
        for (XMLParser.ElementContext item : items) {
            if (name.equals(XmlEditor.nodeName(item))) continue;
            result.add(item);
        }
        return result;
    }

    private static Position toPosition(Token token) {
        return new Position(token.getLine() - 1, token.getCharPositionInLine());
    }

    private static Position toEndPosition(Token token) {
        return new Position(token.getLine() - 1, token.getCharPositionInLine() + token.getText().length());
    }

    public static String nodeName(XMLParser.ElementContext elementContext) {
        return elementContext.elmName.getText();
    }

    public static List<? extends XMLParser.AttributeContext> attributes(XMLParser.ElementContext elementContext) {
        if (elementContext.attribute() == null) {
            return new ArrayList();
        }
        return elementContext.attribute();
    }

    public static List<? extends XMLParser.AttributeContext> expressionAttributes(XMLParser.ElementContext elementContext) {
        ArrayList<XMLParser.AttributeContext> result = new ArrayList<XMLParser.AttributeContext>();
        for (XMLParser.AttributeContext attributeContext : XmlEditor.attributes(elementContext)) {
            String attrName = attributeContext.attrName.getText();
            String value = attributeContext.attrValue.getText();
            if (!attrName.equals("android:tag") && (!value.startsWith("\"@{") || !value.endsWith("}\"")) && (!value.startsWith("'@{") || !value.endsWith("}'"))) continue;
            result.add(attributeContext);
        }
        return result;
    }

    private static Position endTagPosition(XMLParser.ElementContext context) {
        if (context.content() == null) {
            Position endTag = XmlEditor.toPosition(context.getStop());
            if (endTag.charIndex <= 0) {
                L.e("invalid input in %s", new Object[]{context});
            }
            return endTag;
        }
        Position position = XmlEditor.toPosition(context.content().getStart());
        if (position.charIndex <= 0) {
            L.e("invalid input in %s", new Object[]{context});
        }
        --position.charIndex;
        return position;
    }

    public static List<? extends XMLParser.ElementContext> elements(XMLParser.ElementContext context) {
        if (context.content() != null && context.content().element() != null) {
            return context.content().element();
        }
        return new ArrayList();
    }

    private static boolean replace(ArrayList<String> lines, Position start, Position end, String text) {
        XmlEditor.fixPosition(lines, start);
        XmlEditor.fixPosition(lines, end);
        if (start.line != end.line) {
            String startLine = lines.get(start.line);
            String newStartLine = startLine.substring(0, start.charIndex) + text;
            lines.set(start.line, newStartLine);
            for (int i = start.line + 1; i < end.line; ++i) {
                String line = lines.get(i);
                lines.set(i, XmlEditor.replaceWithSpaces(line, 0, line.length() - 1));
            }
            String endLine = lines.get(end.line);
            String newEndLine = XmlEditor.replaceWithSpaces(endLine, 0, end.charIndex - 1);
            lines.set(end.line, newEndLine);
            return true;
        }
        if (end.charIndex - start.charIndex >= text.length()) {
            String line = lines.get(start.line);
            int endTextIndex = start.charIndex + text.length();
            String replacedText = XmlEditor.replaceRange(line, start.charIndex, endTextIndex, text);
            String spacedText = XmlEditor.replaceWithSpaces(replacedText, endTextIndex, end.charIndex - 1);
            lines.set(start.line, spacedText);
            return true;
        }
        String line = lines.get(start.line);
        String newLine = XmlEditor.replaceWithSpaces(line, start.charIndex, end.charIndex - 1);
        lines.set(start.line, newLine);
        return false;
    }

    private static String replaceRange(String line, int start, int end, String newText) {
        return line.substring(0, start) + newText + line.substring(end);
    }

    public static boolean hasExpressionAttributes(XMLParser.ElementContext context) {
        List<? extends XMLParser.AttributeContext> expressions = XmlEditor.expressionAttributes(context);
        int size = expressions.size();
        if (size == 0) {
            return false;
        }
        if (size > 1) {
            return true;
        }
        String value = expressions.get((int)0).attrValue.getText();
        return value.startsWith("\"@{") || value.startsWith("'@{");
    }

    private static int recurseReplace(XMLParser.ElementContext node, ArrayList<String> lines, ArrayList<Pair<String, XMLParser.ElementContext>> noTag, String newTag, int bindingIndex) {
        boolean containsInclude;
        int nextBindingIndex = bindingIndex;
        boolean isMerge = "merge".equals(XmlEditor.nodeName(node));
        boolean bl = containsInclude = XmlEditor.filterNodesByName("include", XmlEditor.elements(node)).size() > 0;
        if (!isMerge && (XmlEditor.hasExpressionAttributes(node) || newTag != null || containsInclude)) {
            String tag = "";
            if (newTag != null) {
                tag = "android:tag=\"" + newTag + "_" + bindingIndex + "\"";
                ++nextBindingIndex;
            } else if (!"include".equals(XmlEditor.nodeName(node))) {
                tag = "android:tag=\"binding_" + bindingIndex + "\"";
                ++nextBindingIndex;
            }
            for (XMLParser.AttributeContext attributeContext : XmlEditor.expressionAttributes(node)) {
                Position start = XmlEditor.toPosition(attributeContext.getStart());
                Position end = XmlEditor.toEndPosition(attributeContext.getStop());
                String defaultVal = XmlEditor.defaultReplacement(attributeContext);
                if (defaultVal != null) {
                    XmlEditor.replace(lines, start, end, attributeContext.attrName.getText() + "=\"" + defaultVal + "\"");
                    continue;
                }
                if (!XmlEditor.replace(lines, start, end, tag)) continue;
                tag = "";
            }
            if (tag.length() != 0) {
                noTag.add((Pair<String, XMLParser.ElementContext>)new ImmutablePair((Object)tag, (Object)node));
            }
        }
        String nextTag = bindingIndex == 0 && isMerge ? newTag : null;
        for (XMLParser.ElementContext elementContext : XmlEditor.elements(node)) {
            nextBindingIndex = XmlEditor.recurseReplace(elementContext, lines, noTag, nextTag, nextBindingIndex);
        }
        return nextBindingIndex;
    }

    private static String defaultReplacement(XMLParser.AttributeContext attr) {
        String textWithQuotes = attr.attrValue.getText();
        String escapedText = textWithQuotes.substring(1, textWithQuotes.length() - 1);
        if (!escapedText.startsWith("@{") || !escapedText.endsWith("}")) {
            return null;
        }
        String text = StringEscapeUtils.unescapeXml((String)escapedText.substring(2, escapedText.length() - 1));
        ANTLRInputStream inputStream = new ANTLRInputStream(text);
        BindingExpressionLexer lexer = new BindingExpressionLexer((CharStream)inputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        BindingExpressionParser parser = new BindingExpressionParser((TokenStream)tokenStream);
        BindingExpressionParser.BindingSyntaxContext root = parser.bindingSyntax();
        BindingExpressionParser.DefaultsContext defaults = root.defaults();
        if (defaults != null) {
            BindingExpressionParser.StringLiteralContext stringLiteral;
            BindingExpressionParser.ConstantValueContext constantValue = defaults.constantValue();
            BindingExpressionParser.LiteralContext literal = constantValue.literal();
            if (literal != null && (stringLiteral = literal.stringLiteral()) != null) {
                TerminalNode doubleQuote = stringLiteral.DoubleQuoteString();
                if (doubleQuote != null) {
                    String quotedStr = doubleQuote.getText();
                    String unquoted = quotedStr.substring(1, quotedStr.length() - 1);
                    return StringEscapeUtils.escapeXml10((String)unquoted);
                }
                String quotedStr = stringLiteral.SingleQuoteString().getText();
                String unquoted = quotedStr.substring(1, quotedStr.length() - 1);
                String unescaped = unquoted.replace("\"", "\\\"").replace("\\`", "`");
                return StringEscapeUtils.escapeXml10((String)unescaped);
            }
            return constantValue.getText();
        }
        return null;
    }

    private static ImmutablePair<Position, Position> findTerminalPositions(XMLParser.ElementContext node, ArrayList<String> lines) {
        int index;
        Position endPosition = XmlEditor.toEndPosition(node.getStop());
        Position startPosition = XmlEditor.toPosition(node.getStop());
        do {
            index = lines.get(startPosition.line).lastIndexOf("</");
            --startPosition.line;
        } while (index < 0);
        ++startPosition.line;
        startPosition.charIndex = index;
        return new ImmutablePair((Object)startPosition, (Object)endPosition);
    }

    private static String replaceWithSpaces(String line, int start, int end) {
        StringBuilder lineBuilder = new StringBuilder(line);
        for (int i = start; i <= end; ++i) {
            lineBuilder.setCharAt(i, ' ');
        }
        return lineBuilder.toString();
    }

    private static void fixPosition(ArrayList<String> lines, Position pos) {
        String line = lines.get(pos.line);
        while (pos.charIndex > line.length()) {
            --pos.charIndex;
        }
    }

    private static class Position {
        int line;
        int charIndex;

        public Position(int line, int charIndex) {
            this.line = line;
            this.charIndex = charIndex;
        }
    }
}

