/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.util.BillingHelper;
import java.util.List;

class BillingBroadcastManager {
    private static final String TAG = "BillingBroadcastManager";
    private static final String ACTION = "com.android.vending.billing.PURCHASES_UPDATED";
    private final Context mContext;
    private final BillingBroadcastReceiver mReceiver;

    BillingBroadcastManager(Context context, @NonNull PurchasesUpdatedListener listener) {
        this.mContext = context;
        this.mReceiver = new BillingBroadcastReceiver(listener);
    }

    void registerReceiver() {
        this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter(ACTION));
    }

    PurchasesUpdatedListener getListener() {
        return this.mReceiver.mListener;
    }

    void destroy() {
        try {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
        }
        catch (IllegalArgumentException ex) {
            BillingHelper.logWarn(TAG, "Receiver was already unregistered: " + ex);
        }
    }

    private class BillingBroadcastReceiver
    extends BroadcastReceiver {
        private final PurchasesUpdatedListener mListener;

        private BillingBroadcastReceiver(PurchasesUpdatedListener listener) {
            this.mListener = listener;
        }

        public void onReceive(Context context, Intent intent) {
            int responseCode = BillingHelper.getResponseCodeFromIntent(intent, BillingBroadcastManager.TAG);
            List<Purchase> purchases = BillingHelper.extractPurchases(intent.getExtras());
            this.mListener.onPurchasesUpdated(responseCode, purchases);
        }
    }
}

