package com.android.billingclient.api;

import com.android.billingclient.api.BillingClient.BillingResponse;

/** Callback that notifies when a consumption operation finishes. */
public interface ConsumeResponseListener {
  /**
   * Called to notify that a consume operation has finished.
   *
   * @param purchaseToken The purchase token that was (or was to be) consumed.
   * @param resultCode The result code from {@link BillingResponse} set to report the result of
   *     consume operation.
   */
  void onConsumeResponse(String purchaseToken, @BillingResponse int resultCode);
}
