/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AccountIdentifiers;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.zzb;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private final String zza;
    private final String zzb;
    private final JSONObject zzc;

    public Purchase(@NonNull String string, @NonNull String string2) throws JSONException {
        this.zza = string;
        this.zzb = string2;
        this.zzc = new JSONObject(this.zza);
    }

    @NonNull
    public String getOrderId() {
        return this.zzc.optString("orderId");
    }

    @NonNull
    public String getPackageName() {
        return this.zzc.optString("packageName");
    }

    @zzb.zza
    @NonNull
    public String getSku() {
        return this.zzc.optString("productId");
    }

    public long getPurchaseTime() {
        return this.zzc.optLong("purchaseTime");
    }

    @NonNull
    public String getPurchaseToken() {
        return this.zzc.optString("token", this.zzc.optString("purchaseToken"));
    }

    public int getPurchaseState() {
        switch (this.zzc.optInt("purchaseState", 1)) {
            case 4: {
                return 2;
            }
        }
        return 1;
    }

    @NonNull
    public String getDeveloperPayload() {
        return this.zzc.optString("developerPayload");
    }

    public boolean isAcknowledged() {
        return this.zzc.optBoolean("acknowledged", true);
    }

    public boolean isAutoRenewing() {
        return this.zzc.optBoolean("autoRenewing");
    }

    @NonNull
    public String getOriginalJson() {
        return this.zza;
    }

    @NonNull
    public String getSignature() {
        return this.zzb;
    }

    @Nullable
    public AccountIdentifiers getAccountIdentifiers() {
        String string = this.zzc.optString("obfuscatedAccountId");
        String string2 = this.zzc.optString("obfuscatedProfileId");
        if (string == null && string2 == null) {
            return null;
        }
        return new AccountIdentifiers(string, string2);
    }

    @NonNull
    public String toString() {
        String string = String.valueOf(this.zza);
        if (string.length() != 0) {
            return "Purchase. Json: ".concat(string);
        }
        return new String("Purchase. Json: ");
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Purchase)) {
            return false;
        }
        Purchase purchase = (Purchase)object;
        return TextUtils.equals((CharSequence)this.zza, (CharSequence)purchase.getOriginalJson()) && TextUtils.equals((CharSequence)this.zzb, (CharSequence)purchase.getSignature());
    }

    public int hashCode() {
        return this.zza.hashCode();
    }

    public static class PurchasesResult {
        @Nullable
        private final List<Purchase> zza;
        private final BillingResult zzb;

        public PurchasesResult(@NonNull BillingResult billingResult, @Nullable List<Purchase> list) {
            this.zza = list;
            this.zzb = billingResult;
        }

        @NonNull
        public BillingResult getBillingResult() {
            return this.zzb;
        }

        public int getResponseCode() {
            return this.getBillingResult().getResponseCode();
        }

        @Nullable
        public List<Purchase> getPurchasesList() {
            return this.zza;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PurchaseState {
        public static final int UNSPECIFIED_STATE = 0;
        public static final int PURCHASED = 1;
        public static final int PENDING = 2;
    }
}

