/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.zzai;
import com.android.billingclient.api.zzb;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public class BillingFlowParams {
    @NonNull
    public static final String EXTRA_PARAM_KEY_ACCOUNT_ID = "accountId";
    @NonNull
    public static final String EXTRA_PARAM_KEY_REPLACE_SKUS_PRORATION_MODE = "prorationMode";
    @NonNull
    public static final String EXTRA_PARAM_KEY_VR = "vr";
    @NonNull
    public static final String EXTRA_PARAM_KEY_OLD_SKUS = "skusToReplace";
    @NonNull
    public static final String EXTRA_PARAM_KEY_OLD_SKU_PURCHASE_TOKEN = "oldSkuPurchaseToken";
    private boolean zza;
    private String zzb;
    private String zzc;
    private String zzd;
    private String zze;
    private String zzf;
    private int zzg = 0;
    private ArrayList<SkuDetails> zzh;
    private boolean zzi;

    private BillingFlowParams() {
    }

    @zzb.zza
    @NonNull
    public String getSku() {
        return this.zzh.get(0).getSku();
    }

    @zzb.zza
    @NonNull
    public String getSkuType() {
        return this.zzh.get(0).getType();
    }

    @zzb.zza
    @NonNull
    public SkuDetails getSkuDetails() {
        return this.zzh.get(0);
    }

    @NonNull
    public final ArrayList<SkuDetails> zza() {
        ArrayList<SkuDetails> arrayList = new ArrayList<SkuDetails>();
        arrayList.addAll(this.zzh);
        return arrayList;
    }

    @Nullable
    @zzb.zza
    public String getOldSku() {
        return this.zzd;
    }

    @Nullable
    @zzb.zza
    public String getOldSkuPurchaseToken() {
        return this.zze;
    }

    @Nullable
    public final String zzb() {
        return this.zzc;
    }

    public boolean getVrPurchaseFlow() {
        return this.zzi;
    }

    @zzb.zza
    public int getReplaceSkusProrationMode() {
        return this.zzg;
    }

    final boolean zzc() {
        return this.zzi || this.zzc != null || this.zzf != null || this.zzg != 0 || this.zza;
    }

    @Nullable
    public final String zzd() {
        return this.zzf;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder(null);
    }

    /* synthetic */ BillingFlowParams(zzai zzai2) {
        this();
    }

    static /* synthetic */ String zza(BillingFlowParams billingFlowParams, String string) {
        billingFlowParams.zzb = null;
        return null;
    }

    public static class Builder {
        private String zza;
        private String zzb;
        private String zzc;
        private String zzd;
        private int zze = 0;
        private ArrayList<SkuDetails> zzf;
        private boolean zzg;

        private Builder() {
        }

        @NonNull
        public Builder setSkuDetails(@NonNull SkuDetails skuDetails) {
            ArrayList<SkuDetails> arrayList = new ArrayList<SkuDetails>();
            arrayList.add(skuDetails);
            this.zzf = arrayList;
            return this;
        }

        @zzb.zza
        @NonNull
        public Builder setOldSku(@NonNull String string, @NonNull String string2) {
            this.zzb = string;
            this.zzc = string2;
            return this;
        }

        @NonNull
        public Builder setReplaceSkusProrationMode(int n) {
            this.zze = n;
            return this;
        }

        @NonNull
        public Builder setObfuscatedAccountId(@NonNull String string) {
            this.zza = string;
            return this;
        }

        @NonNull
        public Builder setVrPurchaseFlow(boolean bl) {
            this.zzg = bl;
            return this;
        }

        @NonNull
        public Builder setObfuscatedProfileId(@NonNull String string) {
            this.zzd = string;
            return this;
        }

        @NonNull
        public BillingFlowParams build() {
            Object object;
            if (this.zzf == null || this.zzf.isEmpty()) {
                throw new IllegalArgumentException("SkuDetails must be provided.");
            }
            ArrayList<SkuDetails> arrayList = this.zzf;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                SkuDetails skuDetails = arrayList.get(i);
                if (skuDetails != null) continue;
                throw new IllegalArgumentException("SKU cannot be null.");
            }
            if (this.zzf.size() > 1) {
                object = this.zzf.get(0);
                String string = ((SkuDetails)object).getType();
                ArrayList<SkuDetails> arrayList2 = this.zzf;
                int n2 = arrayList2.size();
                for (int i = 0; i < n2; ++i) {
                    SkuDetails skuDetails = arrayList2.get(i);
                    SkuDetails skuDetails2 = skuDetails;
                    if (string.equals(skuDetails2.getType())) continue;
                    throw new IllegalArgumentException("SKUs should have the same type.");
                }
                String string2 = ((SkuDetails)object).zza();
                ArrayList<SkuDetails> arrayList3 = this.zzf;
                int n3 = arrayList3.size();
                for (int i = 0; i < n3; ++i) {
                    SkuDetails skuDetails = arrayList3.get(i);
                    SkuDetails skuDetails3 = skuDetails;
                    if (string2.equals(skuDetails3.zza())) continue;
                    throw new IllegalArgumentException("All SKUs must have the same package name.");
                }
            }
            object = new BillingFlowParams(null);
            ((BillingFlowParams)object).zza = !this.zzf.get(0).zza().isEmpty();
            BillingFlowParams.zza((BillingFlowParams)object, null);
            ((BillingFlowParams)object).zzc = this.zza;
            ((BillingFlowParams)object).zzf = this.zzd;
            ((BillingFlowParams)object).zzd = this.zzb;
            ((BillingFlowParams)object).zze = this.zzc;
            ((BillingFlowParams)object).zzg = this.zze;
            ((BillingFlowParams)object).zzh = this.zzf;
            ((BillingFlowParams)object).zzi = this.zzg;
            return object;
        }

        /* synthetic */ Builder(zzai zzai2) {
            this();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProrationMode {
        public static final int UNKNOWN_SUBSCRIPTION_UPGRADE_DOWNGRADE_POLICY = 0;
        public static final int IMMEDIATE_WITH_TIME_PRORATION = 1;
        public static final int IMMEDIATE_AND_CHARGE_PRORATED_PRICE = 2;
        public static final int IMMEDIATE_WITHOUT_PRORATION = 3;
        public static final int DEFERRED = 4;
    }
}

