/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.PriceChangeConfirmationListener;
import com.android.billingclient.api.PriceChangeFlowParams;
import com.android.billingclient.api.ProxyBillingActivity;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.api.zzaa;
import com.android.billingclient.api.zzab;
import com.android.billingclient.api.zzad;
import com.android.billingclient.api.zzae;
import com.android.billingclient.api.zzaf;
import com.android.billingclient.api.zzag;
import com.android.billingclient.api.zzah;
import com.android.billingclient.api.zzak;
import com.android.billingclient.api.zzam;
import com.android.billingclient.api.zzap;
import com.android.billingclient.api.zzd;
import com.android.billingclient.api.zzg;
import com.android.billingclient.api.zzh;
import com.android.billingclient.api.zzi;
import com.android.billingclient.api.zzj;
import com.android.billingclient.api.zzl;
import com.android.billingclient.api.zzm;
import com.android.billingclient.api.zzn;
import com.android.billingclient.api.zzq;
import com.android.billingclient.api.zzr;
import com.android.billingclient.api.zzs;
import com.android.billingclient.api.zzt;
import com.android.billingclient.api.zzu;
import com.android.billingclient.api.zzv;
import com.android.billingclient.api.zzw;
import com.android.billingclient.api.zzx;
import com.android.billingclient.api.zzy;
import com.android.billingclient.api.zzz;
import com.google.android.gms.internal.play_billing.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

class BillingClientImpl
extends BillingClient {
    private int zza = 0;
    private final String zzb;
    private final Handler zzc = new Handler(Looper.getMainLooper());
    private zzd zzd;
    private Context zze;
    private Context zzf;
    private zzc zzg;
    private zza zzh;
    private boolean zzi;
    private boolean zzj;
    private int zzk = 0;
    private boolean zzl;
    private boolean zzm;
    private boolean zzn;
    private boolean zzo;
    private boolean zzp;
    private boolean zzq;
    private boolean zzr;
    private boolean zzs;
    private ExecutorService zzt;
    @Nullable
    private String zzu;

    @UiThread
    BillingClientImpl(@Nullable String string, boolean bl, Context context, PurchasesUpdatedListener purchasesUpdatedListener) {
        this(context, bl, purchasesUpdatedListener, BillingClientImpl.zzb(), null);
    }

    private BillingClientImpl(Activity activity, boolean bl, String string) {
        this(activity.getApplicationContext(), bl, new zzah(), string, null);
    }

    private BillingClientImpl(Context context, boolean bl, PurchasesUpdatedListener purchasesUpdatedListener, String string, String string2) {
        this.zzu = null;
        this.zzb = string;
        this.initialize(context, purchasesUpdatedListener, bl);
    }

    private BillingClientImpl(String string) {
        this.zzb = string;
    }

    @SuppressLint(value={"PrivateApi"})
    private static String zzb() {
        try {
            return (String)Class.forName("com.android.billingclient.ktx.BuildConfig").getField("VERSION_NAME").get(null);
        }
        catch (Exception exception) {
            return "3.0.1";
        }
    }

    private void initialize(Context context, PurchasesUpdatedListener purchasesUpdatedListener, boolean bl) {
        this.zzf = context.getApplicationContext();
        this.zzd = new zzd(this.zzf, purchasesUpdatedListener);
        this.zze = context;
        this.zzs = bl;
    }

    @Override
    public BillingResult isFeatureSupported(String string) {
        if (!((BillingClient)this).isReady()) {
            return zzak.zzo;
        }
        switch (string) {
            case "subscriptions": {
                if (this.zzi) {
                    return zzak.zzn;
                }
                return zzak.zzi;
            }
            case "subscriptionsUpdate": {
                if (this.zzj) {
                    return zzak.zzn;
                }
                return zzak.zzi;
            }
            case "inAppItemsOnVr": {
                return this.zzc("inapp");
            }
            case "subscriptionsOnVr": {
                return this.zzc("subs");
            }
            case "priceChangeConfirmation": {
                if (this.zzm) {
                    return zzak.zzn;
                }
                return zzak.zzi;
            }
            case "bbb": {
                if (this.zzp) {
                    return zzak.zzn;
                }
                return zzak.zzi;
            }
            case "aaa": {
                if (this.zzq) {
                    return zzak.zzn;
                }
                return zzak.zzi;
            }
            case "ccc": 
            case "ddd": {
                if (this.zzr) {
                    return zzak.zzn;
                }
                return zzak.zzi;
            }
        }
        String string2 = String.valueOf(string);
        com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string2.length() != 0 ? "Unsupported feature: ".concat(string2) : new String("Unsupported feature: "));
        return zzak.zzt;
    }

    @Override
    public boolean isReady() {
        return this.zza == 2 && this.zzg != null && this.zzh != null;
    }

    @Override
    public void startConnection(BillingClientStateListener billingClientStateListener) {
        if (((BillingClient)this).isReady()) {
            com.google.android.gms.internal.play_billing.zza.zza("BillingClient", "Service connection is valid. No need to re-initialize.");
            billingClientStateListener.onBillingSetupFinished(zzak.zzn);
            return;
        }
        if (this.zza == 1) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Client is already in the process of connecting to billing service.");
            billingClientStateListener.onBillingSetupFinished(zzak.zzd);
            return;
        }
        if (this.zza == 3) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Client was already closed and can't be reused. Please create another instance.");
            billingClientStateListener.onBillingSetupFinished(zzak.zzo);
            return;
        }
        this.zza = 1;
        this.zzd.zza();
        com.google.android.gms.internal.play_billing.zza.zza("BillingClient", "Starting in-app billing setup.");
        this.zzh = new zza(billingClientStateListener, null);
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        intent.setPackage("com.android.vending");
        List list = this.zzf.getPackageManager().queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string = resolveInfo.serviceInfo.packageName;
                String string2 = resolveInfo.serviceInfo.name;
                if ("com.android.vending".equals(string) && string2 != null) {
                    ComponentName componentName = new ComponentName(string, string2);
                    Intent intent2 = new Intent(intent);
                    intent2.setComponent(componentName);
                    intent2.putExtra("playBillingLibraryVersion", this.zzb);
                    if (this.zzf.bindService(intent2, (ServiceConnection)this.zzh, 1)) {
                        com.google.android.gms.internal.play_billing.zza.zza("BillingClient", "Service was bonded successfully.");
                        return;
                    }
                    com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Connection to Billing service is blocked.");
                } else {
                    com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "The device doesn't have valid Play Store.");
                }
            }
        }
        this.zza = 0;
        com.google.android.gms.internal.play_billing.zza.zza("BillingClient", "Billing service unavailable on device.");
        billingClientStateListener.onBillingSetupFinished(zzak.zzc);
    }

    private void startConnection(long l) {
        ((BillingClient)this).startConnection(new zzah(l));
    }

    @Override
    public void endConnection() {
        try {
            this.zzd.zzc();
            if (this.zzh != null) {
                this.zzh.zza();
            }
            if (this.zzh != null && this.zzg != null) {
                com.google.android.gms.internal.play_billing.zza.zza("BillingClient", "Unbinding from service.");
                this.zzf.unbindService((ServiceConnection)this.zzh);
                this.zzh = null;
            }
            this.zzg = null;
            if (this.zzt != null) {
                this.zzt.shutdownNow();
                this.zzt = null;
            }
            return;
        }
        catch (Exception exception) {
            String string = String.valueOf(exception);
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(48 + String.valueOf(string).length()).append("There was an exception while ending connection: ").append(string).toString());
            return;
        }
        finally {
            this.zza = 3;
        }
    }

    private void launchPriceChangeConfirmationFlow(Activity activity, PriceChangeFlowParams priceChangeFlowParams, long l) {
        ((BillingClient)this).launchPriceChangeConfirmationFlow(activity, priceChangeFlowParams, new zzah(l));
    }

    @Override
    public void launchPriceChangeConfirmationFlow(Activity activity, PriceChangeFlowParams priceChangeFlowParams, PriceChangeConfirmationListener priceChangeConfirmationListener) {
        if (!((BillingClient)this).isReady()) {
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(zzak.zzo);
            return;
        }
        if (priceChangeFlowParams == null || priceChangeFlowParams.getSkuDetails() == null) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Please fix the input params. priceChangeFlowParams must contain valid sku.");
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(zzak.zzm);
            return;
        }
        String string = priceChangeFlowParams.getSkuDetails().getSku();
        if (string == null) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Please fix the input params. priceChangeFlowParams must contain valid sku.");
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(zzak.zzm);
            return;
        }
        if (!this.zzm) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Current client doesn't support price change confirmation flow.");
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(zzak.zzi);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", this.zzb);
        bundle.putBoolean("subs_price_change", true);
        Bundle bundle2 = bundle;
        Future<Bundle> future = this.zza(new zzh(this, string, bundle2), 5000L, null);
        try {
            Bundle bundle3 = future.get(5000L, TimeUnit.MILLISECONDS);
            int n = com.google.android.gms.internal.play_billing.zza.zza(bundle3, "BillingClient");
            String string2 = com.google.android.gms.internal.play_billing.zza.zzb(bundle3, "BillingClient");
            BillingResult billingResult = BillingResult.newBuilder().setResponseCode(n).setDebugMessage(string2).build();
            if (n != 0) {
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(68).append("Unable to launch price change flow, error response code: ").append(n).toString());
                priceChangeConfirmationListener.onPriceChangeConfirmationResult(billingResult);
                return;
            }
            zzs zzs2 = new zzs(this, this.zzc, priceChangeConfirmationListener);
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            PendingIntent pendingIntent = (PendingIntent)bundle3.getParcelable("SUBS_MANAGEMENT_INTENT");
            intent.putExtra("SUBS_MANAGEMENT_INTENT", (Parcelable)pendingIntent);
            intent.putExtra("result_receiver", (Parcelable)zzs2);
            activity.startActivity(intent);
            return;
        }
        catch (CancellationException | TimeoutException exception) {
            String string3 = new StringBuilder(70 + String.valueOf(string).length()).append("Time out while launching Price Change Flow for sku: ").append(string).append("; try to reconnect").toString();
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string3);
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(zzak.zzp);
            return;
        }
        catch (Exception exception) {
            String string4 = new StringBuilder(78 + String.valueOf(string).length()).append("Exception caught while launching Price Change Flow for sku: ").append(string).append("; try to reconnect").toString();
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string4);
            priceChangeConfirmationListener.onPriceChangeConfirmationResult(zzak.zzo);
            return;
        }
    }

    @Override
    public BillingResult launchBillingFlow(Activity activity, BillingFlowParams billingFlowParams) {
        Object object;
        Object object2;
        Object object3;
        String string;
        if (!((BillingClient)this).isReady()) {
            return this.zza(zzak.zzo);
        }
        ArrayList<SkuDetails> arrayList = billingFlowParams.zza();
        SkuDetails skuDetails = arrayList.get(0);
        String string2 = skuDetails.getType();
        if (string2.equals("subs") && !this.zzi) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Current client doesn't support subscriptions.");
            return this.zza(zzak.zzq);
        }
        boolean bl = billingFlowParams.getOldSku() != null;
        if (bl && !this.zzj) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Current client doesn't support subscriptions update.");
            return this.zza(zzak.zzr);
        }
        if (billingFlowParams.zzc() && !this.zzl) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Current client doesn't support extra params for buy intent.");
            return this.zza(zzak.zzh);
        }
        if (arrayList.size() > 1 && !this.zzr) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Current client doesn't support multi-item purchases.");
            return this.zza(zzak.zzs);
        }
        String string3 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = String.valueOf(string3);
            object3 = String.valueOf(arrayList.get(i));
            string3 = new StringBuilder(String.valueOf(string).length() + String.valueOf(object3).length()).append(string).append((String)object3).toString();
            if (i >= arrayList.size() - 1) continue;
            string3 = String.valueOf(string3).concat(", ");
        }
        Future<Bundle> future = string3;
        com.google.android.gms.internal.play_billing.zza.zza("BillingClient", new StringBuilder(41 + String.valueOf(future).length() + String.valueOf(string2).length()).append("Constructing buy intent for ").append((String)((Object)future)).append(", item type: ").append(string2).toString());
        if (this.zzl) {
            string = com.google.android.gms.internal.play_billing.zza.zza(billingFlowParams, this.zzn, this.zzs, this.zzb);
            if (!skuDetails.zzb().isEmpty()) {
                string.putString("skuDetailsToken", skuDetails.zzb());
            }
            object3 = new ArrayList();
            object2 = new ArrayList();
            boolean bl2 = false;
            ArrayList<SkuDetails> arrayList2 = arrayList;
            int n = arrayList2.size();
            int n2 = 0;
            while (n2 < n) {
                SkuDetails skuDetails2 = arrayList2.get(n2);
                ++n2;
                SkuDetails skuDetails3 = skuDetails2;
                if (!skuDetails2.zzb().isEmpty()) {
                    ((ArrayList)object3).add(skuDetails3.zzb());
                }
                String string4 = BillingClientImpl.zza(skuDetails3.getOriginalJson());
                ((ArrayList)object2).add(string4);
                bl2 |= !TextUtils.isEmpty((CharSequence)string4);
            }
            if (!((ArrayList)object3).isEmpty()) {
                string.putStringArrayList("skuDetailsTokens", (ArrayList)object3);
            }
            if (bl2) {
                if (!this.zzr) {
                    return this.zza(zzak.zzi);
                }
                string.putStringArrayList("SKU_OFFER_ID_TOKEN_LIST", (ArrayList)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)skuDetails.zza())) {
                string.putString("skuPackageName", skuDetails.zza());
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzu)) {
                string.putString("accountName", this.zzu);
            }
            if (arrayList.size() > 1) {
                object = new ArrayList(arrayList.size() - 1);
                for (int i = 1; i < arrayList.size(); ++i) {
                    ((ArrayList)object).add(arrayList.get(i).getSku());
                }
                string.putStringArrayList("additionalSkus", (ArrayList)object);
            }
            if (!TextUtils.isEmpty((CharSequence)activity.getIntent().getStringExtra("PROXY_PACKAGE"))) {
                object = activity.getIntent().getStringExtra("PROXY_PACKAGE");
                string.putString("proxyPackage", (String)object);
                try {
                    String string5 = this.zze.getPackageManager().getPackageInfo((String)object, (int)0).versionName;
                    string.putString("proxyPackageVersion", string5);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    string.putString("proxyPackageVersion", "package not found");
                }
            }
            object = string;
            int n3 = 6;
            if (this.zzn) {
                n3 = 9;
            } else if (billingFlowParams.getVrPurchaseFlow()) {
                n3 = 7;
            }
            int n4 = n3;
            future = this.zza(new zzz(this, n4, skuDetails, string2, billingFlowParams, (Bundle)object), 5000L, null);
        } else {
            future = bl ? this.zza(new zzy(this, billingFlowParams, skuDetails), 5000L, null) : this.zza(new zzab(this, skuDetails, string2), 5000L, null);
        }
        try {
            string = future.get(5000L, TimeUnit.MILLISECONDS);
            int n = com.google.android.gms.internal.play_billing.zza.zza((Bundle)string, "BillingClient");
            object2 = com.google.android.gms.internal.play_billing.zza.zzb((Bundle)string, "BillingClient");
            if (n != 0) {
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(52).append("Unable to buy item, Error response code: ").append(n).toString());
                BillingResult billingResult = BillingResult.newBuilder().setResponseCode(n).setDebugMessage((String)object2).build();
                return this.zza(billingResult);
            }
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            object = (PendingIntent)string.getParcelable("BUY_INTENT");
            intent.putExtra("BUY_INTENT", (Parcelable)object);
            activity.startActivity(intent);
        }
        catch (CancellationException | TimeoutException exception) {
            object2 = string3;
            object3 = new StringBuilder(68 + String.valueOf(object2).length()).append("Time out while launching billing flow: ; for sku: ").append((String)object2).append("; try to reconnect").toString();
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", (String)object3);
            return this.zza(zzak.zzp);
        }
        catch (Exception exception) {
            object2 = string3;
            object3 = new StringBuilder(69 + String.valueOf(object2).length()).append("Exception while launching billing flow: ; for sku: ").append((String)object2).append("; try to reconnect").toString();
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", (String)object3);
            return this.zza(zzak.zzo);
        }
        return zzak.zzn;
    }

    private static String zza(String string) {
        try {
            return new JSONObject(string).optString("offer_id_token");
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    private final BillingResult zza(BillingResult billingResult) {
        this.zzd.zzb().onPurchasesUpdated(billingResult, null);
        return billingResult;
    }

    private int launchBillingFlowCpp(Activity activity, BillingFlowParams billingFlowParams) {
        return ((BillingClient)this).launchBillingFlow(activity, billingFlowParams).getResponseCode();
    }

    @Override
    public Purchase.PurchasesResult queryPurchases(String string) {
        if (!((BillingClient)this).isReady()) {
            return new Purchase.PurchasesResult(zzak.zzo, null);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Please provide a valid SKU type.");
            return new Purchase.PurchasesResult(zzak.zzg, null);
        }
        Future<Purchase.PurchasesResult> future = this.zza(new zzaa(this, string), 5000L, null);
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException | TimeoutException exception) {
            return new Purchase.PurchasesResult(zzak.zzp, null);
        }
        catch (Exception exception) {
            return new Purchase.PurchasesResult(zzak.zzl, null);
        }
    }

    @Override
    public void querySkuDetailsAsync(SkuDetailsParams skuDetailsParams, SkuDetailsResponseListener skuDetailsResponseListener) {
        if (!((BillingClient)this).isReady()) {
            skuDetailsResponseListener.onSkuDetailsResponse(zzak.zzo, null);
            return;
        }
        String string = skuDetailsParams.getSkuType();
        List<String> list = skuDetailsParams.getSkusList();
        SkuDetailsParams skuDetailsParams2 = skuDetailsParams;
        Collection collection = null;
        skuDetailsParams2 = skuDetailsParams;
        String string2 = null;
        if (TextUtils.isEmpty((CharSequence)string)) {
            String string3 = "Please fix the input params. SKU type can't be empty.";
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string3);
            skuDetailsResponseListener.onSkuDetailsResponse(zzak.zzg, null);
            return;
        }
        if (!this.zzq && string2 != null) {
            String string4 = "The user's client is too old to handle skuPackageName from SkuDetails.";
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string4);
            skuDetailsResponseListener.onSkuDetailsResponse(zzak.zze, null);
            return;
        }
        if (!this.zzr && collection != null) {
            String string5 = "Play store version is too old to handle skuWithOfferList from SkuDetails.";
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string5);
            skuDetailsResponseListener.onSkuDetailsResponse(zzak.zzi, null);
            return;
        }
        if (list == null && collection == null) {
            String string6 = "Please fix the input params. The list of SKUs can't be empty - set SKU list or SkuWithOffer list.";
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string6);
            skuDetailsResponseListener.onSkuDetailsResponse(zzak.zzf, null);
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (collection != null) {
            arrayList.addAll(collection);
        } else {
            for (String string7 : list) {
                arrayList.add(new zzap.zza(null).zza(string7).zza());
            }
        }
        if (this.zza(new zzad(this, string, arrayList, string2, skuDetailsResponseListener), 30000L, new zzg(this, skuDetailsResponseListener)) == null) {
            skuDetailsResponseListener.onSkuDetailsResponse(this.zzd(), null);
        }
    }

    @Override
    public void consumeAsync(ConsumeParams consumeParams, ConsumeResponseListener consumeResponseListener) {
        if (!((BillingClient)this).isReady()) {
            consumeResponseListener.onConsumeResponse(zzak.zzo, consumeParams.getPurchaseToken());
            return;
        }
        if (this.zza(new zzj(this, consumeParams, consumeResponseListener), 30000L, new zzi(this, consumeResponseListener, consumeParams)) == null) {
            consumeResponseListener.onConsumeResponse(this.zzd(), consumeParams.getPurchaseToken());
        }
    }

    @Override
    public void queryPurchaseHistoryAsync(String string, PurchaseHistoryResponseListener purchaseHistoryResponseListener) {
        if (!((BillingClient)this).isReady()) {
            purchaseHistoryResponseListener.onPurchaseHistoryResponse(zzak.zzo, null);
            return;
        }
        if (this.zza(new zzl(this, string, purchaseHistoryResponseListener), 30000L, new zzn(this, purchaseHistoryResponseListener)) == null) {
            purchaseHistoryResponseListener.onPurchaseHistoryResponse(this.zzd(), null);
        }
    }

    private final zzb zzb(String string) {
        String string2 = String.valueOf(string);
        com.google.android.gms.internal.play_billing.zza.zza("BillingClient", string2.length() != 0 ? "Querying purchase history, item type: ".concat(string2) : new String("Querying purchase history, item type: "));
        String string3 = null;
        ArrayList<PurchaseHistoryRecord> arrayList = new ArrayList<PurchaseHistoryRecord>();
        Bundle bundle = com.google.android.gms.internal.play_billing.zza.zza(this.zzn, this.zzs, this.zzb);
        do {
            Object object;
            Bundle bundle2;
            if (!this.zzl) {
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "getPurchaseHistory is not supported on current device");
                return new zzb(zzak.zzj, null);
            }
            try {
                bundle2 = this.zzg.zza(6, this.zzf.getPackageName(), string, string3, bundle);
            }
            catch (RemoteException remoteException) {
                object = String.valueOf((Object)remoteException);
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(64 + String.valueOf(object).length()).append("Got exception trying to get purchase history: ").append((String)object).append("; try to reconnect").toString());
                return new zzb(zzak.zzo, null);
            }
            BillingResult billingResult = zzam.zza(bundle2, "BillingClient", "getPurchaseHistory()");
            if (billingResult != zzak.zzn) {
                return new zzb(billingResult, null);
            }
            object = bundle2.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle2.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle2.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            for (int i = 0; i < arrayList2.size(); ++i) {
                PurchaseHistoryRecord purchaseHistoryRecord;
                String string4 = (String)arrayList2.get(i);
                String string5 = (String)arrayList3.get(i);
                String string6 = (String)((ArrayList)object).get(i);
                String string7 = String.valueOf(string6);
                com.google.android.gms.internal.play_billing.zza.zza("BillingClient", string7.length() != 0 ? "Purchase record found for sku : ".concat(string7) : new String("Purchase record found for sku : "));
                try {
                    purchaseHistoryRecord = new PurchaseHistoryRecord(string4, string5);
                }
                catch (JSONException jSONException) {
                    String string8 = String.valueOf((Object)jSONException);
                    com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(48 + String.valueOf(string8).length()).append("Got an exception trying to decode the purchase: ").append(string8).toString());
                    return new zzb(zzak.zzl, null);
                }
                if (TextUtils.isEmpty((CharSequence)purchaseHistoryRecord.getPurchaseToken())) {
                    com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "BUG: empty/null token!");
                }
                arrayList.add(purchaseHistoryRecord);
            }
            string3 = bundle2.getString("INAPP_CONTINUATION_TOKEN");
            String string9 = String.valueOf(string3);
            com.google.android.gms.internal.play_billing.zza.zza("BillingClient", string9.length() != 0 ? "Continuation token: ".concat(string9) : new String("Continuation token: "));
        } while (!TextUtils.isEmpty((CharSequence)string3));
        return new zzb(zzak.zzn, arrayList);
    }

    @Override
    public void acknowledgePurchase(AcknowledgePurchaseParams acknowledgePurchaseParams, AcknowledgePurchaseResponseListener acknowledgePurchaseResponseListener) {
        if (!((BillingClient)this).isReady()) {
            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(zzak.zzo);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)acknowledgePurchaseParams.getPurchaseToken())) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Please provide a valid purchase token.");
            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(zzak.zzk);
            return;
        }
        if (!this.zzn) {
            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(zzak.zzb);
            return;
        }
        if (this.zza(new zzm(this, acknowledgePurchaseParams, acknowledgePurchaseResponseListener), 30000L, new zzr(this, acknowledgePurchaseResponseListener)) == null) {
            acknowledgePurchaseResponseListener.onAcknowledgePurchaseResponse(this.zzd());
        }
    }

    @Nullable
    private final <T> Future<T> zza(Callable<T> callable, long l, @Nullable Runnable runnable) {
        Future<T> future;
        long l2 = (long)(0.95 * (double)l);
        if (this.zzt == null) {
            this.zzt = Executors.newFixedThreadPool(com.google.android.gms.internal.play_billing.zza.zza, new zzq(this));
        }
        try {
            future = this.zzt.submit(callable);
        }
        catch (Exception exception) {
            String string = String.valueOf(exception);
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(28 + String.valueOf(string).length()).append("Async task throws exception ").append(string).toString());
            return null;
        }
        this.zzc.postDelayed((Runnable)new zzt(this, future, runnable), l2);
        return future;
    }

    private final BillingResult zzc(String string) {
        Future<Integer> future = this.zza(new zzv(this, string), 5000L, null);
        try {
            if (future.get(5000L, TimeUnit.MILLISECONDS) == 0) {
                return zzak.zzn;
            }
            return zzak.zzi;
        }
        catch (Exception exception) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Exception while checking if billing is supported; try to reconnect");
            return zzak.zzo;
        }
    }

    private static Bundle zzc() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("vr", true);
        return bundle;
    }

    @VisibleForTesting
    final SkuDetails.zza zza(String string, List<zzap> list, @Nullable String string2) {
        ArrayList<SkuDetails> arrayList = new ArrayList<SkuDetails>();
        int n = list.size();
        for (int i = 0; i < n; i += 20) {
            String string3;
            zzap zzap2;
            int n2 = i + 20;
            if (n2 > n) {
                n2 = n;
            }
            ArrayList<zzap> arrayList2 = new ArrayList<zzap>(list.subList(i, n2));
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<zzap> arrayList4 = arrayList2;
            int n3 = arrayList4.size();
            for (int j = 0; j < n3; ++j) {
                zzap zzap3 = arrayList4.get(j);
                zzap2 = zzap3;
                arrayList3.add(zzap2.zza());
            }
            Bundle bundle = new Bundle();
            bundle.putStringArrayList("ITEM_ID_LIST", arrayList3);
            bundle.putString("playBillingLibraryVersion", this.zzb);
            try {
                zzap2 = this.zzo ? this.zzg.zza(10, this.zzf.getPackageName(), string, bundle, com.google.android.gms.internal.play_billing.zza.zza(this.zzk, this.zzs, this.zzb, string2, arrayList2)) : this.zzg.zza(3, this.zzf.getPackageName(), string, bundle);
            }
            catch (Exception exception) {
                String string4 = "querySkuDetailsAsync got a remote exception (try to reconnect).";
                string3 = String.valueOf(exception);
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append(string3).toString());
                return new SkuDetails.zza(-1, "Service connection is disconnected.", null);
            }
            if (zzap2 == null) {
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "querySkuDetailsAsync got null sku details list");
                return new SkuDetails.zza(4, "Item is unavailable for purchase.", null);
            }
            if (!zzap2.containsKey("DETAILS_LIST")) {
                int n4 = com.google.android.gms.internal.play_billing.zza.zza((Bundle)zzap2, "BillingClient");
                String string5 = com.google.android.gms.internal.play_billing.zza.zzb((Bundle)zzap2, "BillingClient");
                if (n4 != 0) {
                    string3 = new StringBuilder(50).append("getSkuDetails() failed. Response code: ").append(n4).toString();
                    com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string3);
                    return new SkuDetails.zza(n4, string5, arrayList);
                }
                string3 = "getSkuDetails() returned a bundle with neither an error nor a detail list.";
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string3);
                return new SkuDetails.zza(6, string5, arrayList);
            }
            ArrayList arrayList5 = zzap2.getStringArrayList("DETAILS_LIST");
            if (arrayList5 == null) {
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "querySkuDetailsAsync got null response list");
                return new SkuDetails.zza(4, "Item is unavailable for purchase.", null);
            }
            for (int j = 0; j < arrayList5.size(); ++j) {
                SkuDetails skuDetails;
                string3 = (String)arrayList5.get(j);
                try {
                    skuDetails = new SkuDetails(string3);
                }
                catch (JSONException jSONException) {
                    String string6 = "Got a JSON exception trying to decode SkuDetails.";
                    com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", string6);
                    return new SkuDetails.zza(6, "Error trying to decode SkuDetails.", null);
                }
                String string7 = String.valueOf(skuDetails);
                com.google.android.gms.internal.play_billing.zza.zza("BillingClient", new StringBuilder(17 + String.valueOf(string7).length()).append("Got sku details: ").append(string7).toString());
                arrayList.add(skuDetails);
            }
        }
        return new SkuDetails.zza(0, "", arrayList);
    }

    private final Purchase.PurchasesResult zzd(String string) {
        String string2 = String.valueOf(string);
        com.google.android.gms.internal.play_billing.zza.zza("BillingClient", string2.length() != 0 ? "Querying owned items, item type: ".concat(string2) : new String("Querying owned items, item type: "));
        String string3 = null;
        ArrayList<Purchase> arrayList = new ArrayList<Purchase>();
        Bundle bundle = com.google.android.gms.internal.play_billing.zza.zza(this.zzn, this.zzs, this.zzb);
        do {
            Object object;
            Bundle bundle2;
            try {
                bundle2 = this.zzn ? this.zzg.zzc(9, this.zzf.getPackageName(), string, string3, bundle) : this.zzg.zza(3, this.zzf.getPackageName(), string, string3);
            }
            catch (Exception exception) {
                object = String.valueOf(exception);
                com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(57 + String.valueOf(object).length()).append("Got exception trying to get purchases: ").append((String)object).append("; try to reconnect").toString());
                return new Purchase.PurchasesResult(zzak.zzo, null);
            }
            BillingResult billingResult = zzam.zza(bundle2, "BillingClient", "getPurchase()");
            if (billingResult != zzak.zzn) {
                return new Purchase.PurchasesResult(billingResult, null);
            }
            object = bundle2.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle2.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle2.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            for (int i = 0; i < arrayList2.size(); ++i) {
                Purchase purchase;
                String string4 = (String)arrayList2.get(i);
                String string5 = (String)arrayList3.get(i);
                String string6 = (String)((ArrayList)object).get(i);
                String string7 = String.valueOf(string6);
                com.google.android.gms.internal.play_billing.zza.zza("BillingClient", string7.length() != 0 ? "Sku is owned: ".concat(string7) : new String("Sku is owned: "));
                try {
                    purchase = new Purchase(string4, string5);
                }
                catch (JSONException jSONException) {
                    String string8 = String.valueOf((Object)jSONException);
                    com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", new StringBuilder(48 + String.valueOf(string8).length()).append("Got an exception trying to decode the purchase: ").append(string8).toString());
                    return new Purchase.PurchasesResult(zzak.zzl, null);
                }
                if (TextUtils.isEmpty((CharSequence)purchase.getPurchaseToken())) {
                    com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "BUG: empty/null token!");
                }
                arrayList.add(purchase);
            }
            string3 = bundle2.getString("INAPP_CONTINUATION_TOKEN");
            String string9 = String.valueOf(string3);
            com.google.android.gms.internal.play_billing.zza.zza("BillingClient", string9.length() != 0 ? "Continuation token: ".concat(string9) : new String("Continuation token: "));
        } while (!TextUtils.isEmpty((CharSequence)string3));
        return new Purchase.PurchasesResult(zzak.zzn, arrayList);
    }

    private final void zza(Runnable runnable) {
        if (Thread.interrupted()) {
            return;
        }
        this.zzc.post(runnable);
    }

    @WorkerThread
    private final void zza(ConsumeParams consumeParams, ConsumeResponseListener consumeResponseListener) {
        String string = consumeParams.getPurchaseToken();
        try {
            String string2;
            int n;
            Object object;
            String string3 = String.valueOf(string);
            com.google.android.gms.internal.play_billing.zza.zza("BillingClient", string3.length() != 0 ? "Consuming purchase with token: ".concat(string3) : new String("Consuming purchase with token: "));
            if (this.zzn) {
                object = this.zzg.zzc(9, this.zzf.getPackageName(), string, com.google.android.gms.internal.play_billing.zza.zza(consumeParams, this.zzn, this.zzb));
                n = object.getInt("RESPONSE_CODE");
                string2 = com.google.android.gms.internal.play_billing.zza.zzb(object, "BillingClient");
            } else {
                n = this.zzg.zzb(3, this.zzf.getPackageName(), string);
                string2 = "";
            }
            object = BillingResult.newBuilder().setResponseCode(n).setDebugMessage(string2).build();
            if (n == 0) {
                this.zza(new zzu(this, consumeResponseListener, (BillingResult)object, string));
                return;
            }
            this.zza(new zzx(this, n, consumeResponseListener, (BillingResult)object, string));
            return;
        }
        catch (Exception exception) {
            this.zza(new zzw(this, exception, consumeResponseListener, string));
            return;
        }
    }

    private final BillingResult zzd() {
        if (this.zza == 0 || this.zza == 3) {
            return zzak.zzo;
        }
        return zzak.zzl;
    }

    static /* synthetic */ Context zza(BillingClientImpl billingClientImpl) {
        return billingClientImpl.zzf;
    }

    static /* synthetic */ zzc zzb(BillingClientImpl billingClientImpl) {
        return billingClientImpl.zzg;
    }

    static /* synthetic */ Purchase.PurchasesResult zza(BillingClientImpl billingClientImpl, String string) {
        return billingClientImpl.zzd(string);
    }

    static /* synthetic */ void zza(BillingClientImpl billingClientImpl, ConsumeParams consumeParams, ConsumeResponseListener consumeResponseListener) {
        billingClientImpl.zza(consumeParams, consumeResponseListener);
    }

    static /* synthetic */ zzb zzb(BillingClientImpl billingClientImpl, String string) {
        return billingClientImpl.zzb(string);
    }

    static /* synthetic */ String zzc(BillingClientImpl billingClientImpl) {
        return billingClientImpl.zzb;
    }

    static /* synthetic */ Bundle zza() {
        return BillingClientImpl.zzc();
    }

    static /* synthetic */ boolean zza(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzj = bl;
        return billingClientImpl.zzj;
    }

    static /* synthetic */ boolean zzb(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzi = bl;
        return billingClientImpl.zzi;
    }

    static /* synthetic */ int zzb(BillingClientImpl billingClientImpl, int n) {
        billingClientImpl.zzk = n;
        return billingClientImpl.zzk;
    }

    static /* synthetic */ boolean zzc(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzr = bl;
        return billingClientImpl.zzr;
    }

    static /* synthetic */ int zzd(BillingClientImpl billingClientImpl) {
        return billingClientImpl.zzk;
    }

    static /* synthetic */ boolean zzd(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzq = bl;
        return billingClientImpl.zzq;
    }

    static /* synthetic */ boolean zze(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzp = bl;
        return billingClientImpl.zzp;
    }

    static /* synthetic */ boolean zzf(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzo = bl;
        return billingClientImpl.zzo;
    }

    static /* synthetic */ boolean zzg(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzn = bl;
        return billingClientImpl.zzn;
    }

    static /* synthetic */ boolean zzh(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzm = bl;
        return billingClientImpl.zzm;
    }

    static /* synthetic */ boolean zzi(BillingClientImpl billingClientImpl, boolean bl) {
        billingClientImpl.zzl = bl;
        return billingClientImpl.zzl;
    }

    private static final class zzb {
        private final List<PurchaseHistoryRecord> zza;
        private final BillingResult zzb;

        zzb(BillingResult billingResult, @Nullable List<PurchaseHistoryRecord> list) {
            this.zza = list;
            this.zzb = billingResult;
        }

        final BillingResult zza() {
            return this.zzb;
        }

        final List<PurchaseHistoryRecord> zzb() {
            return this.zza;
        }
    }

    private final class zza
    implements ServiceConnection {
        private final Object zzb = new Object();
        private boolean zzc = false;
        private BillingClientStateListener zzd;

        private zza(BillingClientStateListener billingClientStateListener) {
            this.zzd = billingClientStateListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceDisconnected(ComponentName componentName) {
            com.google.android.gms.internal.play_billing.zza.zzb("BillingClient", "Billing service disconnected.");
            BillingClientImpl.this.zzg = null;
            BillingClientImpl.this.zza = 0;
            Object object = this.zzb;
            synchronized (object) {
                if (this.zzd != null) {
                    this.zzd.onBillingServiceDisconnected();
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void zza() {
            Object object = this.zzb;
            synchronized (object) {
                this.zzd = null;
                this.zzc = true;
                return;
            }
        }

        private final void zza(BillingResult billingResult) {
            BillingClientImpl.this.zza(new zzae(this, billingResult));
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            com.google.android.gms.internal.play_billing.zza.zza("BillingClient", "Billing service connected.");
            BillingClientImpl.this.zzg = com.google.android.gms.internal.play_billing.zzb.zza(iBinder);
            if (BillingClientImpl.this.zza(new zzag(this), 30000L, new zzaf(this)) == null) {
                this.zza(BillingClientImpl.this.zzd());
            }
        }

        /* synthetic */ zza(BillingClientStateListener billingClientStateListener, zzh zzh2) {
            this(billingClientStateListener);
        }

        static /* synthetic */ Object zza(zza zza2) {
            return zza2.zzb;
        }

        static /* synthetic */ BillingClientStateListener zzb(zza zza2) {
            return zza2.zzd;
        }

        static /* synthetic */ boolean zzc(zza zza2) {
            return zza2.zzc;
        }

        static /* synthetic */ void zza(zza zza2, BillingResult billingResult) {
            zza2.zza(billingResult);
        }
    }
}

