/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingBroadcastManager;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientNativeCallback;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.BillingResults;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.PriceChangeConfirmationListener;
import com.android.billingclient.api.PriceChangeFlowParams;
import com.android.billingclient.api.ProxyBillingActivity;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseApiResponseChecker;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.RewardLoadParams;
import com.android.billingclient.api.RewardResponseListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.util.BillingHelper;
import com.android.vending.billing.IInAppBillingService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;

class BillingClientImpl
extends BillingClient {
    private static final String TAG = "BillingClient";
    private static final long SYNCHRONOUS_TIMEOUT_IN_MILLISECONDS = 5000L;
    private static final long ASYNCHRONOUS_TIMEOUT_IN_MILLISECONDS = 30000L;
    private static final int MAX_SKU_DETAILS_ITEMS_PER_REQUEST = 20;
    private int mClientState = 0;
    private static final String GET_SKU_DETAILS_ITEM_LIST = "ITEM_ID_LIST";
    private static final int MAX_IAP_VERSION = 10;
    private static final int MIN_IAP_VERSION = 3;
    private final String mQualifiedVersionNumber;
    private final Handler mUiThreadHandler = new Handler(Looper.getMainLooper());
    private final BillingBroadcastManager mBroadcastManager;
    private final Context mApplicationContext;
    private final int mChildDirected;
    private final int mUnderAgeOfConsent;
    private IInAppBillingService mService;
    private BillingServiceConnection mServiceConnection;
    private boolean mSubscriptionsSupported;
    private boolean mSubscriptionUpdateSupported;
    private boolean mIABv6Supported;
    private boolean mIABv8Supported;
    private boolean mIABv9Supported;
    private boolean mIABv10Supported;
    private final boolean mEnablePendingPurchases;
    private ExecutorService mExecutorService;
    private final ResultReceiver onPurchaseFinishedReceiver = new ResultReceiver(this.mUiThreadHandler){

        public void onReceiveResult(int resultCode, Bundle resultData) {
            PurchasesUpdatedListener purchasesUpdatedListener = BillingClientImpl.this.mBroadcastManager.getListener();
            if (purchasesUpdatedListener == null) {
                BillingHelper.logWarn(BillingClientImpl.TAG, "PurchasesUpdatedListener is null - no way to return the response.");
                return;
            }
            List<Purchase> purchases = BillingHelper.extractPurchases(resultData);
            BillingResult billingResult = BillingResult.newBuilder().setResponseCode(resultCode).setDebugMessage(BillingHelper.getDebugMessageFromBundle(resultData, BillingClientImpl.TAG)).build();
            purchasesUpdatedListener.onPurchasesUpdated(billingResult, purchases);
        }
    };

    @VisibleForTesting
    void setExecutorService(ExecutorService executorService) {
        this.mExecutorService = executorService;
    }

    @UiThread
    BillingClientImpl(@NonNull Context context, int childDirected, int underAgeOfConsent, boolean enablePendingPurchases, @NonNull PurchasesUpdatedListener listener) {
        this(context, childDirected, underAgeOfConsent, enablePendingPurchases, listener, "2.0.3");
    }

    private BillingClientImpl(Activity activity, int childDirected, int underAgeOfConsent, boolean enablePendingPurchases, String versionOverride) {
        this(activity.getApplicationContext(), childDirected, underAgeOfConsent, enablePendingPurchases, new BillingClientNativeCallback(), versionOverride);
    }

    private BillingClientImpl(@NonNull Context context, int childDirected, int underAgeOfConsent, boolean enablePendingPurchases, @NonNull PurchasesUpdatedListener listener, String versionNumber) {
        this.mApplicationContext = context.getApplicationContext();
        this.mChildDirected = childDirected;
        this.mUnderAgeOfConsent = underAgeOfConsent;
        this.mEnablePendingPurchases = enablePendingPurchases;
        this.mBroadcastManager = new BillingBroadcastManager(this.mApplicationContext, listener);
        this.mQualifiedVersionNumber = versionNumber;
    }

    @Override
    public BillingResult isFeatureSupported(String feature) {
        if (!this.isReady()) {
            return BillingResults.SERVICE_DISCONNECTED;
        }
        switch (feature) {
            case "subscriptions": {
                return this.mSubscriptionsSupported ? BillingResults.OK : BillingResults.FEATURE_NOT_SUPPORTED;
            }
            case "subscriptionsUpdate": {
                return this.mSubscriptionUpdateSupported ? BillingResults.OK : BillingResults.FEATURE_NOT_SUPPORTED;
            }
            case "inAppItemsOnVr": {
                return this.isBillingSupportedOnVr("inapp");
            }
            case "subscriptionsOnVr": {
                return this.isBillingSupportedOnVr("subs");
            }
            case "priceChangeConfirmation": {
                return this.mIABv8Supported ? BillingResults.OK : BillingResults.FEATURE_NOT_SUPPORTED;
            }
        }
        BillingHelper.logWarn(TAG, "Unsupported feature: " + feature);
        return BillingResults.UNKNOWN_FEATURE;
    }

    @Override
    public boolean isReady() {
        return this.mClientState == 2 && this.mService != null && this.mServiceConnection != null;
    }

    @Override
    public void startConnection(@NonNull BillingClientStateListener listener) {
        if (this.isReady()) {
            BillingHelper.logVerbose(TAG, "Service connection is valid. No need to re-initialize.");
            listener.onBillingSetupFinished(BillingResults.OK);
            return;
        }
        if (this.mClientState == 1) {
            BillingHelper.logWarn(TAG, "Client is already in the process of connecting to billing service.");
            listener.onBillingSetupFinished(BillingResults.CLIENT_CONNECTING);
            return;
        }
        if (this.mClientState == 3) {
            BillingHelper.logWarn(TAG, "Client was already closed and can't be reused. Please create another instance.");
            listener.onBillingSetupFinished(BillingResults.SERVICE_DISCONNECTED);
            return;
        }
        this.mClientState = 1;
        this.mBroadcastManager.registerReceiver();
        BillingHelper.logVerbose(TAG, "Starting in-app billing setup.");
        this.mServiceConnection = new BillingServiceConnection(listener);
        Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        serviceIntent.setPackage("com.android.vending");
        List intentServices = this.mApplicationContext.getPackageManager().queryIntentServices(serviceIntent, 0);
        if (intentServices != null && !intentServices.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)intentServices.get(0);
            if (resolveInfo.serviceInfo != null) {
                String packageName = resolveInfo.serviceInfo.packageName;
                String className = resolveInfo.serviceInfo.name;
                if ("com.android.vending".equals(packageName) && className != null) {
                    ComponentName component = new ComponentName(packageName, className);
                    Intent explicitServiceIntent = new Intent(serviceIntent);
                    explicitServiceIntent.setComponent(component);
                    explicitServiceIntent.putExtra("playBillingLibraryVersion", this.mQualifiedVersionNumber);
                    boolean connectionResult = this.mApplicationContext.bindService(explicitServiceIntent, (ServiceConnection)this.mServiceConnection, 1);
                    if (connectionResult) {
                        BillingHelper.logVerbose(TAG, "Service was bonded successfully.");
                        return;
                    }
                    BillingHelper.logWarn(TAG, "Connection to Billing service is blocked.");
                } else {
                    BillingHelper.logWarn(TAG, "The device doesn't have valid Play Store.");
                }
            }
        }
        this.mClientState = 0;
        BillingHelper.logVerbose(TAG, "Billing service unavailable on device.");
        listener.onBillingSetupFinished(BillingResults.BILLING_UNAVAILABLE);
    }

    private void startConnection(long futureHandle) {
        this.startConnection(new BillingClientNativeCallback(futureHandle));
    }

    @Override
    public void endConnection() {
        try {
            this.mBroadcastManager.destroy();
            if (this.mServiceConnection != null) {
                this.mServiceConnection.markDisconnectedAndCleanUp();
            }
            if (this.mServiceConnection != null && this.mService != null) {
                BillingHelper.logVerbose(TAG, "Unbinding from service.");
                this.mApplicationContext.unbindService((ServiceConnection)this.mServiceConnection);
                this.mServiceConnection = null;
            }
            this.mService = null;
            if (this.mExecutorService != null) {
                this.mExecutorService.shutdownNow();
                this.mExecutorService = null;
            }
        }
        catch (Exception ex) {
            BillingHelper.logWarn(TAG, "There was an exception while ending connection: " + ex);
        }
        finally {
            this.mClientState = 3;
        }
    }

    private void launchPriceChangeConfirmationFlow(Activity activity, PriceChangeFlowParams priceChangeFlowParams, long futureHandle) {
        this.launchPriceChangeConfirmationFlow(activity, priceChangeFlowParams, new BillingClientNativeCallback(futureHandle));
    }

    @Override
    public void launchPriceChangeConfirmationFlow(Activity activity, PriceChangeFlowParams priceChangeFlowParams, final @NonNull PriceChangeConfirmationListener listener) {
        if (!this.isReady()) {
            listener.onPriceChangeConfirmationResult(BillingResults.SERVICE_DISCONNECTED);
            return;
        }
        if (priceChangeFlowParams == null || priceChangeFlowParams.getSkuDetails() == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. priceChangeFlowParams must contain valid sku.");
            listener.onPriceChangeConfirmationResult(BillingResults.NULL_SKU);
            return;
        }
        final String sku = priceChangeFlowParams.getSkuDetails().getSku();
        if (sku == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. priceChangeFlowParams must contain valid sku.");
            listener.onPriceChangeConfirmationResult(BillingResults.NULL_SKU);
            return;
        }
        if (!this.mIABv8Supported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support price change confirmation flow.");
            listener.onPriceChangeConfirmationResult(BillingResults.FEATURE_NOT_SUPPORTED);
            return;
        }
        Bundle extraParams = new Bundle();
        extraParams.putString("playBillingLibraryVersion", this.mQualifiedVersionNumber);
        extraParams.putBoolean("subs_price_change", true);
        final Bundle extraParamsFinal = extraParams;
        Future<Bundle> futurePriceChangeIntentBundle = this.executeAsync(new Callable<Bundle>(){

            @Override
            public Bundle call() throws Exception {
                return BillingClientImpl.this.mService.getSubscriptionManagementIntent(8, BillingClientImpl.this.mApplicationContext.getPackageName(), sku, "subs", extraParamsFinal);
            }
        }, 5000L, null);
        try {
            Bundle priceChangeIntentBundle = futurePriceChangeIntentBundle.get(5000L, TimeUnit.MILLISECONDS);
            int responseCode = BillingHelper.getResponseCodeFromBundle(priceChangeIntentBundle, TAG);
            String debugMessage = BillingHelper.getDebugMessageFromBundle(priceChangeIntentBundle, TAG);
            BillingResult billingResult = BillingResult.newBuilder().setResponseCode(responseCode).setDebugMessage(debugMessage).build();
            if (responseCode != 0) {
                BillingHelper.logWarn(TAG, "Unable to launch price change flow, error response code: " + responseCode);
                listener.onPriceChangeConfirmationResult(billingResult);
                return;
            }
            ResultReceiver onPriceChangeConfirmationReceiver = new ResultReceiver(this.mUiThreadHandler){

                public void onReceiveResult(int resultCode, Bundle resultData) {
                    BillingResult billingResult = BillingResult.newBuilder().setResponseCode(resultCode).setDebugMessage(BillingHelper.getDebugMessageFromBundle(resultData, BillingClientImpl.TAG)).build();
                    listener.onPriceChangeConfirmationResult(billingResult);
                }
            };
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            PendingIntent pendingIntent = (PendingIntent)priceChangeIntentBundle.getParcelable("SUBS_MANAGEMENT_INTENT");
            intent.putExtra("SUBS_MANAGEMENT_INTENT", (Parcelable)pendingIntent);
            intent.putExtra("result_receiver", (Parcelable)onPriceChangeConfirmationReceiver);
            activity.startActivity(intent);
        }
        catch (CancellationException | TimeoutException ex) {
            String msg = "Time out while launching Price Change Flow for sku: " + sku + "; try to reconnect";
            BillingHelper.logWarn(TAG, msg);
            listener.onPriceChangeConfirmationResult(BillingResults.SERVICE_TIMEOUT);
        }
        catch (Exception ex) {
            String msg = "Exception caught while launching Price Change Flow for sku: " + sku + "; try to reconnect";
            BillingHelper.logWarn(TAG, msg);
            listener.onPriceChangeConfirmationResult(BillingResults.SERVICE_DISCONNECTED);
        }
    }

    @Override
    public BillingResult launchBillingFlow(Activity activity, final BillingFlowParams params) {
        String msg;
        Future<Bundle> futureBuyIntentBundle;
        boolean isSubscriptionUpdate;
        boolean rewardedSku;
        if (!this.isReady()) {
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.SERVICE_DISCONNECTED);
        }
        final String skuType = params.getSkuType();
        final String newSku = params.getSku();
        SkuDetails skuDetails = params.getSkuDetails();
        boolean bl = rewardedSku = skuDetails != null && skuDetails.isRewarded();
        if (newSku == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. SKU can't be null.");
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.NULL_SKU);
        }
        if (skuType == null) {
            BillingHelper.logWarn(TAG, "Please fix the input params. SkuType can't be null.");
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.NULL_SKU_TYPE);
        }
        if (skuType.equals("subs") && !this.mSubscriptionsSupported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support subscriptions.");
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.SUBSCRIPTIONS_NOT_SUPPORTED);
        }
        boolean bl2 = isSubscriptionUpdate = params.getOldSku() != null;
        if (isSubscriptionUpdate && !this.mSubscriptionUpdateSupported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support subscriptions update.");
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.SUBSCRIPTIONS_UPDATE_NOT_SUPPORTED);
        }
        if (params.hasExtraParams() && !this.mIABv6Supported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support extra params for buy intent.");
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.EXTRA_PARAMS_NOT_SUPPORTED);
        }
        if (rewardedSku && !this.mIABv6Supported) {
            BillingHelper.logWarn(TAG, "Current client doesn't support extra params for buy intent.");
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.EXTRA_PARAMS_NOT_SUPPORTED);
        }
        BillingHelper.logVerbose(TAG, "Constructing buy intent for " + newSku + ", item type: " + skuType);
        if (this.mIABv6Supported) {
            Bundle extraParams = BillingHelper.constructExtraParamsForLaunchBillingFlow(params, this.mIABv9Supported, this.mEnablePendingPurchases, this.mQualifiedVersionNumber);
            if (!skuDetails.getSkuDetailsToken().isEmpty()) {
                extraParams.putString("skuDetailsToken", skuDetails.getSkuDetailsToken());
            }
            if (rewardedSku) {
                extraParams.putString("rewardToken", skuDetails.rewardToken());
                if (this.mChildDirected != 0) {
                    extraParams.putInt("childDirected", this.mChildDirected);
                }
                if (this.mUnderAgeOfConsent != 0) {
                    extraParams.putInt("underAgeOfConsent", this.mUnderAgeOfConsent);
                }
            }
            final Bundle extraParamsFinal = extraParams;
            int apiVersion = 6;
            if (this.mIABv9Supported) {
                apiVersion = 9;
            } else if (params.getVrPurchaseFlow()) {
                apiVersion = 7;
            }
            final int finalApiVersion = apiVersion;
            futureBuyIntentBundle = this.executeAsync(new Callable<Bundle>(){

                @Override
                public Bundle call() throws Exception {
                    return BillingClientImpl.this.mService.getBuyIntentExtraParams(finalApiVersion, BillingClientImpl.this.mApplicationContext.getPackageName(), newSku, skuType, null, extraParamsFinal);
                }
            }, 5000L, null);
        } else {
            futureBuyIntentBundle = isSubscriptionUpdate ? this.executeAsync(new Callable<Bundle>(){

                @Override
                public Bundle call() throws Exception {
                    return BillingClientImpl.this.mService.getBuyIntentToReplaceSkus(5, BillingClientImpl.this.mApplicationContext.getPackageName(), Arrays.asList(params.getOldSku()), newSku, "subs", null);
                }
            }, 5000L, null) : this.executeAsync(new Callable<Bundle>(){

                @Override
                public Bundle call() throws Exception {
                    return BillingClientImpl.this.mService.getBuyIntent(3, BillingClientImpl.this.mApplicationContext.getPackageName(), newSku, skuType, null);
                }
            }, 5000L, null);
        }
        try {
            Bundle buyIntentBundle = futureBuyIntentBundle.get(5000L, TimeUnit.MILLISECONDS);
            int responseCode = BillingHelper.getResponseCodeFromBundle(buyIntentBundle, TAG);
            String debugMessage = BillingHelper.getDebugMessageFromBundle(buyIntentBundle, TAG);
            if (responseCode != 0) {
                BillingHelper.logWarn(TAG, "Unable to buy item, Error response code: " + responseCode);
                BillingResult billingResult = BillingResult.newBuilder().setResponseCode(responseCode).setDebugMessage(debugMessage).build();
                return this.broadcastFailureAndReturnBillingResponse(billingResult);
            }
            Intent intent = new Intent((Context)activity, ProxyBillingActivity.class);
            intent.putExtra("result_receiver", (Parcelable)this.onPurchaseFinishedReceiver);
            PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable("BUY_INTENT");
            intent.putExtra("BUY_INTENT", (Parcelable)pendingIntent);
            activity.startActivity(intent);
        }
        catch (CancellationException | TimeoutException ex) {
            msg = "Time out while launching billing flow: ; for sku: " + newSku + "; try to reconnect";
            BillingHelper.logWarn(TAG, msg);
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.SERVICE_TIMEOUT);
        }
        catch (Exception ex) {
            msg = "Exception while launching billing flow: ; for sku: " + newSku + "; try to reconnect";
            BillingHelper.logWarn(TAG, msg);
            return this.broadcastFailureAndReturnBillingResponse(BillingResults.SERVICE_DISCONNECTED);
        }
        return BillingResults.OK;
    }

    private BillingResult broadcastFailureAndReturnBillingResponse(BillingResult billingResult) {
        this.mBroadcastManager.getListener().onPurchasesUpdated(billingResult, null);
        return billingResult;
    }

    private int launchBillingFlowCpp(Activity activity, BillingFlowParams params) {
        return this.launchBillingFlow(activity, params).getResponseCode();
    }

    @Override
    public Purchase.PurchasesResult queryPurchases(final String skuType) {
        if (!this.isReady()) {
            return new Purchase.PurchasesResult(BillingResults.SERVICE_DISCONNECTED, null);
        }
        if (TextUtils.isEmpty((CharSequence)skuType)) {
            BillingHelper.logWarn(TAG, "Please provide a valid SKU type.");
            return new Purchase.PurchasesResult(BillingResults.EMPTY_SKU_TYPE, null);
        }
        Future<Purchase.PurchasesResult> futurePurchaseResult = this.executeAsync(new Callable<Purchase.PurchasesResult>(){

            @Override
            public Purchase.PurchasesResult call() throws Exception {
                return BillingClientImpl.this.queryPurchasesInternal(skuType);
            }
        }, 5000L, null);
        try {
            return futurePurchaseResult.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException | TimeoutException ex) {
            return new Purchase.PurchasesResult(BillingResults.SERVICE_TIMEOUT, null);
        }
        catch (Exception ex) {
            return new Purchase.PurchasesResult(BillingResults.INTERNAL_ERROR, null);
        }
    }

    private void queryPurchases(final String skuType, long futureHandle) {
        Future<Void> result;
        final BillingClientNativeCallback callback = new BillingClientNativeCallback(futureHandle);
        if (!this.isReady()) {
            callback.onQueryPurchasesResponse(BillingResults.SERVICE_DISCONNECTED, null);
        }
        if ((result = this.executeAsync(new Callable<Void>(){

            @Override
            public Void call() {
                final Purchase.PurchasesResult result = BillingClientImpl.this.queryPurchasesInternal(skuType);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        callback.onQueryPurchasesResponse(result.getBillingResult(), result.getPurchasesList());
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                callback.onQueryPurchasesResponse(BillingResults.SERVICE_TIMEOUT, null);
            }
        })) == null) {
            callback.onQueryPurchasesResponse(this.getBillingResultForNullFutureResult(), null);
        }
    }

    @Override
    public void querySkuDetailsAsync(SkuDetailsParams params, final SkuDetailsResponseListener listener) {
        if (!this.isReady()) {
            listener.onSkuDetailsResponse(BillingResults.SERVICE_DISCONNECTED, null);
            return;
        }
        final String skuType = params.getSkuType();
        final List<String> skusList = params.getSkusList();
        if (TextUtils.isEmpty((CharSequence)skuType)) {
            String msg = "Please fix the input params. SKU type can't be empty.";
            BillingHelper.logWarn(TAG, msg);
            listener.onSkuDetailsResponse(BillingResults.EMPTY_SKU_TYPE, null);
            return;
        }
        if (skusList == null) {
            String msg = "Please fix the input params. The list of SKUs can't be empty.";
            BillingHelper.logWarn(TAG, msg);
            listener.onSkuDetailsResponse(BillingResults.EMPTY_SKU_LIST, null);
            return;
        }
        Future<Void> result = this.executeAsync(new Callable<Void>(){

            @Override
            public Void call() {
                final SkuDetails.SkuDetailsResult result = BillingClientImpl.this.querySkuDetailsInternal(skuType, skusList);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onSkuDetailsResponse(BillingResult.newBuilder().setResponseCode(result.getResponseCode()).setDebugMessage(result.getDebugMessage()).build(), result.getSkuDetailsList());
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                listener.onSkuDetailsResponse(BillingResults.SERVICE_TIMEOUT, null);
            }
        });
        if (result == null) {
            listener.onSkuDetailsResponse(this.getBillingResultForNullFutureResult(), null);
        }
    }

    private void querySkuDetailsAsync(String skuType, String[] skusList, long futureHandle) {
        this.querySkuDetailsAsync(SkuDetailsParams.newBuilder().setType(skuType).setSkusList(Arrays.asList(skusList)).build(), new BillingClientNativeCallback(futureHandle));
    }

    @Override
    public void consumeAsync(final ConsumeParams consumeParams, final ConsumeResponseListener listener) {
        if (!this.isReady()) {
            listener.onConsumeResponse(BillingResults.SERVICE_DISCONNECTED, null);
            return;
        }
        Future<Void> result = this.executeAsync(new Callable<Void>(){

            @Override
            public Void call() {
                BillingClientImpl.this.consumeInternal(consumeParams, listener);
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                listener.onConsumeResponse(BillingResults.SERVICE_TIMEOUT, null);
            }
        });
        if (result == null) {
            listener.onConsumeResponse(this.getBillingResultForNullFutureResult(), null);
        }
    }

    private void consumeAsync(ConsumeParams consumeParams, long futureHandle) {
        this.consumeAsync(consumeParams, new BillingClientNativeCallback(futureHandle));
    }

    @Override
    public void queryPurchaseHistoryAsync(final String skuType, final PurchaseHistoryResponseListener listener) {
        if (!this.isReady()) {
            listener.onPurchaseHistoryResponse(BillingResults.SERVICE_DISCONNECTED, null);
            return;
        }
        Future<Void> result = this.executeAsync(new Callable<Void>(){

            @Override
            public Void call() {
                final PurchaseHistoryResult result = BillingClientImpl.this.queryPurchaseHistoryInternal(skuType);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onPurchaseHistoryResponse(result.getBillingResult(), result.getPurchaseHistoryRecordList());
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                listener.onPurchaseHistoryResponse(BillingResults.SERVICE_TIMEOUT, null);
            }
        });
        if (result == null) {
            listener.onPurchaseHistoryResponse(this.getBillingResultForNullFutureResult(), null);
        }
    }

    private PurchaseHistoryResult queryPurchaseHistoryInternal(String skuType) {
        BillingHelper.logVerbose(TAG, "Querying purchase history, item type: " + skuType);
        String continueToken = null;
        ArrayList<PurchaseHistoryRecord> resultList = new ArrayList<PurchaseHistoryRecord>();
        Bundle extraParams = BillingHelper.constructExtraParamsForQueryPurchases(this.mIABv9Supported, this.mEnablePendingPurchases, this.mQualifiedVersionNumber);
        do {
            Bundle purchasedItems;
            try {
                if (!this.mIABv6Supported) {
                    BillingHelper.logWarn(TAG, "getPurchaseHistory is not supported on current device");
                    return new PurchaseHistoryResult(BillingResults.GET_PURCHASE_HISTORY_NOT_SUPPORTED, null);
                }
                purchasedItems = this.mService.getPurchaseHistory(6, this.mApplicationContext.getPackageName(), skuType, continueToken, extraParams);
            }
            catch (RemoteException e) {
                BillingHelper.logWarn(TAG, "Got exception trying to get purchase history: " + (Object)((Object)e) + "; try to reconnect");
                return new PurchaseHistoryResult(BillingResults.SERVICE_DISCONNECTED, null);
            }
            BillingResult billingResult = PurchaseApiResponseChecker.checkPurchasesBundleValidity(purchasedItems, TAG, "getPurchaseHistory()");
            if (billingResult != BillingResults.OK) {
                return new PurchaseHistoryResult(billingResult, null);
            }
            ArrayList ownedSkus = purchasedItems.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList purchaseDataList = purchasedItems.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList signatureList = purchasedItems.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            for (int i = 0; i < purchaseDataList.size(); ++i) {
                PurchaseHistoryRecord purchaseHistoryRecord;
                String purchaseData = (String)purchaseDataList.get(i);
                String signature = (String)signatureList.get(i);
                String sku = (String)ownedSkus.get(i);
                BillingHelper.logVerbose(TAG, "Purchase record found for sku : " + sku);
                try {
                    purchaseHistoryRecord = new PurchaseHistoryRecord(purchaseData, signature);
                }
                catch (JSONException e) {
                    BillingHelper.logWarn(TAG, "Got an exception trying to decode the purchase: " + (Object)((Object)e));
                    return new PurchaseHistoryResult(BillingResults.INTERNAL_ERROR, null);
                }
                if (TextUtils.isEmpty((CharSequence)purchaseHistoryRecord.getPurchaseToken())) {
                    BillingHelper.logWarn(TAG, "BUG: empty/null token!");
                }
                resultList.add(purchaseHistoryRecord);
            }
            continueToken = purchasedItems.getString("INAPP_CONTINUATION_TOKEN");
            BillingHelper.logVerbose(TAG, "Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return new PurchaseHistoryResult(BillingResults.OK, resultList);
    }

    private void queryPurchaseHistoryAsync(@NonNull String skuType, long futureHandle) {
        this.queryPurchaseHistoryAsync(skuType, new BillingClientNativeCallback(futureHandle));
    }

    @Override
    public void loadRewardedSku(final RewardLoadParams params, final RewardResponseListener listener) {
        if (!this.mIABv6Supported) {
            listener.onRewardResponse(BillingResults.ITEM_UNAVAILABLE);
            return;
        }
        Future<Void> result = this.executeAsync(new Callable<Void>(){

            @Override
            public Void call() {
                Bundle buyIntentBundle;
                Bundle extraParams = BillingHelper.constructExtraParamsForLoadRewardedSku(params.getSkuDetails().rewardToken(), BillingClientImpl.this.mChildDirected, BillingClientImpl.this.mUnderAgeOfConsent, BillingClientImpl.this.mQualifiedVersionNumber);
                try {
                    buyIntentBundle = BillingClientImpl.this.mService.getBuyIntentExtraParams(6, BillingClientImpl.this.mApplicationContext.getPackageName(), params.getSkuDetails().getSku(), params.getSkuDetails().getType(), null, extraParams);
                }
                catch (Exception e) {
                    BillingClientImpl.this.postToUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onRewardResponse(BillingResults.INTERNAL_ERROR);
                        }
                    });
                    return null;
                }
                final BillingResult billingResult = BillingResult.newBuilder().setResponseCode(BillingHelper.getResponseCodeFromBundle(buyIntentBundle, BillingClientImpl.TAG)).setDebugMessage(BillingHelper.getDebugMessageFromBundle(buyIntentBundle, BillingClientImpl.TAG)).build();
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRewardResponse(billingResult);
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                listener.onRewardResponse(BillingResults.SERVICE_TIMEOUT);
            }
        });
        if (result == null) {
            listener.onRewardResponse(this.getBillingResultForNullFutureResult());
        }
    }

    private void loadRewardedSku(RewardLoadParams params, long futureHandle) {
        this.loadRewardedSku(params, new BillingClientNativeCallback(futureHandle));
    }

    @Override
    public void acknowledgePurchase(final AcknowledgePurchaseParams acknowledgePurchaseParams, final AcknowledgePurchaseResponseListener listener) {
        if (!this.isReady()) {
            listener.onAcknowledgePurchaseResponse(BillingResults.SERVICE_DISCONNECTED);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)acknowledgePurchaseParams.getPurchaseToken())) {
            BillingHelper.logWarn(TAG, "Please provide a valid purchase token.");
            listener.onAcknowledgePurchaseResponse(BillingResults.INVALID_PURCHASE_TOKEN);
            return;
        }
        if (!this.mIABv9Supported) {
            listener.onAcknowledgePurchaseResponse(BillingResults.API_VERSION_NOT_V9);
            return;
        }
        Future<Void> futureAcknowledgePurchase = this.executeAsync(new Callable<Void>(){

            @Override
            public Void call() {
                Bundle responseBundle;
                try {
                    responseBundle = BillingClientImpl.this.mService.acknowledgePurchaseExtraParams(9, BillingClientImpl.this.mApplicationContext.getPackageName(), acknowledgePurchaseParams.getPurchaseToken(), BillingHelper.constructExtraParamsForAcknowledgePurchase(acknowledgePurchaseParams, BillingClientImpl.this.mQualifiedVersionNumber));
                }
                catch (Exception e) {
                    BillingClientImpl.this.postToUiThread(new Runnable(){

                        @Override
                        public void run() {
                            BillingHelper.logWarn(BillingClientImpl.TAG, "Error acknowledge purchase; ex: " + e);
                            listener.onAcknowledgePurchaseResponse(BillingResults.SERVICE_DISCONNECTED);
                        }
                    });
                    return null;
                }
                final int responseCode = BillingHelper.getResponseCodeFromBundle(responseBundle, BillingClientImpl.TAG);
                final String debugMessage = BillingHelper.getDebugMessageFromBundle(responseBundle, BillingClientImpl.TAG);
                BillingClientImpl.this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onAcknowledgePurchaseResponse(BillingResult.newBuilder().setResponseCode(responseCode).setDebugMessage(debugMessage).build());
                    }
                });
                return null;
            }
        }, 30000L, new Runnable(){

            @Override
            public void run() {
                listener.onAcknowledgePurchaseResponse(BillingResults.SERVICE_TIMEOUT);
            }
        });
        if (futureAcknowledgePurchase == null) {
            listener.onAcknowledgePurchaseResponse(this.getBillingResultForNullFutureResult());
        }
    }

    private void acknowledgePurchase(AcknowledgePurchaseParams acknowledgePurchaseParams, long futureHandle) {
        this.acknowledgePurchase(acknowledgePurchaseParams, new BillingClientNativeCallback(futureHandle));
    }

    @Nullable
    private <T> Future<T> executeAsync(@NonNull Callable<T> callable, long maxTimeout, final @Nullable Runnable onTimeout) {
        Future<T> task;
        long actualTimeout = (long)(0.95 * (double)maxTimeout);
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newFixedThreadPool(BillingHelper.NUMBER_OF_CORES);
        }
        try {
            task = this.mExecutorService.submit(callable);
        }
        catch (Exception e) {
            BillingHelper.logWarn(TAG, "Async task throws exception " + e);
            return null;
        }
        this.mUiThreadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!task.isDone() && !task.isCancelled()) {
                    task.cancel(true);
                    BillingHelper.logWarn(BillingClientImpl.TAG, "Async task is taking too long, cancel it!");
                    if (onTimeout != null) {
                        onTimeout.run();
                    }
                }
            }
        }, actualTimeout);
        return task;
    }

    private BillingResult isBillingSupportedOnVr(final String skuType) {
        Future<Integer> futureSupportedResult = this.executeAsync(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return BillingClientImpl.this.mService.isBillingSupportedExtraParams(7, BillingClientImpl.this.mApplicationContext.getPackageName(), skuType, BillingClientImpl.this.generateVrBundle());
            }
        }, 5000L, null);
        try {
            int supportedResult = futureSupportedResult.get(5000L, TimeUnit.MILLISECONDS);
            return supportedResult == 0 ? BillingResults.OK : BillingResults.FEATURE_NOT_SUPPORTED;
        }
        catch (Exception e) {
            BillingHelper.logWarn(TAG, "Exception while checking if billing is supported; try to reconnect");
            return BillingResults.SERVICE_DISCONNECTED;
        }
    }

    private Bundle generateVrBundle() {
        Bundle result = new Bundle();
        result.putBoolean("vr", true);
        return result;
    }

    @VisibleForTesting
    SkuDetails.SkuDetailsResult querySkuDetailsInternal(String skuType, List<String> skuList) {
        ArrayList<SkuDetails> resultList = new ArrayList<SkuDetails>();
        int listSize = skuList.size();
        for (int startIndex = 0; startIndex < listSize; startIndex += 20) {
            Bundle skuDetails;
            int endIndex = startIndex + 20;
            if (endIndex > listSize) {
                endIndex = listSize;
            }
            ArrayList<String> curSkuList = new ArrayList<String>(skuList.subList(startIndex, endIndex));
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList(GET_SKU_DETAILS_ITEM_LIST, curSkuList);
            querySkus.putString("playBillingLibraryVersion", this.mQualifiedVersionNumber);
            try {
                skuDetails = this.mIABv10Supported ? this.mService.getSkuDetailsExtraParams(10, this.mApplicationContext.getPackageName(), skuType, querySkus, BillingHelper.constructExtraParamsForGetSkuDetails(this.mIABv9Supported, this.mEnablePendingPurchases, this.mQualifiedVersionNumber)) : this.mService.getSkuDetails(3, this.mApplicationContext.getPackageName(), skuType, querySkus);
            }
            catch (Exception e) {
                String loggedMsg = "querySkuDetailsAsync got a remote exception (try to reconnect).";
                BillingHelper.logWarn(TAG, loggedMsg + e);
                return new SkuDetails.SkuDetailsResult(-1, "Service connection is disconnected.", null);
            }
            if (skuDetails == null) {
                String debugMessage = "querySkuDetailsAsync got null sku details list";
                BillingHelper.logWarn(TAG, debugMessage);
                return new SkuDetails.SkuDetailsResult(4, "Null sku details list", null);
            }
            if (!skuDetails.containsKey("DETAILS_LIST")) {
                String msg;
                int responseCode = BillingHelper.getResponseCodeFromBundle(skuDetails, TAG);
                String debugMessage = BillingHelper.getDebugMessageFromBundle(skuDetails, TAG);
                if (responseCode != 0) {
                    msg = "getSkuDetails() failed. Response code: " + responseCode;
                    BillingHelper.logWarn(TAG, msg);
                    return new SkuDetails.SkuDetailsResult(responseCode, debugMessage, resultList);
                }
                msg = "getSkuDetails() returned a bundle with neither an error nor a detail list.";
                BillingHelper.logWarn(TAG, msg);
                return new SkuDetails.SkuDetailsResult(6, debugMessage, resultList);
            }
            ArrayList skuDetailsJsonList = skuDetails.getStringArrayList("DETAILS_LIST");
            if (skuDetailsJsonList == null) {
                String debugMessage = "querySkuDetailsAsync got null response list";
                BillingHelper.logWarn(TAG, debugMessage);
                return new SkuDetails.SkuDetailsResult(4, debugMessage, null);
            }
            for (int i = 0; i < skuDetailsJsonList.size(); ++i) {
                SkuDetails currentSkuDetails;
                String thisResponse = (String)skuDetailsJsonList.get(i);
                try {
                    currentSkuDetails = new SkuDetails(thisResponse);
                }
                catch (JSONException e) {
                    String msg = "Got a JSON exception trying to decode SkuDetails.";
                    BillingHelper.logWarn(TAG, msg);
                    return new SkuDetails.SkuDetailsResult(6, "Error trying to decode SkuDetails.", null);
                }
                BillingHelper.logVerbose(TAG, "Got sku details: " + currentSkuDetails);
                resultList.add(currentSkuDetails);
            }
        }
        return new SkuDetails.SkuDetailsResult(0, "", resultList);
    }

    private Purchase.PurchasesResult queryPurchasesInternal(String skuType) {
        BillingHelper.logVerbose(TAG, "Querying owned items, item type: " + skuType);
        String continueToken = null;
        ArrayList<Purchase> resultList = new ArrayList<Purchase>();
        Bundle extraParams = BillingHelper.constructExtraParamsForQueryPurchases(this.mIABv9Supported, this.mEnablePendingPurchases, this.mQualifiedVersionNumber);
        do {
            Bundle ownedItems;
            try {
                ownedItems = this.mIABv9Supported ? this.mService.getPurchasesExtraParams(9, this.mApplicationContext.getPackageName(), skuType, continueToken, extraParams) : this.mService.getPurchases(3, this.mApplicationContext.getPackageName(), skuType, continueToken);
            }
            catch (Exception e) {
                BillingHelper.logWarn(TAG, "Got exception trying to get purchases: " + e + "; try to reconnect");
                return new Purchase.PurchasesResult(BillingResults.SERVICE_DISCONNECTED, null);
            }
            BillingResult billingResult = PurchaseApiResponseChecker.checkPurchasesBundleValidity(ownedItems, TAG, "getPurchase()");
            if (billingResult != BillingResults.OK) {
                return new Purchase.PurchasesResult(billingResult, null);
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList purchaseDataList = ownedItems.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList signatureList = ownedItems.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            for (int i = 0; i < purchaseDataList.size(); ++i) {
                Purchase purchase;
                String purchaseData = (String)purchaseDataList.get(i);
                String signature = (String)signatureList.get(i);
                String sku = (String)ownedSkus.get(i);
                BillingHelper.logVerbose(TAG, "Sku is owned: " + sku);
                try {
                    purchase = new Purchase(purchaseData, signature);
                }
                catch (JSONException e) {
                    BillingHelper.logWarn(TAG, "Got an exception trying to decode the purchase: " + (Object)((Object)e));
                    return new Purchase.PurchasesResult(BillingResults.INTERNAL_ERROR, null);
                }
                if (TextUtils.isEmpty((CharSequence)purchase.getPurchaseToken())) {
                    BillingHelper.logWarn(TAG, "BUG: empty/null token!");
                }
                resultList.add(purchase);
            }
            continueToken = ownedItems.getString("INAPP_CONTINUATION_TOKEN");
            BillingHelper.logVerbose(TAG, "Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return new Purchase.PurchasesResult(BillingResults.OK, resultList);
    }

    private void postToUiThread(Runnable runnable) {
        if (Thread.interrupted()) {
            return;
        }
        this.mUiThreadHandler.post(runnable);
    }

    @WorkerThread
    private void consumeInternal(ConsumeParams consumeParams, final ConsumeResponseListener listener) {
        final String purchaseToken = consumeParams.getPurchaseToken();
        try {
            String debugMessage;
            int responseCode;
            BillingHelper.logVerbose(TAG, "Consuming purchase with token: " + purchaseToken);
            if (this.mIABv9Supported) {
                Bundle responseBundle = this.mService.consumePurchaseExtraParams(9, this.mApplicationContext.getPackageName(), purchaseToken, BillingHelper.constructExtraParamsForConsume(consumeParams, this.mIABv9Supported, this.mQualifiedVersionNumber));
                responseCode = responseBundle.getInt("RESPONSE_CODE");
                debugMessage = BillingHelper.getDebugMessageFromBundle(responseBundle, TAG);
            } else {
                responseCode = this.mService.consumePurchase(3, this.mApplicationContext.getPackageName(), purchaseToken);
                debugMessage = "";
            }
            final BillingResult billingResult = BillingResult.newBuilder().setResponseCode(responseCode).setDebugMessage(debugMessage).build();
            if (responseCode == 0) {
                this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BillingHelper.logVerbose(BillingClientImpl.TAG, "Successfully consumed purchase.");
                        listener.onConsumeResponse(billingResult, purchaseToken);
                    }
                });
            } else {
                this.postToUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BillingHelper.logWarn(BillingClientImpl.TAG, "Error consuming purchase with token. Response code: " + responseCode);
                        listener.onConsumeResponse(billingResult, purchaseToken);
                    }
                });
            }
        }
        catch (Exception e) {
            this.postToUiThread(new Runnable(){

                @Override
                public void run() {
                    BillingHelper.logWarn(BillingClientImpl.TAG, "Error consuming purchase; ex: " + e);
                    listener.onConsumeResponse(BillingResults.SERVICE_DISCONNECTED, purchaseToken);
                }
            });
        }
    }

    private BillingResult getBillingResultForNullFutureResult() {
        return this.mClientState == 0 || this.mClientState == 3 ? BillingResults.SERVICE_DISCONNECTED : BillingResults.INTERNAL_ERROR;
    }

    private static class PurchaseHistoryResult {
        private List<PurchaseHistoryRecord> mPurchaseHistoryRecordList;
        private BillingResult mBillingResult;

        PurchaseHistoryResult(BillingResult mBillingResult, List<PurchaseHistoryRecord> purchaseHistoryRecordList) {
            this.mPurchaseHistoryRecordList = purchaseHistoryRecordList;
            this.mBillingResult = mBillingResult;
        }

        BillingResult getBillingResult() {
            return this.mBillingResult;
        }

        List<PurchaseHistoryRecord> getPurchaseHistoryRecordList() {
            return this.mPurchaseHistoryRecordList;
        }
    }

    private final class BillingServiceConnection
    implements ServiceConnection {
        private final Object lock = new Object();
        private boolean disconnected = false;
        private BillingClientStateListener mListener;

        private BillingServiceConnection(BillingClientStateListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            BillingHelper.logWarn(BillingClientImpl.TAG, "Billing service disconnected.");
            BillingClientImpl.this.mService = null;
            BillingClientImpl.this.mClientState = 0;
            Object object = this.lock;
            synchronized (object) {
                if (this.mListener != null) {
                    this.mListener.onBillingServiceDisconnected();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markDisconnectedAndCleanUp() {
            Object object = this.lock;
            synchronized (object) {
                this.mListener = null;
                this.disconnected = true;
            }
        }

        private void notifySetupResult(final BillingResult result) {
            BillingClientImpl.this.postToUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = BillingServiceConnection.this.lock;
                    synchronized (object) {
                        if (BillingServiceConnection.this.mListener != null) {
                            BillingServiceConnection.this.mListener.onBillingSetupFinished(result);
                        }
                    }
                }
            });
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            BillingHelper.logVerbose(BillingClientImpl.TAG, "Billing service connected.");
            BillingClientImpl.this.mService = IInAppBillingService.Stub.asInterface(service);
            Future result = BillingClientImpl.this.executeAsync(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    Object object = BillingServiceConnection.this.lock;
                    synchronized (object) {
                        if (BillingServiceConnection.this.disconnected) {
                            return null;
                        }
                    }
                    int setupResponse = 3;
                    try {
                        String packageName = BillingClientImpl.this.mApplicationContext.getPackageName();
                        int highestLevelSupportedForSubs = 0;
                        for (int apiVersion = 10; apiVersion >= 3; --apiVersion) {
                            setupResponse = BillingClientImpl.this.mService.isBillingSupported(apiVersion, packageName, "subs");
                            if (setupResponse != 0) continue;
                            highestLevelSupportedForSubs = apiVersion;
                            break;
                        }
                        BillingClientImpl.this.mSubscriptionUpdateSupported = highestLevelSupportedForSubs >= 5;
                        BillingClientImpl.this.mSubscriptionsSupported = highestLevelSupportedForSubs >= 3;
                        if (highestLevelSupportedForSubs < 3) {
                            BillingHelper.logVerbose(BillingClientImpl.TAG, "In-app billing API does not support subscription on this device.");
                        }
                        int highestLevelSupportedForInApp = 0;
                        for (int apiVersion = 10; apiVersion >= 3; --apiVersion) {
                            setupResponse = BillingClientImpl.this.mService.isBillingSupported(apiVersion, packageName, "inapp");
                            if (setupResponse != 0) continue;
                            highestLevelSupportedForInApp = apiVersion;
                            break;
                        }
                        BillingClientImpl.this.mIABv10Supported = highestLevelSupportedForInApp >= 10;
                        BillingClientImpl.this.mIABv9Supported = highestLevelSupportedForInApp >= 9;
                        BillingClientImpl.this.mIABv8Supported = highestLevelSupportedForInApp >= 8;
                        BillingClientImpl.this.mIABv6Supported = highestLevelSupportedForInApp >= 6;
                        if (highestLevelSupportedForInApp < 3) {
                            BillingHelper.logWarn(BillingClientImpl.TAG, "In-app billing API version 3 is not supported on this device.");
                        }
                        if (setupResponse == 0) {
                            BillingClientImpl.this.mClientState = 2;
                        } else {
                            BillingClientImpl.this.mClientState = 0;
                            BillingClientImpl.this.mService = null;
                        }
                    }
                    catch (Exception e) {
                        BillingHelper.logWarn(BillingClientImpl.TAG, "Exception while checking if billing is supported; try to reconnect");
                        BillingClientImpl.this.mClientState = 0;
                        BillingClientImpl.this.mService = null;
                    }
                    if (setupResponse == 0) {
                        BillingServiceConnection.this.notifySetupResult(BillingResults.OK);
                    } else {
                        BillingServiceConnection.this.notifySetupResult(BillingResults.API_VERSION_NOT_V3);
                    }
                    return null;
                }
            }, 30000L, new Runnable(){

                @Override
                public void run() {
                    BillingClientImpl.this.mClientState = 0;
                    BillingClientImpl.this.mService = null;
                    BillingServiceConnection.this.notifySetupResult(BillingResults.SERVICE_TIMEOUT);
                }
            });
            if (result == null) {
                this.notifySetupResult(BillingClientImpl.this.getBillingResultForNullFutureResult());
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClientState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
    }
}

