/**
 * Play Billing Library is licensed to you under the Android Software Development Kit License
 * Agreement - https://developer.android.com/studio/terms ("Agreement").  By using the Play Billing
 * Library, you agree to the terms of this Agreement.
 */

package com.android.billingclient.api;

import android.support.annotation.Nullable;
import java.util.List;

/**
 * Listener interface for purchase updates which happen when, for example, the user buys something
 * within the app or by initiating a purchase from Google Play Store.
 */
public interface PurchasesUpdatedListener {
  /**
   * Implement this method to get notifications for purchases updates. Both purchases initiated by
   * your app and the ones initiated outside of your app will be reported here.
   *
   * <p><b>Warning!</b> All purchases reported here must either be consumed or acknowledged. Failure
   * to either consume (via {@link BillingClient#consumeAsync}) or acknowledge (via {@link
   * BillingClient#acknowledgePurchase}) a purchase will result in that purchase being refunded.
   * Please refer to
   * https://developer.android.com/google/play/billing/billing_library_overview#acknowledge for more
   * details.
   *
   * @param billingResult BillingResult of the update.
   * @param purchases List of updated purchases if present.
   */
  void onPurchasesUpdated(BillingResult billingResult, @Nullable List<Purchase> purchases);
}
