/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.util;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.android.billingclient.api.Purchase;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public final class BillingHelper {
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String RESPONSE_GET_SKU_DETAILS_LIST = "DETAILS_LIST";
    public static final String RESPONSE_BUY_INTENT_KEY = "BUY_INTENT";
    public static final String RESPONSE_SUBS_MANAGEMENT_INTENT_KEY = "SUBS_MANAGEMENT_INTENT";
    public static final String RESPONSE_INAPP_ITEM_LIST = "INAPP_PURCHASE_ITEM_LIST";
    public static final String RESPONSE_INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    public static final String RESPONSE_INAPP_SIGNATURE_LIST = "INAPP_DATA_SIGNATURE_LIST";
    public static final String INAPP_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    private static final String TAG = "BillingHelper";
    private static final String RESPONSE_INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    private static final String RESPONSE_INAPP_SIGNATURE = "INAPP_DATA_SIGNATURE";
    public static final String LIBRARY_VERSION_KEY = "libraryVersion";
    public static final String EXTRA_PARAM_KEY_SUBS_PRICE_CHANGE = "subs_price_change";
    public static int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();

    public static void logVerbose(String tag, String msg) {
        if (Log.isLoggable((String)tag, (int)2)) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void logWarn(String tag, String msg) {
        if (Log.isLoggable((String)tag, (int)5)) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static int getResponseCodeFromIntent(Intent intent, String tag) {
        if (intent == null) {
            BillingHelper.logWarn(TAG, "Got null intent!");
            return 6;
        }
        return BillingHelper.getResponseCodeFromBundle(intent.getExtras(), tag);
    }

    public static int getResponseCodeFromBundle(Bundle bundle, String tag) {
        if (bundle == null) {
            BillingHelper.logWarn(tag, "Unexpected null bundle received!");
            return 6;
        }
        Object responseCode = bundle.get(RESPONSE_CODE);
        if (responseCode == null) {
            BillingHelper.logVerbose(tag, "getResponseCodeFromBundle() got null response code, assuming OK");
            return 0;
        }
        if (responseCode instanceof Integer) {
            return (Integer)responseCode;
        }
        BillingHelper.logWarn(tag, "Unexpected type for bundle response code: " + responseCode.getClass().getName());
        return 6;
    }

    public static List<Purchase> extractPurchases(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        ArrayList purchaseDataList = bundle.getStringArrayList(RESPONSE_INAPP_PURCHASE_DATA_LIST);
        ArrayList dataSignatureList = bundle.getStringArrayList(RESPONSE_INAPP_SIGNATURE_LIST);
        ArrayList<Purchase> resultList = new ArrayList<Purchase>();
        if (purchaseDataList == null || dataSignatureList == null) {
            BillingHelper.logWarn(TAG, "Couldn't find purchase lists, trying to find single data.");
            String purchaseData = bundle.getString(RESPONSE_INAPP_PURCHASE_DATA);
            String dataSignature = bundle.getString(RESPONSE_INAPP_SIGNATURE);
            Purchase tmpPurchase = BillingHelper.extractPurchase(purchaseData, dataSignature);
            if (tmpPurchase == null) {
                BillingHelper.logWarn(TAG, "Couldn't find single purchase data as well.");
                return null;
            }
            resultList.add(tmpPurchase);
        } else {
            for (int i = 0; i < purchaseDataList.size() && i < dataSignatureList.size(); ++i) {
                Purchase tmpPurchase = BillingHelper.extractPurchase((String)purchaseDataList.get(i), (String)dataSignatureList.get(i));
                if (tmpPurchase == null) continue;
                resultList.add(tmpPurchase);
            }
        }
        return resultList;
    }

    private static Purchase extractPurchase(String purchaseData, String signatureData) {
        if (purchaseData == null || signatureData == null) {
            BillingHelper.logWarn(TAG, "Received a bad purchase data.");
            return null;
        }
        Purchase purchase = null;
        try {
            purchase = new Purchase(purchaseData, signatureData);
        }
        catch (JSONException e) {
            BillingHelper.logWarn(TAG, "Got JSONException while parsing purchase data: " + (Object)((Object)e));
        }
        return purchase;
    }
}

