/*
 * Decompiled with CFR 0.152.
 */
package com.android.actionsheetdialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import com.android.actionsheetdialog.R;
import java.util.ArrayList;
import java.util.List;

public class ActionSheetDialog
extends AlertDialog {
    protected ActionSheetDialog(Context context) {
        super(context);
    }

    protected ActionSheetDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    protected ActionSheetDialog(Context context, @StyleRes int themeResId) {
        super(context, themeResId);
    }

    public static class Builder
    extends AlertDialog.Builder {
        Context mContext;
        String mTitle;
        String mMessage;
        String mNegativeText;
        String mPositiveText;
        boolean mCancelable;
        List<ActionSheetItem> mActionSheetItems;
        DialogInterface.OnClickListener mNegativeClickListener;
        DialogInterface.OnClickListener mPositiveClickListener;

        public Builder(Context context) {
            super(context);
            this.mContext = context;
            this.mActionSheetItems = new ArrayList<ActionSheetItem>();
        }

        public AlertDialog.Builder setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
            return this;
        }

        public AlertDialog.Builder setMessage(CharSequence message) {
            this.mMessage = (String)message;
            return this;
        }

        public AlertDialog.Builder setMessage(@StringRes int messageId) {
            this.mMessage = this.mContext.getString(messageId);
            return this;
        }

        public AlertDialog.Builder setTitle(CharSequence title) {
            this.mTitle = (String)title;
            return this;
        }

        public AlertDialog.Builder setTitle(@StringRes int titleId) {
            this.mTitle = this.mContext.getString(titleId);
            return this;
        }

        public AlertDialog.Builder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mNegativeText = (String)text;
            this.mNegativeClickListener = listener;
            return this;
        }

        public AlertDialog.Builder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mNegativeText = (String)text;
            this.mNegativeClickListener = listener;
            return this;
        }

        public AlertDialog.Builder addActionSheetItem(CharSequence text, int textColor, ActionSheetItemClickListener listener) {
            if (null != text && !TextUtils.isEmpty((CharSequence)text)) {
                ActionSheetItem actionSheetItem = new ActionSheetItem(textColor, (String)text, listener);
                this.mActionSheetItems.add(actionSheetItem);
            }
            return this;
        }

        public AlertDialog create() {
            View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_action_sheet_dialog, null);
            ActionSheetDialog dialog = new ActionSheetDialog(this.mContext);
            dialog.setCancelable(this.mCancelable);
            if (this.mCancelable) {
                dialog.setCanceledOnTouchOutside(true);
            }
            return dialog;
        }

        public static interface ActionSheetItemClickListener {
            public void onClick(int var1);
        }

        static class ActionSheetItem {
            int textColor;
            String text;
            ActionSheetItemClickListener listener;

            public ActionSheetItem(int textColor, String text, ActionSheetItemClickListener listener) {
                this.textColor = textColor;
                this.text = text;
                this.listener = listener;
            }
        }
    }
}

