/*
 * Decompiled with CFR 0.152.
 */
package com.andreabaccega.widget;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import com.andreabaccega.formedittextvalidator.Validator;
import com.andreabaccega.widget.DefaultEditTextValidator;
import com.andreabaccega.widget.EditTextValidator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FormAutoCompleteTextView
extends AutoCompleteTextView {
    private EditTextValidator editTextValidator;
    private Drawable lastErrorIcon = null;

    public FormAutoCompleteTextView(Context context) {
        super(context);
        throw new RuntimeException("Not supported");
    }

    public FormAutoCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.editTextValidator = new DefaultEditTextValidator((EditText)this, attrs, context);
    }

    public FormAutoCompleteTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.editTextValidator = new DefaultEditTextValidator((EditText)this, attrs, context);
    }

    public void addValidator(Validator theValidator) throws IllegalArgumentException {
        this.editTextValidator.addValidator(theValidator);
    }

    public EditTextValidator getEditTextValidator() {
        return this.editTextValidator;
    }

    public void setEditTextValidator(EditTextValidator editTextValidator) {
        this.editTextValidator = editTextValidator;
    }

    public boolean testValidity() {
        return this.editTextValidator.testValidity();
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        if (TextUtils.isEmpty((CharSequence)this.getText().toString()) && keyCode == 67) {
            return true;
        }
        return super.onKeyPreIme(keyCode, event);
    }

    public void setError(CharSequence error, Drawable icon) {
        super.setError(error, icon);
        this.lastErrorIcon = icon;
        if (error != null) {
            this.showErrorIconHax(icon);
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        this.showErrorIconHax(this.lastErrorIcon);
    }

    private void showErrorIconHax(Drawable icon) {
        if (icon == null) {
            return;
        }
        if (Build.VERSION.SDK_INT != 16 && Build.VERSION.SDK_INT != 17) {
            return;
        }
        try {
            Class<?> textview = Class.forName("android.widget.TextView");
            Field tEditor = textview.getDeclaredField("mEditor");
            tEditor.setAccessible(true);
            Class<?> editor = Class.forName("android.widget.Editor");
            Method privateShowError = editor.getDeclaredMethod("setErrorIcon", Drawable.class);
            privateShowError.setAccessible(true);
            privateShowError.invoke(tEditor.get((Object)this), icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

