/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.essentials.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.ancient.essentials.utils.CryptoPreference;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bJ\u0016\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0001R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/ancient/essentials/utils/SecuredPreferenceManager;", "", "()V", "sharedPreferences", "Landroid/content/SharedPreferences;", "clearValue", "", "aPrefKey", "", "getBooleanValue", "", "aKey", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getFloatValue", "", "(Ljava/lang/String;)Ljava/lang/Float;", "getIntValue", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getLongValue", "", "(Ljava/lang/String;)Ljava/lang/Long;", "getStringSetValue", "", "getStringValue", "initialize", "aContext", "Landroid/content/Context;", "aPrefName", "storeValue", "aValue", "android-essentials_release"})
public final class SecuredPreferenceManager {
    private static SharedPreferences sharedPreferences;
    public static final SecuredPreferenceManager INSTANCE;

    public final void initialize(@NotNull Context aContext, @NotNull String aPrefName) {
        Intrinsics.checkParameterIsNotNull((Object)aContext, (String)"aContext");
        Intrinsics.checkParameterIsNotNull((Object)aPrefName, (String)"aPrefName");
        sharedPreferences = Build.VERSION.SDK_INT >= 23 ? CryptoPreference.INSTANCE.initialize(aContext, aPrefName) : aContext.getSharedPreferences(aPrefName, 0);
    }

    @Nullable
    public final String getStringValue(@NotNull String aKey) {
        Intrinsics.checkParameterIsNotNull((Object)aKey, (String)"aKey");
        if (sharedPreferences == null) {
            throw (Throwable)new Exception("Should call this method before initialize preference");
        }
        SharedPreferences sharedPreferences = SecuredPreferenceManager.sharedPreferences;
        return sharedPreferences != null ? sharedPreferences.getString(aKey, null) : null;
    }

    @Nullable
    public final Float getFloatValue(@NotNull String aKey) {
        Intrinsics.checkParameterIsNotNull((Object)aKey, (String)"aKey");
        if (sharedPreferences == null) {
            throw (Throwable)new Exception("Should call this method before initialize preference");
        }
        SharedPreferences sharedPreferences = SecuredPreferenceManager.sharedPreferences;
        return sharedPreferences != null ? Float.valueOf(sharedPreferences.getFloat(aKey, 0.0f)) : null;
    }

    @Nullable
    public final Boolean getBooleanValue(@NotNull String aKey) {
        Intrinsics.checkParameterIsNotNull((Object)aKey, (String)"aKey");
        if (sharedPreferences == null) {
            throw (Throwable)new Exception("Should call this method before initialize preference");
        }
        SharedPreferences sharedPreferences = SecuredPreferenceManager.sharedPreferences;
        return sharedPreferences != null ? Boolean.valueOf(sharedPreferences.getBoolean(aKey, false)) : null;
    }

    @Nullable
    public final Integer getIntValue(@NotNull String aKey) {
        Intrinsics.checkParameterIsNotNull((Object)aKey, (String)"aKey");
        if (sharedPreferences == null) {
            throw (Throwable)new Exception("Should call this method before initialize preference");
        }
        SharedPreferences sharedPreferences = SecuredPreferenceManager.sharedPreferences;
        return sharedPreferences != null ? Integer.valueOf(sharedPreferences.getInt(aKey, 0)) : null;
    }

    @Nullable
    public final Long getLongValue(@NotNull String aKey) {
        Intrinsics.checkParameterIsNotNull((Object)aKey, (String)"aKey");
        if (sharedPreferences == null) {
            throw (Throwable)new Exception("Should call this method before initialize preference");
        }
        SharedPreferences sharedPreferences = SecuredPreferenceManager.sharedPreferences;
        return sharedPreferences != null ? Long.valueOf(sharedPreferences.getLong(aKey, 0L)) : null;
    }

    @Nullable
    public final Set<String> getStringSetValue(@NotNull String aKey) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)aKey, (String)"aKey");
        if (sharedPreferences == null) {
            throw (Throwable)new Exception("Should call this method before initialize preference");
        }
        SharedPreferences sharedPreferences = SecuredPreferenceManager.sharedPreferences;
        if (sharedPreferences != null) {
            String string2 = aKey;
            SharedPreferences sharedPreferences2 = sharedPreferences;
            boolean bl = false;
            Set set2 = new LinkedHashSet();
            set = sharedPreferences2.getStringSet(string2, set2);
        } else {
            set = null;
        }
        return set;
    }

    public final void storeValue(@NotNull String aKey, @NotNull Object aValue) {
        Intrinsics.checkParameterIsNotNull((Object)aKey, (String)"aKey");
        Intrinsics.checkParameterIsNotNull((Object)aValue, (String)"aValue");
        if (sharedPreferences == null) {
            throw (Throwable)new Exception("Should call this method before initialize preference");
        }
        SharedPreferences sharedPreferences = SecuredPreferenceManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwNpe();
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Object object = aValue;
        if (object instanceof Boolean) {
            editor.putBoolean(aKey, ((Boolean)aValue).booleanValue());
        } else if (object instanceof String) {
            editor.putString(aKey, (String)aValue);
        } else if (object instanceof Integer) {
            editor.putInt(aKey, ((Number)aValue).intValue());
        } else if (object instanceof Long) {
            editor.putLong(aKey, ((Number)aValue).longValue());
        } else if (object instanceof Float) {
            editor.putFloat(aKey, ((Number)aValue).floatValue());
        } else if (TypeIntrinsics.isMutableSet((Object)object)) {
            editor.putStringSet(aKey, TypeIntrinsics.asMutableSet((Object)aValue));
        } else {
            throw (Throwable)new Exception("Input valid value to store");
        }
        editor.apply();
    }

    public final void clearValue(@NotNull String aPrefKey) {
        Intrinsics.checkParameterIsNotNull((Object)aPrefKey, (String)"aPrefKey");
        SharedPreferences sharedPreferences = SecuredPreferenceManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwNpe();
        }
        sharedPreferences.edit().remove(aPrefKey).apply();
    }

    private SecuredPreferenceManager() {
    }

    static {
        SecuredPreferenceManager securedPreferenceManager;
        INSTANCE = securedPreferenceManager = new SecuredPreferenceManager();
    }
}

