/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.essentials.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import androidx.preference.PreferenceManager;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0003J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ancient/essentials/utils/LocaleHelper;", "", "()V", "SELECTED_LANGUAGE", "", "getLanguage", "context", "Landroid/content/Context;", "getPersistedData", "defaultLanguage", "onAttach", "persist", "", "language", "setLocale", "updateResources", "updateResourcesLegacy", "android-essentials_release"})
public final class LocaleHelper {
    private static final String SELECTED_LANGUAGE = "Locale.Helper.Selected.Language";
    public static final LocaleHelper INSTANCE;

    @Nullable
    public final Context onAttach(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        String string2 = locale.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().language");
        String lang = this.getPersistedData(context, string2);
        return this.setLocale(context, lang);
    }

    @Nullable
    public final Context onAttach(@NotNull Context context, @NotNull String defaultLanguage) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)defaultLanguage, (String)"defaultLanguage");
        String lang = this.getPersistedData(context, defaultLanguage);
        return this.setLocale(context, lang);
    }

    @Nullable
    public final String getLanguage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        String string2 = locale.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().language");
        return this.getPersistedData(context, string2);
    }

    @Nullable
    public final Context setLocale(@NotNull Context context, @Nullable String language) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.persist(context, language);
        return Build.VERSION.SDK_INT >= 24 ? this.updateResources(context, language) : this.updateResourcesLegacy(context, language);
    }

    private final String getPersistedData(Context context, String defaultLanguage) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"PreferenceManager.getDef\u2026haredPreferences(context)");
        SharedPreferences preferences = sharedPreferences;
        return preferences.getString(SELECTED_LANGUAGE, defaultLanguage);
    }

    private final void persist(Context context, String language) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"PreferenceManager.getDef\u2026haredPreferences(context)");
        SharedPreferences preferences = sharedPreferences;
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(SELECTED_LANGUAGE, language);
        editor.apply();
    }

    @TargetApi(value=24)
    private final Context updateResources(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Configuration configuration = resources.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"context.resources.configuration");
        Configuration configuration2 = configuration;
        configuration2.setLocale(locale);
        configuration2.setLayoutDirection(locale);
        return context.createConfigurationContext(configuration2);
    }

    private final Context updateResourcesLegacy(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Resources resources2 = resources;
        Configuration configuration = resources2.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"resources.configuration");
        Configuration configuration2 = configuration;
        configuration2.locale = locale;
        configuration2.setLayoutDirection(locale);
        resources2.updateConfiguration(configuration2, resources2.getDisplayMetrics());
        return context;
    }

    private LocaleHelper() {
    }

    static {
        LocaleHelper localeHelper;
        INSTANCE = localeHelper = new LocaleHelper();
    }
}

