/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.essentials.utils;

import android.app.Application;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ancient/essentials/utils/Logger;", "", "()V", "DEBUG", "", "TAG", "", "init", "", "aApplication", "Landroid/app/Application;", "isDebug", "printDebug", "aDebug", "printError", "aException", "", "printInfo", "aInformation", "aTag", "printVerbose", "aVerbose", "printWarning", "aWarning", "android-essentials_release"})
public final class Logger {
    private static boolean DEBUG;
    private static String TAG;
    public static final Logger INSTANCE;

    public final void init(@NotNull Application aApplication, boolean isDebug) {
        Intrinsics.checkParameterIsNotNull((Object)aApplication, (String)"aApplication");
        DEBUG = isDebug;
        String string2 = aApplication.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"aApplication.packageName");
        TAG = string2;
    }

    public final void printError(@Nullable Throwable aException) {
        if (DEBUG && aException != null) {
            CharSequence charSequence = aException.getLocalizedMessage();
            String string2 = TAG;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
            Log.e((String)string2, (String)(bl3 ? "Unknown exception" : aException.getLocalizedMessage()));
        }
    }

    public final void printInfo(@NotNull String aInformation) {
        Intrinsics.checkParameterIsNotNull((Object)aInformation, (String)"aInformation");
        if (DEBUG) {
            Log.i((String)TAG, (String)aInformation);
        }
    }

    public final void printInfo(@NotNull String aTag, @NotNull String aInformation) {
        Intrinsics.checkParameterIsNotNull((Object)aTag, (String)"aTag");
        Intrinsics.checkParameterIsNotNull((Object)aInformation, (String)"aInformation");
        if (DEBUG) {
            Log.i((String)aTag, (String)aInformation);
        }
    }

    public final void printWarning(@NotNull String aWarning) {
        Intrinsics.checkParameterIsNotNull((Object)aWarning, (String)"aWarning");
        if (DEBUG) {
            Log.w((String)TAG, (String)aWarning);
        }
    }

    public final void printVerbose(@NotNull String aVerbose) {
        Intrinsics.checkParameterIsNotNull((Object)aVerbose, (String)"aVerbose");
        if (DEBUG) {
            Log.v((String)TAG, (String)aVerbose);
        }
    }

    public final void printDebug(@NotNull String aDebug) {
        Intrinsics.checkParameterIsNotNull((Object)aDebug, (String)"aDebug");
        if (DEBUG) {
            Log.d((String)TAG, (String)aDebug);
        }
    }

    private Logger() {
    }

    static {
        Logger logger;
        INSTANCE = logger = new Logger();
        TAG = "Android Essentials";
    }
}

