/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.amplitude.api.AmplitudeClient;
import com.amplitude.api.AmplitudeLog;

class AmplitudeCallbacks
implements Application.ActivityLifecycleCallbacks {
    public static final String TAG = "com.amplitude.api.AmplitudeCallbacks";
    private static final String NULLMSG = "Need to initialize AmplitudeCallbacks with AmplitudeClient instance";
    private AmplitudeClient clientInstance = null;
    private static AmplitudeLog logger = AmplitudeLog.getLogger();

    public AmplitudeCallbacks(AmplitudeClient clientInstance) {
        if (clientInstance == null) {
            logger.e(TAG, NULLMSG);
            return;
        }
        this.clientInstance = clientInstance;
        clientInstance.useForegroundTracking();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        if (this.clientInstance == null) {
            logger.e(TAG, NULLMSG);
            return;
        }
        this.clientInstance.onExitForeground(this.getCurrentTimeMillis());
    }

    public void onActivityResumed(Activity activity) {
        if (this.clientInstance == null) {
            logger.e(TAG, NULLMSG);
            return;
        }
        this.clientInstance.onEnterForeground(this.getCurrentTimeMillis());
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outstate) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

