/*
 * Decompiled with CFR 0.152.
 */
package com.amirarcane.lockscreen.activity;

import android.animation.ObjectAnimator;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.security.keystore.KeyGenParameterSpec;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatImageView;
import android.util.Log;
import android.widget.TextView;
import android.widget.Toast;
import com.amirarcane.lockscreen.R;
import com.amirarcane.lockscreen.andrognito.pinlockview.IndicatorDots;
import com.amirarcane.lockscreen.andrognito.pinlockview.PinLockListener;
import com.amirarcane.lockscreen.andrognito.pinlockview.PinLockView;
import com.amirarcane.lockscreen.fingerprint.FingerPrintListener;
import com.amirarcane.lockscreen.fingerprint.FingerprintHandler;
import com.amirarcane.lockscreen.util.Animate;
import com.amirarcane.lockscreen.util.Utils;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class EnterPinActivity
extends AppCompatActivity {
    public static final String TAG = "EnterPinActivity";
    public static final int RESULT_BACK_PRESSED = 1;
    public static final String EXTRA_SET_PIN = "set_pin";
    public static final String EXTRA_FONT_TEXT = "textFont";
    public static final String EXTRA_FONT_NUM = "numFont";
    private static final int PIN_LENGTH = 4;
    private static final String FINGER_PRINT_KEY = "FingerPrintKey";
    private static final String PREFERENCES = "com.amirarcane.lockscreen";
    private static final String KEY_PIN = "pin";
    private PinLockView mPinLockView;
    private IndicatorDots mIndicatorDots;
    private TextView mTextTitle;
    private TextView mTextAttempts;
    private TextView mTextFingerText;
    private AppCompatImageView mImageViewFingerView;
    private Cipher mCipher;
    private KeyStore mKeyStore;
    private KeyGenerator mKeyGenerator;
    private FingerprintManager.CryptoObject mCryptoObject;
    private FingerprintManager mFingerprintManager;
    private KeyguardManager mKeyguardManager;
    private boolean mSetPin = false;
    private String mFirstPin = "";
    private AnimatedVectorDrawable showFingerprint;
    private AnimatedVectorDrawable fingerprintToTick;
    private AnimatedVectorDrawable fingerprintToCross;

    public static Intent getIntent(Context context, boolean setPin) {
        Intent intent = new Intent(context, EnterPinActivity.class);
        intent.putExtra(EXTRA_SET_PIN, setPin);
        return intent;
    }

    public static Intent getIntent(Context context, String fontText, String fontNum) {
        Intent intent = new Intent(context, EnterPinActivity.class);
        intent.putExtra(EXTRA_FONT_TEXT, fontText);
        intent.putExtra(EXTRA_FONT_NUM, fontNum);
        return intent;
    }

    public static Intent getIntent(Context context, boolean setPin, String fontText, String fontNum) {
        Intent intent = EnterPinActivity.getIntent(context, fontText, fontNum);
        intent.putExtra(EXTRA_SET_PIN, setPin);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.activity_enterpin);
        this.mTextAttempts = (TextView)this.findViewById(R.id.attempts);
        this.mTextTitle = (TextView)this.findViewById(R.id.title);
        this.mIndicatorDots = (IndicatorDots)this.findViewById(R.id.indicator_dots);
        this.mImageViewFingerView = (AppCompatImageView)this.findViewById(R.id.fingerView);
        this.mTextFingerText = (TextView)this.findViewById(R.id.fingerText);
        if (Build.VERSION.SDK_INT >= 23) {
            this.showFingerprint = (AnimatedVectorDrawable)this.getDrawable(R.drawable.show_fingerprint);
            this.fingerprintToTick = (AnimatedVectorDrawable)this.getDrawable(R.drawable.fingerprint_to_tick);
            this.fingerprintToCross = (AnimatedVectorDrawable)this.getDrawable(R.drawable.fingerprint_to_cross);
        }
        this.mSetPin = this.getIntent().getBooleanExtra(EXTRA_SET_PIN, false);
        if (this.mSetPin) {
            this.changeLayoutForSetPin();
        } else {
            String pin = this.getPinFromSharedPreferences();
            if (pin.equals("")) {
                this.changeLayoutForSetPin();
                this.mSetPin = true;
            } else {
                this.checkForFingerPrint();
            }
        }
        PinLockListener pinLockListener = new PinLockListener(){

            @Override
            public void onComplete(String pin) {
                if (EnterPinActivity.this.mSetPin) {
                    EnterPinActivity.this.setPin(pin);
                } else {
                    EnterPinActivity.this.checkPin(pin);
                }
            }

            @Override
            public void onEmpty() {
                Log.d((String)EnterPinActivity.TAG, (String)"Pin empty");
            }

            @Override
            public void onPinChange(int pinLength, String intermediatePin) {
                Log.d((String)EnterPinActivity.TAG, (String)("Pin changed, new length " + pinLength + " with intermediate pin " + intermediatePin));
            }
        };
        this.mPinLockView = (PinLockView)this.findViewById(R.id.pinlockView);
        this.mIndicatorDots = (IndicatorDots)this.findViewById(R.id.indicator_dots);
        this.mPinLockView.attachIndicatorDots(this.mIndicatorDots);
        this.mPinLockView.setPinLockListener(pinLockListener);
        this.mPinLockView.setPinLength(4);
        this.mIndicatorDots.setIndicatorType(2);
        this.checkForFont();
    }

    private void checkForFont() {
        String font;
        Intent intent = this.getIntent();
        if (intent.hasExtra(EXTRA_FONT_TEXT)) {
            font = intent.getStringExtra(EXTRA_FONT_TEXT);
            this.setTextFont(font);
        }
        if (intent.hasExtra(EXTRA_FONT_NUM)) {
            font = intent.getStringExtra(EXTRA_FONT_NUM);
            this.setNumFont(font);
        }
    }

    private void setTextFont(String font) {
        try {
            Typeface typeface = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)font);
            this.mTextTitle.setTypeface(typeface);
            this.mTextAttempts.setTypeface(typeface);
            this.mTextFingerText.setTypeface(typeface);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setNumFont(String font) {
        try {
            Typeface typeface = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)font);
            this.mPinLockView.setTypeFace(typeface);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateKey() throws FingerprintException {
        try {
            this.mKeyStore = KeyStore.getInstance("AndroidKeyStore");
            this.mKeyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            this.mKeyStore.load(null);
            if (Build.VERSION.SDK_INT >= 23) {
                this.mKeyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(FINGER_PRINT_KEY, 3).setBlockModes(new String[]{"CBC"}).setUserAuthenticationRequired(true).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build());
            }
            this.mKeyGenerator.generateKey();
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException exc) {
            throw new FingerprintException(exc);
        }
    }

    public boolean initCipher() {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mCipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            }
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            Log.e((String)TAG, (String)"Failed to get Cipher");
            return false;
        }
        try {
            this.mKeyStore.load(null);
            SecretKey key = (SecretKey)this.mKeyStore.getKey(FINGER_PRINT_KEY, null);
            this.mCipher.init(1, key);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to init Cipher");
            return false;
        }
    }

    private void writePinToSharedPreferences(String pin) {
        SharedPreferences prefs = this.getSharedPreferences(PREFERENCES, 0);
        prefs.edit().putString(KEY_PIN, Utils.sha256(pin)).apply();
    }

    private String getPinFromSharedPreferences() {
        SharedPreferences prefs = this.getSharedPreferences(PREFERENCES, 0);
        return prefs.getString(KEY_PIN, "");
    }

    private void setPin(String pin) {
        if (this.mFirstPin.equals("")) {
            this.mFirstPin = pin;
            this.mTextTitle.setText((CharSequence)this.getString(R.string.pinlock_secondPin));
            this.mPinLockView.resetPinLockView();
        } else if (pin.equals(this.mFirstPin)) {
            this.writePinToSharedPreferences(pin);
            this.setResult(-1);
            this.finish();
        } else {
            this.shake();
            this.mTextTitle.setText((CharSequence)this.getString(R.string.pinlock_tryagain));
            this.mPinLockView.resetPinLockView();
            this.mFirstPin = "";
        }
    }

    private void checkPin(String pin) {
        if (Utils.sha256(pin).equals(this.getPinFromSharedPreferences())) {
            this.setResult(-1);
            this.finish();
        } else {
            this.shake();
            this.mTextAttempts.setText((CharSequence)this.getString(R.string.pinlock_wrongpin));
            this.mPinLockView.resetPinLockView();
        }
    }

    private void shake() {
        new ObjectAnimator();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mPinLockView), (String)"translationX", (float[])new float[]{0.0f, 25.0f, -25.0f, 25.0f, -25.0f, 15.0f, -15.0f, 6.0f, -6.0f, 0.0f}).setDuration(1000L);
        objectAnimator.start();
    }

    private void changeLayoutForSetPin() {
        this.mImageViewFingerView.setVisibility(8);
        this.mTextFingerText.setVisibility(8);
        this.mTextAttempts.setVisibility(8);
        this.mTextTitle.setText((CharSequence)this.getString(R.string.pinlock_settitle));
    }

    private void checkForFingerPrint() {
        FingerPrintListener fingerPrintListener = new FingerPrintListener(){

            @Override
            public void onSuccess() {
                EnterPinActivity.this.setResult(-1);
                Animate.animate(EnterPinActivity.this.mImageViewFingerView, EnterPinActivity.this.fingerprintToTick);
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        EnterPinActivity.this.finish();
                    }
                }, 750L);
            }

            @Override
            public void onFailed() {
                Animate.animate(EnterPinActivity.this.mImageViewFingerView, EnterPinActivity.this.fingerprintToCross);
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Animate.animate(EnterPinActivity.this.mImageViewFingerView, EnterPinActivity.this.showFingerprint);
                    }
                }, 750L);
            }

            @Override
            public void onError(CharSequence errorString) {
                Toast.makeText((Context)EnterPinActivity.this, (CharSequence)errorString, (int)0).show();
            }

            @Override
            public void onHelp(CharSequence helpString) {
                Toast.makeText((Context)EnterPinActivity.this, (CharSequence)helpString, (int)0).show();
            }
        };
        if (Build.VERSION.SDK_INT >= 23) {
            FingerprintManager fingerprintManager = (FingerprintManager)this.getSystemService("fingerprint");
            if (fingerprintManager.isHardwareDetected()) {
                this.mKeyguardManager = (KeyguardManager)this.getSystemService("keyguard");
                this.mFingerprintManager = (FingerprintManager)this.getSystemService("fingerprint");
                if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.USE_FINGERPRINT") != 0) {
                    this.mImageViewFingerView.setVisibility(8);
                    return;
                }
                if (!this.mFingerprintManager.hasEnrolledFingerprints()) {
                    this.mImageViewFingerView.setVisibility(8);
                    return;
                }
                if (!this.mKeyguardManager.isKeyguardSecure()) {
                    this.mImageViewFingerView.setVisibility(8);
                    return;
                }
                try {
                    this.generateKey();
                    if (this.initCipher()) {
                        this.mCryptoObject = new FingerprintManager.CryptoObject(this.mCipher);
                        FingerprintHandler helper = new FingerprintHandler((Context)this);
                        helper.startAuth(this.mFingerprintManager, this.mCryptoObject);
                        helper.setFingerPrintListener(fingerPrintListener);
                    }
                }
                catch (FingerprintException e) {
                    Log.wtf((String)TAG, (String)"Failed to generate key for fingerprint.", (Throwable)e);
                }
            } else {
                this.mImageViewFingerView.setVisibility(8);
            }
        } else {
            this.mImageViewFingerView.setVisibility(8);
        }
    }

    public void onBackPressed() {
        this.setResult(1);
        super.onBackPressed();
    }

    private class FingerprintException
    extends Exception {
        public FingerprintException(Exception e) {
            super(e);
        }
    }
}

