/*
 * Decompiled with CFR 0.152.
 */
package com.amirarcane.lockscreen.andrognito.pinlockview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import com.amirarcane.lockscreen.R;
import com.amirarcane.lockscreen.andrognito.pinlockview.CustomizationOptionsBundle;
import com.amirarcane.lockscreen.andrognito.pinlockview.IndicatorDots;
import com.amirarcane.lockscreen.andrognito.pinlockview.ItemSpaceDecoration;
import com.amirarcane.lockscreen.andrognito.pinlockview.PinLockAdapter;
import com.amirarcane.lockscreen.andrognito.pinlockview.PinLockListener;
import com.amirarcane.lockscreen.andrognito.pinlockview.ResourceUtils;
import com.amirarcane.lockscreen.andrognito.pinlockview.ShuffleArrayUtils;

public class PinLockView
extends RecyclerView {
    private static final int DEFAULT_PIN_LENGTH = 4;
    private static final int[] DEFAULT_KEY_SET = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
    private String mPin = "";
    private int mPinLength;
    private int mHorizontalSpacing;
    private int mVerticalSpacing;
    private int mTextColor;
    private int mDeleteButtonPressedColor;
    private int mTextSize;
    private int mButtonSize;
    private int mDeleteButtonWidthSize;
    private int mDeleteButtonHeightSize;
    private Drawable mButtonBackgroundDrawable;
    private Drawable mDeleteButtonDrawable;
    private boolean mShowDeleteButton;
    private IndicatorDots mIndicatorDots;
    private PinLockAdapter mAdapter;
    private PinLockListener mPinLockListener;
    private CustomizationOptionsBundle mCustomizationOptionsBundle;
    private int[] mCustomKeySet;
    private PinLockAdapter.OnNumberClickListener mOnNumberClickListener = new PinLockAdapter.OnNumberClickListener(){

        @Override
        public void onNumberClicked(int keyValue) {
            if (PinLockView.this.mPin.length() < PinLockView.this.getPinLength()) {
                PinLockView.this.mPin = PinLockView.this.mPin.concat(String.valueOf(keyValue));
                if (PinLockView.this.isIndicatorDotsAttached()) {
                    PinLockView.this.mIndicatorDots.updateDot(PinLockView.this.mPin.length());
                }
                if (PinLockView.this.mPin.length() == 1) {
                    PinLockView.this.mAdapter.setPinLength(PinLockView.this.mPin.length());
                    PinLockView.this.mAdapter.notifyItemChanged(PinLockView.this.mAdapter.getItemCount() - 1);
                }
                if (PinLockView.this.mPinLockListener != null) {
                    if (PinLockView.this.mPin.length() == PinLockView.this.mPinLength) {
                        PinLockView.this.mPinLockListener.onComplete(PinLockView.this.mPin);
                    } else {
                        PinLockView.this.mPinLockListener.onPinChange(PinLockView.this.mPin.length(), PinLockView.this.mPin);
                    }
                }
            } else if (!PinLockView.this.isShowDeleteButton()) {
                PinLockView.this.resetPinLockView();
                PinLockView.this.mPin = PinLockView.this.mPin.concat(String.valueOf(keyValue));
                if (PinLockView.this.isIndicatorDotsAttached()) {
                    PinLockView.this.mIndicatorDots.updateDot(PinLockView.this.mPin.length());
                }
                if (PinLockView.this.mPinLockListener != null) {
                    PinLockView.this.mPinLockListener.onPinChange(PinLockView.this.mPin.length(), PinLockView.this.mPin);
                }
            } else if (PinLockView.this.mPinLockListener != null) {
                PinLockView.this.mPinLockListener.onComplete(PinLockView.this.mPin);
            }
        }
    };
    private PinLockAdapter.OnDeleteClickListener mOnDeleteClickListener = new PinLockAdapter.OnDeleteClickListener(){

        @Override
        public void onDeleteClicked() {
            if (PinLockView.this.mPin.length() > 0) {
                PinLockView.this.mPin = PinLockView.this.mPin.substring(0, PinLockView.this.mPin.length() - 1);
                if (PinLockView.this.isIndicatorDotsAttached()) {
                    PinLockView.this.mIndicatorDots.updateDot(PinLockView.this.mPin.length());
                }
                if (PinLockView.this.mPin.length() == 0) {
                    PinLockView.this.mAdapter.setPinLength(PinLockView.this.mPin.length());
                    PinLockView.this.mAdapter.notifyItemChanged(PinLockView.this.mAdapter.getItemCount() - 1);
                }
                if (PinLockView.this.mPinLockListener != null) {
                    if (PinLockView.this.mPin.length() == 0) {
                        PinLockView.this.mPinLockListener.onEmpty();
                        PinLockView.this.clearInternalPin();
                    } else {
                        PinLockView.this.mPinLockListener.onPinChange(PinLockView.this.mPin.length(), PinLockView.this.mPin);
                    }
                }
            } else if (PinLockView.this.mPinLockListener != null) {
                PinLockView.this.mPinLockListener.onEmpty();
            }
        }

        @Override
        public void onDeleteLongClicked() {
            PinLockView.this.resetPinLockView();
            if (PinLockView.this.mPinLockListener != null) {
                PinLockView.this.mPinLockListener.onEmpty();
            }
        }
    };

    public PinLockView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public PinLockView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public PinLockView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attributeSet, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.PinLockView);
        try {
            this.mPinLength = typedArray.getInt(R.styleable.PinLockView_pinLength, 4);
            this.mHorizontalSpacing = (int)typedArray.getDimension(R.styleable.PinLockView_keypadHorizontalSpacing, ResourceUtils.getDimensionInPx(this.getContext(), R.dimen.default_horizontal_spacing));
            this.mVerticalSpacing = (int)typedArray.getDimension(R.styleable.PinLockView_keypadVerticalSpacing, ResourceUtils.getDimensionInPx(this.getContext(), R.dimen.default_vertical_spacing));
            this.mTextColor = typedArray.getColor(R.styleable.PinLockView_keypadTextColor, ResourceUtils.getColor(this.getContext(), R.color.text_numberpressed));
            this.mTextSize = (int)typedArray.getDimension(R.styleable.PinLockView_keypadTextSize, ResourceUtils.getDimensionInPx(this.getContext(), R.dimen.default_text_size));
            this.mButtonSize = (int)typedArray.getDimension(R.styleable.PinLockView_keypadButtonSize, ResourceUtils.getDimensionInPx(this.getContext(), R.dimen.default_button_size));
            this.mDeleteButtonWidthSize = (int)typedArray.getDimension(R.styleable.PinLockView_keypadDeleteButtonSize, ResourceUtils.getDimensionInPx(this.getContext(), R.dimen.default_delete_button_size_width));
            this.mDeleteButtonHeightSize = (int)typedArray.getDimension(R.styleable.PinLockView_keypadDeleteButtonSize, ResourceUtils.getDimensionInPx(this.getContext(), R.dimen.default_delete_button_size_height));
            this.mButtonBackgroundDrawable = typedArray.getDrawable(R.styleable.PinLockView_keypadButtonBackgroundDrawable);
            this.mDeleteButtonDrawable = typedArray.getDrawable(R.styleable.PinLockView_keypadDeleteButtonDrawable);
            this.mShowDeleteButton = typedArray.getBoolean(R.styleable.PinLockView_keypadShowDeleteButton, true);
            this.mDeleteButtonPressedColor = typedArray.getColor(R.styleable.PinLockView_keypadDeleteButtonPressedColor, ResourceUtils.getColor(this.getContext(), R.color.text_numberpressed));
        }
        finally {
            typedArray.recycle();
        }
        this.mCustomizationOptionsBundle = new CustomizationOptionsBundle();
        this.mCustomizationOptionsBundle.setTextColor(this.mTextColor);
        this.mCustomizationOptionsBundle.setTextSize(this.mTextSize);
        this.mCustomizationOptionsBundle.setButtonSize(this.mButtonSize);
        this.mCustomizationOptionsBundle.setButtonBackgroundDrawable(this.mButtonBackgroundDrawable);
        this.mCustomizationOptionsBundle.setDeleteButtonDrawable(this.mDeleteButtonDrawable);
        this.mCustomizationOptionsBundle.setDeleteButtonWidthSize(this.mDeleteButtonWidthSize);
        this.mCustomizationOptionsBundle.setDeleteButtonHeightSize(this.mDeleteButtonHeightSize);
        this.mCustomizationOptionsBundle.setShowDeleteButton(this.mShowDeleteButton);
        this.mCustomizationOptionsBundle.setDeleteButtonPressesColor(this.mDeleteButtonPressedColor);
        this.initView();
    }

    private void initView() {
        this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 3));
        this.mAdapter = new PinLockAdapter();
        this.mAdapter.setOnItemClickListener(this.mOnNumberClickListener);
        this.mAdapter.setOnDeleteClickListener(this.mOnDeleteClickListener);
        this.mAdapter.setCustomizationOptions(this.mCustomizationOptionsBundle);
        this.setAdapter(this.mAdapter);
        this.addItemDecoration(new ItemSpaceDecoration(this.mHorizontalSpacing, this.mVerticalSpacing, 3, false));
        this.setOverScrollMode(2);
    }

    public void setTypeFace(Typeface typeFace) {
        this.mAdapter.setTypeFace(typeFace);
    }

    public void setPinLockListener(PinLockListener pinLockListener) {
        this.mPinLockListener = pinLockListener;
    }

    public int getPinLength() {
        return this.mPinLength;
    }

    public void setPinLength(int pinLength) {
        this.mPinLength = pinLength;
        if (this.isIndicatorDotsAttached()) {
            this.mIndicatorDots.setPinLength(pinLength);
        }
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.mCustomizationOptionsBundle.setTextColor(textColor);
        this.mAdapter.notifyDataSetChanged();
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int textSize) {
        this.mTextSize = textSize;
        this.mCustomizationOptionsBundle.setTextSize(textSize);
        this.mAdapter.notifyDataSetChanged();
    }

    public int getButtonSize() {
        return this.mButtonSize;
    }

    public void setButtonSize(int buttonSize) {
        this.mButtonSize = buttonSize;
        this.mCustomizationOptionsBundle.setButtonSize(buttonSize);
        this.mAdapter.notifyDataSetChanged();
    }

    public Drawable getButtonBackgroundDrawable() {
        return this.mButtonBackgroundDrawable;
    }

    public void setButtonBackgroundDrawable(Drawable buttonBackgroundDrawable) {
        this.mButtonBackgroundDrawable = buttonBackgroundDrawable;
        this.mCustomizationOptionsBundle.setButtonBackgroundDrawable(buttonBackgroundDrawable);
        this.mAdapter.notifyDataSetChanged();
    }

    public Drawable getDeleteButtonDrawable() {
        return this.mDeleteButtonDrawable;
    }

    public void setDeleteButtonDrawable(Drawable deleteBackgroundDrawable) {
        this.mDeleteButtonDrawable = deleteBackgroundDrawable;
        this.mCustomizationOptionsBundle.setDeleteButtonDrawable(deleteBackgroundDrawable);
        this.mAdapter.notifyDataSetChanged();
    }

    public int getDeleteButtonWidthSize() {
        return this.mDeleteButtonWidthSize;
    }

    public int getDeleteButtonHeightSize() {
        return this.mDeleteButtonHeightSize;
    }

    public void setDeleteButtonWidthSize(int deleteButtonWidthSize) {
        this.mDeleteButtonWidthSize = deleteButtonWidthSize;
        this.mCustomizationOptionsBundle.setDeleteButtonWidthSize(deleteButtonWidthSize);
        this.mAdapter.notifyDataSetChanged();
    }

    public void setDeleteButtonHeightSize(int deleteButtonHeightSize) {
        this.mDeleteButtonHeightSize = deleteButtonHeightSize;
        this.mCustomizationOptionsBundle.setDeleteButtonWidthSize(deleteButtonHeightSize);
        this.mAdapter.notifyDataSetChanged();
    }

    public boolean isShowDeleteButton() {
        return this.mShowDeleteButton;
    }

    public void setShowDeleteButton(boolean showDeleteButton) {
        this.mShowDeleteButton = showDeleteButton;
        this.mCustomizationOptionsBundle.setShowDeleteButton(showDeleteButton);
        this.mAdapter.notifyDataSetChanged();
    }

    public int getDeleteButtonPressedColor() {
        return this.mDeleteButtonPressedColor;
    }

    public void setDeleteButtonPressedColor(int deleteButtonPressedColor) {
        this.mDeleteButtonPressedColor = deleteButtonPressedColor;
        this.mCustomizationOptionsBundle.setDeleteButtonPressesColor(deleteButtonPressedColor);
        this.mAdapter.notifyDataSetChanged();
    }

    public int[] getCustomKeySet() {
        return this.mCustomKeySet;
    }

    public void setCustomKeySet(int[] customKeySet) {
        this.mCustomKeySet = customKeySet;
        if (this.mAdapter != null) {
            this.mAdapter.setKeyValues(customKeySet);
        }
    }

    public void enableLayoutShuffling() {
        this.mCustomKeySet = ShuffleArrayUtils.shuffle(DEFAULT_KEY_SET);
        if (this.mAdapter != null) {
            this.mAdapter.setKeyValues(this.mCustomKeySet);
        }
    }

    private void clearInternalPin() {
        this.mPin = "";
    }

    public void resetPinLockView() {
        this.clearInternalPin();
        this.mAdapter.setPinLength(this.mPin.length());
        this.mAdapter.notifyItemChanged(this.mAdapter.getItemCount() - 1);
        if (this.mIndicatorDots != null) {
            this.mIndicatorDots.updateDot(this.mPin.length());
        }
    }

    public boolean isIndicatorDotsAttached() {
        return this.mIndicatorDots != null;
    }

    public void attachIndicatorDots(IndicatorDots mIndicatorDots) {
        this.mIndicatorDots = mIndicatorDots;
    }
}

