/*
 * Decompiled with CFR 0.152.
 */
package com.amirarcane.lockscreen.andrognito.pinlockview;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.amirarcane.lockscreen.R;
import com.amirarcane.lockscreen.andrognito.pinlockview.CustomizationOptionsBundle;

public class PinLockAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int VIEW_TYPE_NUMBER = 0;
    private static final int VIEW_TYPE_DELETE = 1;
    private CustomizationOptionsBundle mCustomizationOptionsBundle;
    private OnNumberClickListener mOnNumberClickListener;
    private OnDeleteClickListener mOnDeleteClickListener;
    private int mPinLength;
    private int BUTTON_ANIMATION_DURATION = 150;
    private int[] mKeyValues = this.getAdjustKeyValues(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0});
    private Typeface mTypeface = null;

    public void setTypeFace(Typeface typeFace) {
        this.mTypeface = typeFace;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        if (viewType == 0) {
            View view = inflater.inflate(R.layout.layout_number_item, parent, false);
            viewHolder = new NumberViewHolder(view, this.mTypeface);
        } else {
            View view = inflater.inflate(R.layout.layout_delete_item, parent, false);
            viewHolder = new DeleteViewHolder(view);
        }
        return viewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder.getItemViewType() == 0) {
            NumberViewHolder vh1 = (NumberViewHolder)holder;
            this.configureNumberButtonHolder(vh1, position);
        } else if (holder.getItemViewType() == 1) {
            DeleteViewHolder vh2 = (DeleteViewHolder)holder;
            this.configureDeleteButtonHolder(vh2);
        }
    }

    private void configureNumberButtonHolder(NumberViewHolder holder, int position) {
        if (holder != null) {
            if (position == 9) {
                holder.mNumberButton.setVisibility(8);
            } else {
                holder.mNumberButton.setText((CharSequence)String.valueOf(this.mKeyValues[position]));
                holder.mNumberButton.setVisibility(0);
                holder.mNumberButton.setTag((Object)this.mKeyValues[position]);
            }
            if (this.mCustomizationOptionsBundle != null) {
                holder.mNumberButton.setTextColor(this.mCustomizationOptionsBundle.getTextColor());
                if (this.mCustomizationOptionsBundle.getButtonBackgroundDrawable() != null) {
                    if (Build.VERSION.SDK_INT < 16) {
                        holder.mNumberButton.setBackgroundDrawable(this.mCustomizationOptionsBundle.getButtonBackgroundDrawable());
                    } else {
                        holder.mNumberButton.setBackground(this.mCustomizationOptionsBundle.getButtonBackgroundDrawable());
                    }
                }
                holder.mNumberButton.setTextSize(0, (float)this.mCustomizationOptionsBundle.getTextSize());
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mCustomizationOptionsBundle.getButtonSize(), this.mCustomizationOptionsBundle.getButtonSize());
                holder.mNumberButton.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }

    private void configureDeleteButtonHolder(DeleteViewHolder holder) {
        if (holder != null && this.mCustomizationOptionsBundle.isShowDeleteButton() && this.mPinLength > 0) {
            holder.mButtonImage.setVisibility(0);
            if (this.mCustomizationOptionsBundle.getDeleteButtonDrawable() != null) {
                holder.mButtonImage.setImageDrawable(this.mCustomizationOptionsBundle.getDeleteButtonDrawable());
            }
            holder.mButtonImage.setColorFilter(this.mCustomizationOptionsBundle.getTextColor(), PorterDuff.Mode.SRC_ATOP);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mCustomizationOptionsBundle.getDeleteButtonWidthSize(), this.mCustomizationOptionsBundle.getDeleteButtonHeightSize());
            holder.mButtonImage.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public int getItemCount() {
        return 12;
    }

    public int getItemViewType(int position) {
        if (position == this.getItemCount() - 1) {
            return 1;
        }
        return 0;
    }

    public int getPinLength() {
        return this.mPinLength;
    }

    public void setPinLength(int pinLength) {
        this.mPinLength = pinLength;
    }

    public int[] getKeyValues() {
        return this.mKeyValues;
    }

    public void setKeyValues(int[] keyValues) {
        this.mKeyValues = this.getAdjustKeyValues(keyValues);
        this.notifyDataSetChanged();
    }

    private int[] getAdjustKeyValues(int[] keyValues) {
        int[] adjustedKeyValues = new int[keyValues.length + 1];
        for (int i = 0; i < keyValues.length; ++i) {
            if (i < 9) {
                adjustedKeyValues[i] = keyValues[i];
                continue;
            }
            adjustedKeyValues[i] = -1;
            adjustedKeyValues[i + 1] = keyValues[i];
        }
        return adjustedKeyValues;
    }

    public OnNumberClickListener getOnItemClickListener() {
        return this.mOnNumberClickListener;
    }

    public void setOnItemClickListener(OnNumberClickListener onNumberClickListener) {
        this.mOnNumberClickListener = onNumberClickListener;
    }

    public OnDeleteClickListener getOnDeleteClickListener() {
        return this.mOnDeleteClickListener;
    }

    public void setOnDeleteClickListener(OnDeleteClickListener onDeleteClickListener) {
        this.mOnDeleteClickListener = onDeleteClickListener;
    }

    public CustomizationOptionsBundle getCustomizationOptions() {
        return this.mCustomizationOptionsBundle;
    }

    public void setCustomizationOptions(CustomizationOptionsBundle customizationOptionsBundle) {
        this.mCustomizationOptionsBundle = customizationOptionsBundle;
    }

    private Animation scale() {
        ScaleAnimation scaleAnimation = new ScaleAnimation(0.75f, 1.0f, 0.75f, 1.0f, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setDuration((long)this.BUTTON_ANIMATION_DURATION);
        scaleAnimation.setFillAfter(true);
        return scaleAnimation;
    }

    public class DeleteViewHolder
    extends RecyclerView.ViewHolder {
        LinearLayout mDeleteButton;
        ImageView mButtonImage;

        public DeleteViewHolder(View itemView) {
            super(itemView);
            this.mDeleteButton = (LinearLayout)itemView.findViewById(R.id.button);
            this.mButtonImage = (ImageView)itemView.findViewById(R.id.buttonImage);
            if (PinLockAdapter.this.mCustomizationOptionsBundle.isShowDeleteButton() && PinLockAdapter.this.mPinLength > 0) {
                this.mDeleteButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (PinLockAdapter.this.mOnDeleteClickListener != null) {
                            PinLockAdapter.this.mOnDeleteClickListener.onDeleteClicked();
                        }
                    }
                });
                this.mDeleteButton.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        if (PinLockAdapter.this.mOnDeleteClickListener != null) {
                            PinLockAdapter.this.mOnDeleteClickListener.onDeleteLongClicked();
                        }
                        return true;
                    }
                });
                this.mDeleteButton.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        if (event.getAction() == 0) {
                            DeleteViewHolder.this.mDeleteButton.startAnimation(PinLockAdapter.this.scale());
                        }
                        return false;
                    }
                });
            }
        }
    }

    public class NumberViewHolder
    extends RecyclerView.ViewHolder {
        Button mNumberButton;

        public NumberViewHolder(View itemView, Typeface font) {
            super(itemView);
            this.mNumberButton = (Button)itemView.findViewById(R.id.button);
            if (font != null) {
                this.mNumberButton.setTypeface(font);
            }
            this.mNumberButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PinLockAdapter.this.mOnNumberClickListener != null) {
                        PinLockAdapter.this.mOnNumberClickListener.onNumberClicked((Integer)v.getTag());
                    }
                }
            });
            this.mNumberButton.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 0) {
                        NumberViewHolder.this.mNumberButton.startAnimation(PinLockAdapter.this.scale());
                    }
                    return false;
                }
            });
        }
    }

    public static interface OnDeleteClickListener {
        public void onDeleteClicked();

        public void onDeleteLongClicked();
    }

    public static interface OnNumberClickListener {
        public void onNumberClicked(int var1);
    }
}

