/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.jersey.JerseyServletResponseWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyHandlerFilter
implements Filter,
Container {
    public static final String JERSEY_SERVLET_REQUEST_PROPERTY = "com.amazonaws.serverless.jersey.servletRequest";
    public static final String JERSEY_SERVLET_RESPONSE_PROPERTY = "com.amazonaws.serverless.jersey.servletResponse";
    private ApplicationHandler jersey;
    private Application app;
    private Logger log = LoggerFactory.getLogger(JerseyHandlerFilter.class);
    private URI baseUri;

    JerseyHandlerFilter(Application jaxApplication) {
        Timer.start((String)"JERSEY_FILTER_CONSTRUCTOR");
        this.app = jaxApplication;
        this.jersey = new ApplicationHandler(this.app);
        this.jersey.onStartup((Container)this);
        Timer.stop((String)"JERSEY_FILTER_CONSTRUCTOR");
    }

    public void init(FilterConfig filterConfig) {
        this.log.info("Initialize Jersey application handler");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Timer.start((String)"JERSEY_FILTER_DOFILTER");
        CountDownLatch jerseyLatch = new CountDownLatch(1);
        ContainerRequest req = this.servletRequestToContainerRequest(servletRequest);
        req.setWriter((ContainerResponseWriter)new JerseyServletResponseWriter(servletResponse, jerseyLatch));
        req.setProperty(JERSEY_SERVLET_RESPONSE_PROPERTY, (Object)servletResponse);
        this.jersey.handle(req);
        try {
            jerseyLatch.await();
        }
        catch (InterruptedException e) {
            this.log.error("Interrupted while processing request", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
        Timer.stop((String)"JERSEY_FILTER_DOFILTER");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        this.log.info("Jersey filter destroy");
        this.jersey.onShutdown((Container)this);
    }

    @SuppressFBWarnings(value={"SERVLET_HEADER", "SERVLET_QUERY_STRING"})
    private ContainerRequest servletRequestToContainerRequest(ServletRequest request) {
        Timer.start((String)"JERSEY_SERVLET_REQUEST_TO_CONTAINER");
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        if (this.baseUri == null) {
            this.baseUri = this.getBaseUri(request, "/");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path(servletRequest.getPathInfo());
        uriBuilder.replaceQuery(servletRequest.getQueryString());
        MapPropertiesDelegate apiGatewayProperties = new MapPropertiesDelegate();
        apiGatewayProperties.setProperty("com.amazonaws.apigateway.request.context", servletRequest.getAttribute("com.amazonaws.apigateway.request.context"));
        apiGatewayProperties.setProperty("com.amazonaws.apigateway.stage.variables", servletRequest.getAttribute("com.amazonaws.apigateway.stage.variables"));
        apiGatewayProperties.setProperty("com.amazonaws.lambda.context", servletRequest.getAttribute("com.amazonaws.lambda.context"));
        apiGatewayProperties.setProperty(JERSEY_SERVLET_REQUEST_PROPERTY, (Object)servletRequest);
        ContainerRequest requestContext = new ContainerRequest(null, uriBuilder.build(new Object[0]), servletRequest.getMethod().toUpperCase(Locale.ENGLISH), (SecurityContext)servletRequest.getAttribute("com.amazonaws.serverless.jaxrs.securityContext"), (PropertiesDelegate)apiGatewayProperties);
        try {
            ServletInputStream requestInputStream = servletRequest.getInputStream();
            if (requestInputStream != null) {
                requestContext.setEntityStream((InputStream)requestInputStream);
            }
        }
        catch (IOException e) {
            this.log.error("Could not read input stream from request", (Throwable)e);
            throw new RuntimeException("Could not read request input stream", e);
        }
        Enumeration headerNames = servletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerKey = (String)headerNames.nextElement();
            requestContext.getHeaders().add((Object)headerKey, (Object)servletRequest.getHeader(headerKey));
        }
        Timer.stop((String)"JERSEY_SERVLET_REQUEST_TO_CONTAINER");
        return requestContext;
    }

    @SuppressFBWarnings(value={"SERVLET_SERVER_NAME"})
    private URI getBaseUri(ServletRequest request, String basePath) {
        String finalBasePath = basePath;
        if (!finalBasePath.startsWith("/")) {
            finalBasePath = "/" + finalBasePath;
        }
        String uriString = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + finalBasePath;
        return UriBuilder.fromUri((String)uriString).build(new Object[0]);
    }

    public ResourceConfig getConfiguration() {
        return this.jersey.getConfiguration();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.jersey;
    }

    public void reload() {
        Timer.start((String)"JERSEY_RELOAD_DEFAULT");
        this.jersey.onShutdown((Container)this);
        this.jersey = new ApplicationHandler(this.app);
        this.jersey.onReload((Container)this);
        this.jersey.onStartup((Container)this);
        Timer.stop((String)"JERSEY_RELOAD_DEFAULT");
    }

    public void reload(ResourceConfig resourceConfig) {
        Timer.start((String)"JERSEY_RELOAD_CONFIG");
        this.jersey.onShutdown((Container)this);
        this.app = resourceConfig;
        this.jersey = new ApplicationHandler((Application)resourceConfig);
        this.jersey.onReload((Container)this);
        this.jersey.onStartup((Container)this);
        Timer.stop((String)"JERSEY_RELOAD_CONFIG");
    }
}

