/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.util.Config;
import com.amazonaws.secretsmanager.util.JDBCSecretCacheBuilderProvider;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

public abstract class AWSSecretsManagerDriver
implements Driver {
    public static final String SCHEME = "jdbc-secretsmanager";
    public static final int MAX_RETRY = 5;
    public static final String PROPERTY_PREFIX = "drivers";
    public static final String INVALID_SECRET_STRING_JSON = "Could not parse SecretString JSON";
    private SecretCache secretCache;
    private String realDriverClass;
    private Config config;
    private ObjectMapper mapper = new ObjectMapper();

    protected AWSSecretsManagerDriver() {
        this(new JDBCSecretCacheBuilderProvider().build());
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected AWSSecretsManagerDriver(SecretCache cache) {
        this.secretCache = cache;
        this.setProperties();
        AWSSecretsManagerDriver.register(this);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected AWSSecretsManagerDriver(SecretsManagerClientBuilder builder) {
        this(new SecretCache(builder));
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected AWSSecretsManagerDriver(SecretsManagerClient client) {
        this(new SecretCache(client));
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    protected AWSSecretsManagerDriver(SecretCacheConfiguration cacheConfig) {
        this(new SecretCache(cacheConfig));
    }

    private void setProperties() {
        this.config = Config.loadMainConfig().getSubconfig("drivers." + this.getPropertySubprefix());
        if (this.config == null) {
            this.realDriverClass = this.getDefaultDriverClass();
            return;
        }
        this.realDriverClass = this.config.getStringPropertyWithDefault("realDriverClass", this.getDefaultDriverClass());
    }

    private void loadRealDriver() {
        try {
            Class.forName(this.realDriverClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load real driver with name, \"" + this.realDriverClass + "\".", e);
        }
    }

    private static void shutdown(AWSSecretsManagerDriver driver) {
        driver.secretCache.close();
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"})
    protected static void register(AWSSecretsManagerDriver driver) {
        try {
            DriverManager.registerDriver(driver, () -> AWSSecretsManagerDriver.shutdown(driver));
        }
        catch (SQLException e) {
            throw new RuntimeException("Driver could not be registered.", e);
        }
    }

    public abstract String getPropertySubprefix();

    private String unwrapUrl(String jdbcUrl) {
        if (!jdbcUrl.startsWith(SCHEME)) {
            throw new IllegalArgumentException("JDBC URL is malformed. Must use scheme, \"jdbc-secretsmanager\".");
        }
        return jdbcUrl.replaceFirst(SCHEME, "jdbc");
    }

    public Driver getWrappedDriver() {
        this.loadRealDriver();
        Enumeration<Driver> availableDrivers = DriverManager.getDrivers();
        while (availableDrivers.hasMoreElements()) {
            Driver driver = availableDrivers.nextElement();
            if (!driver.getClass().getName().equals(this.realDriverClass)) continue;
            return driver;
        }
        throw new IllegalStateException("No Driver has been registered with name, " + this.realDriverClass + ". Please check your system properties or " + "secretsmanager.properties" + " for typos. Also ensure that the Driver registers itself.");
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("url cannot be null.");
        }
        if (url.startsWith(SCHEME)) {
            return this.getWrappedDriver().acceptsURL(this.unwrapUrl(url));
        }
        return !url.startsWith("jdbc:");
    }

    public abstract boolean isExceptionDueToAuthenticationError(Exception var1);

    public abstract String constructUrlFromEndpointPortDatabase(String var1, String var2, String var3);

    public abstract String getDefaultDriverClass();

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"})
    private Connection connectWithSecret(String unwrappedUrl, Properties info, String credentialsSecretId) throws SQLException, InterruptedException {
        int retryCount = 0;
        while (retryCount++ <= 5) {
            String secretString = this.secretCache.getSecretString(credentialsSecretId);
            Properties updatedInfo = new Properties(info);
            try {
                JsonNode jsonObject = this.mapper.readTree(secretString);
                updatedInfo.setProperty("user", jsonObject.get("username").asText());
                updatedInfo.setProperty("password", jsonObject.get("password").asText());
            }
            catch (IOException e) {
                throw new RuntimeException(INVALID_SECRET_STRING_JSON);
            }
            try {
                return this.getWrappedDriver().connect(unwrappedUrl, updatedInfo);
            }
            catch (Exception e) {
                if (this.isExceptionDueToAuthenticationError(e)) {
                    boolean refreshSuccess = this.secretCache.refreshNow(credentialsSecretId);
                    if (refreshSuccess) continue;
                    throw e;
                }
                throw e;
            }
        }
        throw new SQLException("Connect failed to authenticate: reached max connection retries");
    }

    @Override
    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"})
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String unwrappedUrl = "";
        if (url.startsWith(SCHEME)) {
            unwrappedUrl = this.unwrapUrl(url);
        } else {
            try {
                String secretString = this.secretCache.getSecretString(url);
                if (StringUtils.isBlank((CharSequence)secretString)) {
                    throw new IllegalArgumentException("URL " + url + " is not a valid URL starting with scheme " + SCHEME + " or a valid retrievable secret ID ");
                }
                JsonNode jsonObject = this.mapper.readTree(secretString);
                String endpoint = jsonObject.get("host").asText();
                JsonNode portNode = jsonObject.get("port");
                String port = portNode == null ? null : portNode.asText();
                JsonNode dbnameNode = jsonObject.get("dbname");
                String dbname = dbnameNode == null ? null : dbnameNode.asText();
                unwrappedUrl = this.constructUrlFromEndpointPortDatabase(endpoint, port, dbname);
            }
            catch (IOException e) {
                throw new RuntimeException(INVALID_SECRET_STRING_JSON);
            }
        }
        if (info != null && info.getProperty("user") != null) {
            String credentialsSecretId = info.getProperty("user");
            try {
                return this.connectWithSecret(unwrappedUrl, info, credentialsSecretId);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getWrappedDriver().connect(unwrappedUrl, info);
    }

    @Override
    public int getMajorVersion() {
        return this.getWrappedDriver().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.getWrappedDriver().getMinorVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getWrappedDriver().getParentLogger();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.getWrappedDriver().getPropertyInfo(this.unwrapUrl(url), info);
    }

    @Override
    public boolean jdbcCompliant() {
        return this.getWrappedDriver().jdbcCompliant();
    }
}

