/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching;

import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.caching.cache.LRUCache;
import com.amazonaws.secretsmanager.caching.cache.SecretCacheItem;
import java.nio.ByteBuffer;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public class SecretCache
implements AutoCloseable {
    private final LRUCache<String, SecretCacheItem> cache;
    private final SecretCacheConfiguration config;
    private final SecretsManagerClient client;

    public SecretCache() {
        this(SecretsManagerClient.builder());
    }

    public SecretCache(SecretsManagerClientBuilder builder) {
        this(new SecretCacheConfiguration().withClient((SecretsManagerClient)((SecretsManagerClientBuilder)builder.overrideConfiguration((ClientOverrideConfiguration)builder.overrideConfiguration().toBuilder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)"AwsSecretCache/2.1.0").build())).build()));
    }

    public SecretCache(SecretsManagerClient client) {
        this(new SecretCacheConfiguration().withClient(client));
    }

    public SecretCache(SecretCacheConfiguration config) {
        if (null == config) {
            config = new SecretCacheConfiguration();
        }
        this.cache = new LRUCache(config.getMaxCacheSize());
        this.config = config;
        ClientOverrideConfiguration defaultOverride = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)"AwsSecretCache/2.1.0").build();
        this.client = config.getClient() != null ? config.getClient() : (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().overrideConfiguration(defaultOverride)).build();
    }

    private SecretCacheItem getCachedSecret(String secretId) {
        SecretCacheItem secret = this.cache.get(secretId);
        if (null == secret) {
            this.cache.putIfAbsent(secretId, new SecretCacheItem(secretId, this.client, this.config));
            secret = this.cache.get(secretId);
        }
        return secret;
    }

    public String getSecretString(String secretId) {
        SecretCacheItem secret = this.getCachedSecret(secretId);
        GetSecretValueResponse gsv = secret.getSecretValue();
        if (null == gsv) {
            return null;
        }
        return gsv.secretString();
    }

    public ByteBuffer getSecretBinary(String secretId) {
        SecretCacheItem secret = this.getCachedSecret(secretId);
        GetSecretValueResponse gsv = secret.getSecretValue();
        if (null == gsv) {
            return null;
        }
        return gsv.secretBinary().asByteBuffer();
    }

    public boolean refreshNow(String secretId) throws InterruptedException {
        SecretCacheItem secret = this.getCachedSecret(secretId);
        return secret.refreshNow();
    }

    @Override
    public void close() {
        this.cache.clear();
    }
}

