/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsProxy;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import java.util.concurrent.ExecutorService;

public class StreamsWorkerFactory {
    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, ExecutorService execService) {
        AmazonDynamoDBStreamsAdapterClient streamsClient = new AmazonDynamoDBStreamsAdapterClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).execService(execService).kinesisProxy((IKinesisProxy)StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).kinesisProxy((IKinesisProxy)StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).execService(execService).kinesisProxy((IKinesisProxy)StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient(dynamoDBClient).metricsFactory(metricsFactory).execService(execService).kinesisProxy((IKinesisProxy)StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).cloudWatchClient((AmazonCloudWatch)cloudWatchClient).kinesisProxy((IKinesisProxy)StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).cloudWatchClient((AmazonCloudWatch)cloudWatchClient).execService(execService).kinesisProxy((IKinesisProxy)StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient((AmazonKinesis)streamsClient).dynamoDBClient((AmazonDynamoDB)dynamoDBClient).metricsFactory(metricsFactory).execService(execService).kinesisProxy((IKinesisProxy)StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    private static DynamoDBStreamsProxy getDynamoDBStreamsProxy(KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient) {
        return new DynamoDBStreamsProxy.Builder(config.getStreamName(), config.getKinesisCredentialsProvider(), (AmazonKinesis)streamsClient).build();
    }
}

