/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import java.time.Instant;
import java.util.List;
import software.amazon.codeguruprofilerjavaagent.profile.ClassSummary;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSettings;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSnapshot;

public final class HeapSummary {
    private final HeapSnapshot latestSnapshot;

    private HeapSummary(HeapSnapshot latestSnapshot) {
        this.latestSnapshot = latestSnapshot;
    }

    HeapSnapshot getLatestSnapshot() {
        return this.latestSnapshot;
    }

    public static class Builder {
        private HeapSnapshot latestSnapshot;

        public Builder capture(Instant captureTimestamp, long uptimeMillis, Long maxHeapSizeBytes, Long heapUsedBytes, List<ClassSummary> classSummaries) {
            if (this.latestSnapshot == null || captureTimestamp.isAfter(this.latestSnapshot.getCaptureTimestamp())) {
                this.latestSnapshot = new HeapSnapshot(captureTimestamp, uptimeMillis, new HeapSettings(maxHeapSizeBytes), heapUsedBytes, classSummaries);
            }
            return this;
        }

        public Builder clear() {
            this.latestSnapshot = null;
            return this;
        }

        public HeapSummary build() {
            return new HeapSummary(this.latestSnapshot);
        }
    }
}

