/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codedeploy;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.codedeploy.AmazonCodeDeployClient;
import com.amazonaws.services.codedeploy.model.GetApplicationRequest;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class AWSClients {
    private static final int ARN_ACCOUNT_ID_INDEX = 4;
    public final AmazonCodeDeployClient codedeploy;
    public final AmazonS3Client s3;
    private final String region;
    private final String proxyHost;
    private final int proxyPort;

    public AWSClients(String region, AWSCredentials credentials, String proxyHost, int proxyPort) {
        this.region = region;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        ClientConfiguration clientCfg = new ClientConfiguration();
        if (proxyHost != null && proxyPort > 0) {
            clientCfg.setProxyHost(proxyHost);
            clientCfg.setProxyPort(proxyPort);
        }
        this.s3 = credentials != null ? new AmazonS3Client(credentials, clientCfg) : new AmazonS3Client(clientCfg);
        this.codedeploy = credentials != null ? new AmazonCodeDeployClient(credentials, clientCfg) : new AmazonCodeDeployClient(clientCfg);
        this.codedeploy.setRegion(Region.getRegion((Regions)Regions.fromName((String)this.region)));
        this.s3.setRegion(Region.getRegion((Regions)Regions.fromName((String)this.region)));
    }

    public static AWSClients fromDefaultCredentialChain(String region, String proxyHost, int proxyPort) {
        return new AWSClients(region, null, proxyHost, proxyPort);
    }

    public static AWSClients fromIAMRole(String region, String iamRole, String externalId, String proxyHost, int proxyPort) {
        return new AWSClients(region, AWSClients.getCredentials(iamRole, externalId), proxyHost, proxyPort);
    }

    public static AWSClients fromBasicCredentials(String region, String awsAccessKey, String awsSecretKey, String proxyHost, int proxyPort) {
        return new AWSClients(region, (AWSCredentials)new BasicAWSCredentials(awsAccessKey, awsSecretKey), proxyHost, proxyPort);
    }

    public static String getAccountId(String proxyHost, int proxyPort) {
        String arn;
        block3: {
            arn = "";
            try {
                ClientConfiguration clientCfg = new ClientConfiguration();
                if (proxyHost != null && proxyPort > 0) {
                    clientCfg.setProxyHost(proxyHost);
                    clientCfg.setProxyPort(proxyPort);
                }
                AmazonIdentityManagementClient iam = new AmazonIdentityManagementClient(clientCfg);
                GetUserResult user = iam.getUser();
                arn = user.getUser().getArn();
            }
            catch (AmazonServiceException e) {
                String msg;
                int arnIdx;
                if (e.getErrorCode().compareTo("AccessDenied") != 0 || (arnIdx = (msg = e.getMessage()).indexOf("arn:aws")) == -1) break block3;
                int arnSpace = msg.indexOf(" ", arnIdx);
                arn = msg.substring(arnIdx, arnSpace);
            }
        }
        String accountId = arn.split(":")[4];
        return accountId;
    }

    public void testConnection(String s3bucket, String codeDeployApplication) throws Exception {
        String testKey = "tmp-" + UUID.randomUUID() + ".txt";
        this.s3.putObject(s3bucket, testKey, this.createTestFile());
        this.codedeploy.getApplication(new GetApplicationRequest().withApplicationName(codeDeployApplication));
    }

    private File createTestFile() throws IOException {
        File file = File.createTempFile("codedeploy-jenkins-plugin", ".txt");
        file.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        writer.write("");
        ((Writer)writer).close();
        return file;
    }

    private static AWSCredentials getCredentials(String iamRole, String externalId) {
        if (StringUtils.isEmpty((String)iamRole)) {
            return null;
        }
        AWSSecurityTokenServiceClient sts = new AWSSecurityTokenServiceClient();
        int credsDuration = 13500;
        if (credsDuration > 3600) {
            credsDuration = 3600;
        }
        AssumeRoleResult assumeRoleResult = sts.assumeRole(new AssumeRoleRequest().withRoleArn(iamRole).withExternalId(externalId).withDurationSeconds(Integer.valueOf(credsDuration)).withRoleSessionName("jenkins-codedeploy-plugin"));
        Credentials stsCredentials = assumeRoleResult.getCredentials();
        BasicSessionCredentials credentials = new BasicSessionCredentials(stsCredentials.getAccessKeyId(), stsCredentials.getSecretAccessKey(), stsCredentials.getSessionToken());
        return credentials;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }
}

