/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.sql;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Namespace;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.sql.ConnectionInfo;
import com.amazonaws.xray.sql.OracleConnectionUrlParser;
import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlSubsegments {
    private static final Log logger = LogFactory.getLog(SqlSubsegments.class);
    private static WeakConcurrentMap<Connection, ConnectionInfo> connMap = new WeakConcurrentMap.WithInlinedExpunction();
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String DRIVER_VERSION = "driver_version";
    public static final String DATABASE_TYPE = "database_type";
    public static final String DATABASE_VERSION = "database_version";
    public static final String SANITIZED_QUERY = "sanitized_query";
    public static final String DEFAULT_DATABASE_NAME = "database";

    public static Subsegment forQuery(Connection connection, @Nullable String query) {
        DatabaseMetaData metadata;
        ConnectionInfo connectionInfo = (ConnectionInfo)connMap.get((Object)connection);
        String subsegmentName = DEFAULT_DATABASE_NAME;
        try {
            metadata = connection.getMetaData();
            String connUrl = metadata.getURL();
            if (connectionInfo == null && connUrl != null && connUrl.contains("jdbc:oracle")) {
                connectionInfo = OracleConnectionUrlParser.parseUrl(connUrl, new ConnectionInfo.Builder());
                connMap.put((Object)connection, (Object)connectionInfo);
            } else if (connectionInfo == null) {
                connectionInfo = new ConnectionInfo.Builder().build();
            }
            String database = connectionInfo.getDbName() != null ? connectionInfo.getDbName() : (connection.getCatalog() != null ? connection.getCatalog() : DEFAULT_DATABASE_NAME);
            String host = null;
            if (connectionInfo.getHost() != null) {
                host = connectionInfo.getHost();
            } else if (connUrl != null) {
                try {
                    host = new URI(new URI(connUrl).getSchemeSpecificPart()).getHost();
                }
                catch (URISyntaxException e) {
                    logger.debug((Object)"Unable to parse database URI. Falling back to default 'database' for subsegment name.", (Throwable)e);
                }
            }
            subsegmentName = database + (host != null ? "@" + host : "");
        }
        catch (SQLException e) {
            logger.debug((Object)"Encountered exception while retrieving metadata for SQL subsegment , starting blank subsegment instead");
            return AWSXRay.beginSubsegment((String)subsegmentName);
        }
        Subsegment subsegment = AWSXRay.beginSubsegment((String)subsegmentName);
        subsegment.setNamespace(Namespace.REMOTE.toString());
        try {
            SqlSubsegments.putSqlIfNotNull(subsegment, URL, connectionInfo.getSanitizedUrl() != null ? connectionInfo.getSanitizedUrl() : metadata.getURL());
            SqlSubsegments.putSqlIfNotNull(subsegment, USER, connectionInfo.getUser() != null ? connectionInfo.getUser() : metadata.getUserName());
            SqlSubsegments.putSqlIfNotNull(subsegment, DRIVER_VERSION, metadata.getDriverVersion());
            SqlSubsegments.putSqlIfNotNull(subsegment, DATABASE_TYPE, metadata.getDatabaseProductName());
            SqlSubsegments.putSqlIfNotNull(subsegment, DATABASE_VERSION, metadata.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            logger.debug((Object)"Encountered exception while populating SQL subsegment metadata", (Throwable)e);
        }
        SqlSubsegments.putSqlIfNotNull(subsegment, SANITIZED_QUERY, query);
        return subsegment;
    }

    private static void putSqlIfNotNull(Subsegment subsegment, String key, String value) {
        if (key != null && value != null) {
            subsegment.putSql(key, (Object)value);
        }
    }

    static void setConnMap(WeakConcurrentMap<Connection, ConnectionInfo> connMap) {
        SqlSubsegments.connMap = connMap;
    }

    private SqlSubsegments() {
    }
}

