/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.sql;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Namespace;
import com.amazonaws.xray.entities.Subsegment;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TracingStatement {
    private static final Log logger = LogFactory.getLog(TracingStatement.class);

    public static Statement decorateStatement(Statement statement) {
        return (Statement)Proxy.newProxyInstance(TracingStatement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new TracingStatementHandler(statement, null));
    }

    public static PreparedStatement decoratePreparedStatement(PreparedStatement statement, String sql) {
        return (PreparedStatement)Proxy.newProxyInstance(TracingStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new TracingStatementHandler(statement, sql));
    }

    public static CallableStatement decorateCallableStatement(CallableStatement statement, String sql) {
        return (CallableStatement)Proxy.newProxyInstance(TracingStatement.class.getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new TracingStatementHandler(statement, sql));
    }

    private static class TracingStatementHandler
    implements InvocationHandler {
        private static final String DEFAULT_DATABASE_NAME = "database";
        private static final String EXECUTE = "execute";
        private static final String EXECUTE_QUERY = "executeQuery";
        private static final String EXECUTE_UPDATE = "executeUpdate";
        private static final String EXECUTE_BATCH = "executeBatch";
        private static final String URL = "url";
        private static final String USER = "user";
        private static final String DRIVER_VERSION = "driver_version";
        private static final String DATABASE_TYPE = "database_type";
        private static final String DATABASE_VERSION = "database_version";
        private final Statement delegate;
        private final String sql;

        TracingStatementHandler(Statement statement, String sql) {
            this.delegate = statement;
            this.sql = sql;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.isExecution(method)) {
                return method.invoke((Object)this.delegate, args);
            }
            Subsegment subsegment = this.createSubsegment();
            if (subsegment == null) {
                return method.invoke((Object)this.delegate, args);
            }
            logger.debug((Object)"Invoking statement execution with X-Ray tracing.");
            try {
                Object object = method.invoke((Object)this.delegate, args);
                return object;
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)t;
                    if (ite.getTargetException() != null) {
                        subsegment.addException(ite.getTargetException());
                        throw ite.getTargetException();
                    }
                    if (ite.getCause() != null) {
                        subsegment.addException(ite.getCause());
                        throw ite.getCause();
                    }
                    subsegment.addException((Throwable)ite);
                    throw ite;
                }
                subsegment.addException(t);
                throw t;
            }
            finally {
                AWSXRay.endSubsegment();
            }
        }

        private boolean isExecution(Method method) {
            return EXECUTE.equals(method.getName()) || EXECUTE_QUERY.equals(method.getName()) || EXECUTE_UPDATE.equals(method.getName()) || EXECUTE_BATCH.equals(method.getName());
        }

        private Subsegment createSubsegment() {
            try {
                Connection connection = this.delegate.getConnection();
                DatabaseMetaData metadata = connection.getMetaData();
                String subsegmentName = DEFAULT_DATABASE_NAME;
                try {
                    URI normalizedURI = new URI(new URI(metadata.getURL()).getSchemeSpecificPart());
                    subsegmentName = connection.getCatalog() + "@" + normalizedURI.getHost();
                }
                catch (URISyntaxException e) {
                    logger.warn((Object)"Unable to parse database URI. Falling back to default 'database' for subsegment name.", (Throwable)e);
                }
                Subsegment subsegment = AWSXRay.beginSubsegment((String)subsegmentName);
                if (subsegment == null) {
                    return null;
                }
                subsegment.setNamespace(Namespace.REMOTE.toString());
                HashMap<String, String> sqlParams = new HashMap<String, String>();
                sqlParams.put(URL, metadata.getURL());
                sqlParams.put(USER, metadata.getUserName());
                sqlParams.put(DRIVER_VERSION, metadata.getDriverVersion());
                sqlParams.put(DATABASE_TYPE, metadata.getDatabaseProductName());
                sqlParams.put(DATABASE_VERSION, metadata.getDatabaseProductVersion());
                subsegment.putAllSql(sqlParams);
                return subsegment;
            }
            catch (SQLException exception) {
                logger.warn((Object)"Failed to create X-Ray subsegment for the statement execution.", (Throwable)exception);
                return null;
            }
        }
    }
}

